/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.graphics.Insets;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.DrawableCompat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class DrawableUtils {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] EMPTY_STATE_SET = new int[0];
    public static final Rect INSETS_NONE = new Rect();

    private DrawableUtils() {
    }

    public static @NonNull Rect getOpticalBounds(@NonNull Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 29) {
            Insets insets = Api29Impl.getOpticalInsets(drawable2);
            return new Rect(insets.left, insets.top, insets.right, insets.bottom);
        }
        return Api18Impl.getOpticalInsets(DrawableCompat.unwrap((Drawable)drawable2));
    }

    static void fixDrawable(@NonNull Drawable drawable2) {
        String className = drawable2.getClass().getName();
        if (Build.VERSION.SDK_INT == 21 && "android.graphics.drawable.VectorDrawable".equals(className)) {
            DrawableUtils.forceDrawableStateChange(drawable2);
        } else if (Build.VERSION.SDK_INT >= 29 && Build.VERSION.SDK_INT < 31 && "android.graphics.drawable.ColorStateListDrawable".equals(className)) {
            DrawableUtils.forceDrawableStateChange(drawable2);
        }
    }

    @Deprecated
    public static boolean canSafelyMutateDrawable(@NonNull Drawable drawable2) {
        return true;
    }

    private static void forceDrawableStateChange(Drawable drawable2) {
        int[] originalState = drawable2.getState();
        if (originalState == null || originalState.length == 0) {
            drawable2.setState(CHECKED_STATE_SET);
        } else {
            drawable2.setState(EMPTY_STATE_SET);
        }
        drawable2.setState(originalState);
    }

    public static PorterDuff.Mode parseTintMode(int value, PorterDuff.Mode defaultMode) {
        switch (value) {
            case 3: {
                return PorterDuff.Mode.SRC_OVER;
            }
            case 5: {
                return PorterDuff.Mode.SRC_IN;
            }
            case 9: {
                return PorterDuff.Mode.SRC_ATOP;
            }
            case 14: {
                return PorterDuff.Mode.MULTIPLY;
            }
            case 15: {
                return PorterDuff.Mode.SCREEN;
            }
            case 16: {
                return PorterDuff.Mode.ADD;
            }
        }
        return defaultMode;
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        static Insets getOpticalInsets(Drawable drawable2) {
            return drawable2.getOpticalInsets();
        }
    }

    static class Api18Impl {
        private static final boolean sReflectionSuccessful;
        private static final Method sGetOpticalInsets;
        private static final Field sLeft;
        private static final Field sTop;
        private static final Field sRight;
        private static final Field sBottom;

        private Api18Impl() {
        }

        static @NonNull Rect getOpticalInsets(@NonNull Drawable drawable2) {
            if (Build.VERSION.SDK_INT < 29 && sReflectionSuccessful) {
                try {
                    Object insets = sGetOpticalInsets.invoke((Object)drawable2, new Object[0]);
                    if (insets != null) {
                        return new Rect(sLeft.getInt(insets), sTop.getInt(insets), sRight.getInt(insets), sBottom.getInt(insets));
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return INSETS_NONE;
        }

        static {
            Method getOpticalInsets = null;
            Field left = null;
            Field top = null;
            Field right = null;
            Field bottom = null;
            boolean success = false;
            try {
                Class<?> insets = Class.forName("android.graphics.Insets");
                getOpticalInsets = Drawable.class.getMethod("getOpticalInsets", new Class[0]);
                left = insets.getField("left");
                top = insets.getField("top");
                right = insets.getField("right");
                bottom = insets.getField("bottom");
                success = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (success) {
                sGetOpticalInsets = getOpticalInsets;
                sLeft = left;
                sTop = top;
                sRight = right;
                sBottom = bottom;
                sReflectionSuccessful = true;
            } else {
                sGetOpticalInsets = null;
                sLeft = null;
                sTop = null;
                sRight = null;
                sBottom = null;
                sReflectionSuccessful = false;
            }
        }
    }
}

