/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.ResourceManagerInternal;
import androidx.appcompat.widget.ResourcesWrapper;
import java.lang.ref.WeakReference;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class VectorEnabledTintResources
extends ResourcesWrapper {
    private static boolean sCompatVectorFromResourcesEnabled = false;
    public static final int MAX_SDK_WHERE_REQUIRED = 20;
    private final WeakReference<Context> mContextRef;

    public static boolean shouldBeUsed() {
        return VectorEnabledTintResources.isCompatVectorFromResourcesEnabled() && Build.VERSION.SDK_INT <= 20;
    }

    public VectorEnabledTintResources(@NonNull Context context, @NonNull Resources res) {
        super(res);
        this.mContextRef = new WeakReference<Context>(context);
    }

    @Override
    public Drawable getDrawable(int id) throws Resources.NotFoundException {
        Context context = (Context)this.mContextRef.get();
        if (context != null) {
            return ResourceManagerInternal.get().onDrawableLoadedFromResources(context, this, id);
        }
        return this.getDrawableCanonical(id);
    }

    public static void setCompatVectorFromResourcesEnabled(boolean enabled) {
        sCompatVectorFromResourcesEnabled = enabled;
    }

    public static boolean isCompatVectorFromResourcesEnabled() {
        return sCompatVectorFromResourcesEnabled;
    }
}

