/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.LongPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.MetadataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.PropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.SerializerClass;
import androidx.appsearch.compiler.annotationwrapper.StringPropertyAnnotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0002+,B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\tH\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J;\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u001d2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001e\u00a8\u0006-"}, d2={"Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "", "annotation", "Landroidx/appsearch/compiler/annotationwrapper/PropertyAnnotation;", "element", "Ljavax/lang/model/element/Element;", "elementTypeCategory", "Landroidx/appsearch/compiler/AnnotatedGetterOrField$ElementTypeCategory;", "componentType", "Ljavax/lang/model/type/TypeMirror;", "normalizedName", "", "<init>", "(Landroidx/appsearch/compiler/annotationwrapper/PropertyAnnotation;Ljavax/lang/model/element/Element;Landroidx/appsearch/compiler/AnnotatedGetterOrField$ElementTypeCategory;Ljavax/lang/model/type/TypeMirror;Ljava/lang/String;)V", "getAnnotation", "()Landroidx/appsearch/compiler/annotationwrapper/PropertyAnnotation;", "getElement", "()Ljavax/lang/model/element/Element;", "getElementTypeCategory", "()Landroidx/appsearch/compiler/AnnotatedGetterOrField$ElementTypeCategory;", "getComponentType", "()Ljavax/lang/model/type/TypeMirror;", "getNormalizedName", "()Ljava/lang/String;", "jvmType", "getJvmType", "jvmName", "getJvmName", "isGetter", "", "()Z", "isField", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "ElementTypeCategory", "Companion", "appsearch-compiler"})
public final class AnnotatedGetterOrField {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PropertyAnnotation annotation;
    @NotNull
    private final Element element;
    @NotNull
    private final ElementTypeCategory elementTypeCategory;
    @NotNull
    private final TypeMirror componentType;
    @NotNull
    private final String normalizedName;

    public AnnotatedGetterOrField(@NotNull PropertyAnnotation annotation, @NotNull Element element, @NotNull ElementTypeCategory elementTypeCategory, @NotNull TypeMirror componentType, @NotNull String normalizedName) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)elementTypeCategory), (String)"elementTypeCategory");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)normalizedName, (String)"normalizedName");
        this.annotation = annotation;
        this.element = element;
        this.elementTypeCategory = elementTypeCategory;
        this.componentType = componentType;
        this.normalizedName = normalizedName;
    }

    @NotNull
    public final PropertyAnnotation getAnnotation() {
        return this.annotation;
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    @NotNull
    public final ElementTypeCategory getElementTypeCategory() {
        return this.elementTypeCategory;
    }

    @NotNull
    public final TypeMirror getComponentType() {
        return this.componentType;
    }

    @NotNull
    public final String getNormalizedName() {
        return this.normalizedName;
    }

    @NotNull
    public final TypeMirror getJvmType() {
        TypeMirror typeMirror;
        if (this.isGetter()) {
            Element element = this.element;
            Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
            TypeMirror typeMirror2 = ((ExecutableElement)element).getReturnType();
            Intrinsics.checkNotNull((Object)typeMirror2);
            typeMirror = typeMirror2;
        } else {
            TypeMirror typeMirror3 = this.element.asType();
            Intrinsics.checkNotNull((Object)typeMirror3);
            typeMirror = typeMirror3;
        }
        return typeMirror;
    }

    @NotNull
    public final String getJvmName() {
        return this.element.getSimpleName().toString();
    }

    public final boolean isGetter() {
        return this.element.getKind() == ElementKind.METHOD;
    }

    public final boolean isField() {
        return this.element.getKind() == ElementKind.FIELD;
    }

    @NotNull
    public final PropertyAnnotation component1() {
        return this.annotation;
    }

    @NotNull
    public final Element component2() {
        return this.element;
    }

    @NotNull
    public final ElementTypeCategory component3() {
        return this.elementTypeCategory;
    }

    @NotNull
    public final TypeMirror component4() {
        return this.componentType;
    }

    @NotNull
    public final String component5() {
        return this.normalizedName;
    }

    @NotNull
    public final AnnotatedGetterOrField copy(@NotNull PropertyAnnotation annotation, @NotNull Element element, @NotNull ElementTypeCategory elementTypeCategory, @NotNull TypeMirror componentType, @NotNull String normalizedName) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)elementTypeCategory), (String)"elementTypeCategory");
        Intrinsics.checkNotNullParameter((Object)componentType, (String)"componentType");
        Intrinsics.checkNotNullParameter((Object)normalizedName, (String)"normalizedName");
        return new AnnotatedGetterOrField(annotation, element, elementTypeCategory, componentType, normalizedName);
    }

    public static /* synthetic */ AnnotatedGetterOrField copy$default(AnnotatedGetterOrField annotatedGetterOrField, PropertyAnnotation propertyAnnotation, Element element, ElementTypeCategory elementTypeCategory, TypeMirror typeMirror, String string, int n, Object object) {
        if ((n & 1) != 0) {
            propertyAnnotation = annotatedGetterOrField.annotation;
        }
        if ((n & 2) != 0) {
            element = annotatedGetterOrField.element;
        }
        if ((n & 4) != 0) {
            elementTypeCategory = annotatedGetterOrField.elementTypeCategory;
        }
        if ((n & 8) != 0) {
            typeMirror = annotatedGetterOrField.componentType;
        }
        if ((n & 0x10) != 0) {
            string = annotatedGetterOrField.normalizedName;
        }
        return annotatedGetterOrField.copy(propertyAnnotation, element, elementTypeCategory, typeMirror, string);
    }

    @NotNull
    public String toString() {
        return "AnnotatedGetterOrField(annotation=" + this.annotation + ", element=" + this.element + ", elementTypeCategory=" + this.elementTypeCategory + ", componentType=" + this.componentType + ", normalizedName=" + this.normalizedName + ")";
    }

    public int hashCode() {
        int result = this.annotation.hashCode();
        result = result * 31 + ((Object)this.element).hashCode();
        result = result * 31 + this.elementTypeCategory.hashCode();
        result = result * 31 + ((Object)this.componentType).hashCode();
        result = result * 31 + this.normalizedName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedGetterOrField)) {
            return false;
        }
        AnnotatedGetterOrField annotatedGetterOrField = (AnnotatedGetterOrField)other;
        if (!Intrinsics.areEqual((Object)this.annotation, (Object)annotatedGetterOrField.annotation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.element, (Object)annotatedGetterOrField.element)) {
            return false;
        }
        if (this.elementTypeCategory != annotatedGetterOrField.elementTypeCategory) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.componentType, (Object)annotatedGetterOrField.componentType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.normalizedName, (Object)annotatedGetterOrField.normalizedName);
    }

    @JvmStatic
    @Nullable
    public static final AnnotatedGetterOrField tryCreateFor(@NotNull Element element, @NotNull ProcessingEnvironment env) throws ProcessingException {
        return Companion.tryCreateFor(element, env);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J \u0010\u001e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010 \u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0002J.\u0010\"\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130$2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006,"}, d2={"Landroidx/appsearch/compiler/AnnotatedGetterOrField$Companion;", "", "<init>", "()V", "tryCreateFor", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "element", "Ljavax/lang/model/element/Element;", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "create", "annotation", "Landroidx/appsearch/compiler/annotationwrapper/PropertyAnnotation;", "getterOrField", "requireIsGetterOrField", "", "inferTypeCategory", "Landroidx/appsearch/compiler/AnnotatedGetterOrField$ElementTypeCategory;", "inferComponentType", "Ljavax/lang/model/type/TypeMirror;", "typeCategory", "inferNormalizedName", "", "requireTypeMatchesAnnotation", "getSingleAppSearchAnnotation", "Ljavax/lang/model/element/AnnotationMirror;", "inferNormalizedMethodName", "method", "inferNormalizedFieldName", "field", "requireTypeMatchesMetadataPropertyAnnotation", "Landroidx/appsearch/compiler/annotationwrapper/MetadataPropertyAnnotation;", "requireTypeMatchesDataPropertyAnnotation", "Landroidx/appsearch/compiler/annotationwrapper/DataPropertyAnnotation;", "requireTypeIsOneOf", "expectedTypes", "", "allowRepeated", "", "requireComponentTypeMatchesWithSerializer", "serializerClass", "Landroidx/appsearch/compiler/annotationwrapper/SerializerClass;", "requireTypeIsSomeDocumentClass", "annotatedGetterOrField", "appsearch-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AnnotatedGetterOrField tryCreateFor(@NotNull Element element, @NotNull ProcessingEnvironment env) throws ProcessingException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            AnnotationMirror annotationMirror = this.getSingleAppSearchAnnotation(element);
            if (annotationMirror == null) {
                return null;
            }
            AnnotationMirror annotation = annotationMirror;
            MetadataPropertyAnnotation metadataPropertyAnnotation = MetadataPropertyAnnotation.tryParse(annotation);
            if (metadataPropertyAnnotation != null) {
                return this.create(metadataPropertyAnnotation, element, env);
            }
            String normalizedName = this.inferNormalizedName(element, env);
            DataPropertyAnnotation dataPropertyAnnotation = DataPropertyAnnotation.Companion.tryParse(annotation, normalizedName, new IntrospectionHelper(env));
            if (dataPropertyAnnotation != null) {
                return this.create(dataPropertyAnnotation, element, env);
            }
            return null;
        }

        private final AnnotatedGetterOrField create(PropertyAnnotation annotation, Element getterOrField, ProcessingEnvironment env) throws ProcessingException {
            this.requireIsGetterOrField(getterOrField);
            ElementTypeCategory typeCategory = this.inferTypeCategory(getterOrField, env);
            AnnotatedGetterOrField annotatedGetterOrField = new AnnotatedGetterOrField(annotation, getterOrField, typeCategory, this.inferComponentType(getterOrField, typeCategory), this.inferNormalizedName(getterOrField, env));
            this.requireTypeMatchesAnnotation(annotatedGetterOrField, env);
            return annotatedGetterOrField;
        }

        private final void requireIsGetterOrField(Element element) throws ProcessingException {
            ElementKind elementKind = element.getKind();
            switch (elementKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[elementKind.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
                    ExecutableElement method = (ExecutableElement)element;
                    List<ProcessingException> errors = IntrospectionHelper.Companion.validateIsGetter(method);
                    if (!(!((Collection)errors).isEmpty())) break;
                    ProcessingException err = new ProcessingException("Failed to find a suitable getter for element \"" + method.getSimpleName() + "\"", method);
                    err.addWarnings((Collection<ProcessingException>)errors);
                    throw err;
                }
            }
        }

        private final ElementTypeCategory inferTypeCategory(Element getterOrField, ProcessingEnvironment env) {
            TypeMirror jvmType = IntrospectionHelper.Companion.getPropertyType(getterOrField);
            Types typeUtils = env.getTypeUtils();
            IntrospectionHelper helper = new IntrospectionHelper(env);
            return typeUtils.isAssignable(typeUtils.erasure(jvmType), helper.getCollectionType()) ? ElementTypeCategory.COLLECTION : (jvmType.getKind() == TypeKind.ARRAY && !typeUtils.isSameType(jvmType, helper.bytePrimitiveArrayType) && !typeUtils.isSameType(jvmType, helper.getByteBoxArrayType()) ? ElementTypeCategory.ARRAY : ElementTypeCategory.SINGLE);
        }

        private final TypeMirror inferComponentType(Element getterOrField, ElementTypeCategory typeCategory) throws ProcessingException {
            TypeMirror typeMirror;
            TypeMirror jvmType = IntrospectionHelper.Companion.getPropertyType(getterOrField);
            switch (WhenMappings.$EnumSwitchMapping$1[typeCategory.ordinal()]) {
                case 1: {
                    typeMirror = jvmType;
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)jvmType, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
                    List<? extends TypeMirror> typeArguments = ((DeclaredType)jvmType).getTypeArguments();
                    if (typeArguments.isEmpty()) {
                        throw new ProcessingException("Property is repeated but has no generic rawType", getterOrField);
                    }
                    Intrinsics.checkNotNull(typeArguments);
                    Object object = CollectionsKt.first(typeArguments);
                    Intrinsics.checkNotNull((Object)object);
                    typeMirror = (TypeMirror)object;
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)jvmType, (String)"null cannot be cast to non-null type javax.lang.model.type.ArrayType");
                    TypeMirror typeMirror2 = ((ArrayType)jvmType).getComponentType();
                    typeMirror = typeMirror2;
                    Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"getComponentType(...)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return typeMirror;
        }

        private final String inferNormalizedName(Element element, ProcessingEnvironment env) {
            return element.getKind() == ElementKind.METHOD ? this.inferNormalizedMethodName(element, env) : this.inferNormalizedFieldName(element);
        }

        private final void requireTypeMatchesAnnotation(AnnotatedGetterOrField getterOrField, ProcessingEnvironment env) throws ProcessingException {
            PropertyAnnotation annotation = getterOrField.getAnnotation();
            switch (WhenMappings.$EnumSwitchMapping$2[annotation.getPropertyKind().ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)annotation, (String)"null cannot be cast to non-null type androidx.appsearch.compiler.annotationwrapper.MetadataPropertyAnnotation");
                    this.requireTypeMatchesMetadataPropertyAnnotation(getterOrField, (MetadataPropertyAnnotation)annotation, env);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)annotation, (String)"null cannot be cast to non-null type androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation");
                    this.requireTypeMatchesDataPropertyAnnotation(getterOrField, (DataPropertyAnnotation)annotation, env);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final AnnotationMirror getSingleAppSearchAnnotation(Element element) throws ProcessingException {
            List<Object> annotations2 = element.getAnnotationMirrors().stream().filter(arg_0 -> Companion.getSingleAppSearchAnnotation$lambda$0(getSingleAppSearchAnnotation.annotations.1.INSTANCE, arg_0)).toList();
            if (annotations2.isEmpty()) {
                return null;
            }
            if (annotations2.size() > 1) {
                throw new ProcessingException("Cannot use multiple @Document.* annotations", element);
            }
            Intrinsics.checkNotNull(annotations2);
            return (AnnotationMirror)CollectionsKt.first(annotations2);
        }

        private final String inferNormalizedMethodName(Element method, ProcessingEnvironment env) {
            String methodName = method.getSimpleName().toString();
            IntrospectionHelper helper = new IntrospectionHelper(env);
            if (StringsKt.startsWith$default((String)methodName, (String)"get", (boolean)false, (int)2, null) && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3))) {
                String string = methodName.substring(3, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String string4 = methodName.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                return string3 + string4;
            }
            if (helper.isFieldOfBooleanType(method) && StringsKt.startsWith$default((String)methodName, (String)"is", (boolean)false, (int)2, null) && methodName.length() > 2) {
                String string = methodName.substring(2, 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string5 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string6 = string5.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                String string7 = methodName.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                return string6 + string7;
            }
            return methodName;
        }

        private final String inferNormalizedFieldName(Element field) {
            String fieldName = field.getSimpleName().toString();
            if (fieldName.length() < 2) {
                return fieldName;
            }
            if (fieldName.charAt(0) == 'm' && Character.isUpperCase(fieldName.charAt(1))) {
                String string = fieldName.substring(1, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String string4 = fieldName.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                return string3 + string4;
            }
            if (fieldName.charAt(0) == '_' && fieldName.charAt(1) != '_' && Character.isLowerCase(fieldName.charAt(1))) {
                String string = fieldName.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            if (fieldName.charAt(fieldName.length() - 1) == '_' && fieldName.charAt(fieldName.length() - 2) != '_') {
                String string = fieldName.substring(0, fieldName.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return fieldName;
        }

        private final void requireTypeMatchesMetadataPropertyAnnotation(AnnotatedGetterOrField getterOrField, MetadataPropertyAnnotation annotation, ProcessingEnvironment env) throws ProcessingException {
            IntrospectionHelper helper = new IntrospectionHelper(env);
            switch (WhenMappings.$EnumSwitchMapping$3[annotation.ordinal()]) {
                case 1: 
                case 2: {
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object)helper.stringType), env, false);
                    break;
                }
                case 3: 
                case 4: {
                    Object[] objectArray = new TypeMirror[]{helper.longPrimitiveType, helper.intPrimitiveType, helper.getLongBoxType(), helper.getIntegerBoxType()};
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object[])objectArray), env, false);
                    break;
                }
                case 5: {
                    Object[] objectArray = new TypeMirror[]{helper.intPrimitiveType, helper.getIntegerBoxType()};
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object[])objectArray), env, false);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void requireTypeMatchesDataPropertyAnnotation(AnnotatedGetterOrField getterOrField, DataPropertyAnnotation annotation, ProcessingEnvironment env) throws ProcessingException {
            IntrospectionHelper helper = new IntrospectionHelper(env);
            switch (WhenMappings.$EnumSwitchMapping$4[annotation.getDataPropertyKind().ordinal()]) {
                case 1: {
                    Intrinsics.checkNotNull((Object)annotation, (String)"null cannot be cast to non-null type androidx.appsearch.compiler.annotationwrapper.StringPropertyAnnotation");
                    SerializerClass stringSerializer = ((StringPropertyAnnotation)annotation).getCustomSerializer();
                    if (stringSerializer != null) {
                        this.requireComponentTypeMatchesWithSerializer(getterOrField, stringSerializer, env);
                        break;
                    }
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object)helper.stringType), env, true);
                    break;
                }
                case 2: {
                    this.requireTypeIsSomeDocumentClass(getterOrField, env);
                    break;
                }
                case 3: {
                    Intrinsics.checkNotNull((Object)annotation, (String)"null cannot be cast to non-null type androidx.appsearch.compiler.annotationwrapper.LongPropertyAnnotation");
                    SerializerClass longSerializer = ((LongPropertyAnnotation)annotation).getCustomSerializer();
                    if (longSerializer != null) {
                        this.requireComponentTypeMatchesWithSerializer(getterOrField, longSerializer, env);
                        break;
                    }
                    Object[] objectArray = new TypeMirror[]{helper.longPrimitiveType, helper.intPrimitiveType, helper.getLongBoxType(), helper.getIntegerBoxType()};
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object[])objectArray), env, true);
                    break;
                }
                case 4: {
                    Object[] objectArray = new TypeMirror[]{helper.doublePrimitiveType, helper.getFloatPrimitiveType(), helper.getDoubleBoxType(), helper.getFloatBoxType()};
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object[])objectArray), env, true);
                    break;
                }
                case 5: {
                    Object[] objectArray = new TypeMirror[]{helper.booleanPrimitiveType, helper.getBooleanBoxType()};
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object[])objectArray), env, true);
                    break;
                }
                case 6: {
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object)helper.bytePrimitiveArrayType), env, true);
                    break;
                }
                case 7: {
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object)helper.getEmbeddingType()), env, true);
                    break;
                }
                case 8: {
                    this.requireTypeIsOneOf(getterOrField, CollectionsKt.listOf((Object)helper.getBlobHandleType()), env, true);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void requireTypeIsOneOf(AnnotatedGetterOrField getterOrField, Collection<? extends TypeMirror> expectedTypes, ProcessingEnvironment env, boolean allowRepeated) throws ProcessingException {
            Types typeUtils = env.getTypeUtils();
            TypeMirror target = allowRepeated ? getterOrField.getComponentType() : getterOrField.getJvmType();
            boolean isValid = expectedTypes.stream().anyMatch(arg_0 -> Companion.requireTypeIsOneOf$lambda$2(arg_0 -> Companion.requireTypeIsOneOf$lambda$1(typeUtils, target, arg_0), arg_0));
            if (!isValid) {
                String error2 = "@" + getterOrField.getAnnotation().getClassName().simpleName() + " must only be placed on a getter/field of type " + (allowRepeated ? "or array or collection of " : "") + expectedTypes.stream().map(arg_0 -> Companion.requireTypeIsOneOf$lambda$3(requireTypeIsOneOf.error.1.INSTANCE, arg_0)).collect(Collectors.joining("|"));
                throw new ProcessingException(error2, getterOrField.getElement());
            }
        }

        private final void requireComponentTypeMatchesWithSerializer(AnnotatedGetterOrField getterOrField, SerializerClass serializerClass, ProcessingEnvironment env) throws ProcessingException {
            if (!env.getTypeUtils().isSameType(getterOrField.getComponentType(), serializerClass.getCustomType())) {
                String string = "@%s with serializer = %s must only be placed on a getter/field of type or array or collection of %s";
                Object[] objectArray = new Object[]{getterOrField.getAnnotation().getClassName().simpleName(), serializerClass.getElement().getSimpleName(), serializerClass.getCustomType()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new ProcessingException(string2, getterOrField.getElement());
            }
        }

        private final void requireTypeIsSomeDocumentClass(AnnotatedGetterOrField annotatedGetterOrField, ProcessingEnvironment env) throws ProcessingException {
            TypeMirror componentType = annotatedGetterOrField.getComponentType();
            if (componentType.getKind() == TypeKind.DECLARED) {
                Element element = env.getTypeUtils().asElement(componentType);
                Intrinsics.checkNotNull((Object)element);
                if (IntrospectionHelper.Companion.getDocumentAnnotation(element) != null) {
                    return;
                }
            }
            throw new ProcessingException("Invalid type for @DocumentProperty. Must be another class annotated with @Document (or collection or array of)", annotatedGetterOrField.getElement());
        }

        private static final boolean getSingleAppSearchAnnotation$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean requireTypeIsOneOf$lambda$1(Types $typeUtils, TypeMirror $target, TypeMirror expectedType) {
            Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
            return $typeUtils.isSameType(expectedType, $target);
        }

        private static final boolean requireTypeIsOneOf$lambda$2(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final String requireTypeIsOneOf$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;
            public static final /* synthetic */ int[] $EnumSwitchMapping$4;

            static {
                int[] nArray = new int[ElementKind.values().length];
                try {
                    nArray[ElementKind.FIELD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ElementKind.METHOD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ElementTypeCategory.values().length];
                try {
                    nArray[ElementTypeCategory.SINGLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ElementTypeCategory.COLLECTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ElementTypeCategory.ARRAY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[PropertyAnnotation.Kind.values().length];
                try {
                    nArray[PropertyAnnotation.Kind.METADATA_PROPERTY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PropertyAnnotation.Kind.DATA_PROPERTY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[MetadataPropertyAnnotation.values().length];
                try {
                    nArray[MetadataPropertyAnnotation.ID.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MetadataPropertyAnnotation.NAMESPACE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MetadataPropertyAnnotation.TTL_MILLIS.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MetadataPropertyAnnotation.CREATION_TIMESTAMP_MILLIS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MetadataPropertyAnnotation.SCORE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
                nArray = new int[DataPropertyAnnotation.Kind.values().length];
                try {
                    nArray[DataPropertyAnnotation.Kind.STRING_PROPERTY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.DOCUMENT_PROPERTY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.LONG_PROPERTY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.DOUBLE_PROPERTY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.BOOLEAN_PROPERTY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.BYTES_PROPERTY.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.EMBEDDING_PROPERTY.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DataPropertyAnnotation.Kind.BLOB_HANDLE_PROPERTY.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$4 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/appsearch/compiler/AnnotatedGetterOrField$ElementTypeCategory;", "", "<init>", "(Ljava/lang/String;I)V", "SINGLE", "COLLECTION", "ARRAY", "appsearch-compiler"})
    public static final class ElementTypeCategory
    extends Enum<ElementTypeCategory> {
        public static final /* enum */ ElementTypeCategory SINGLE = new ElementTypeCategory();
        public static final /* enum */ ElementTypeCategory COLLECTION = new ElementTypeCategory();
        public static final /* enum */ ElementTypeCategory ARRAY = new ElementTypeCategory();
        private static final /* synthetic */ ElementTypeCategory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ElementTypeCategory[] values() {
            return (ElementTypeCategory[])$VALUES.clone();
        }

        public static ElementTypeCategory valueOf(String value) {
            return Enum.valueOf(ElementTypeCategory.class, value);
        }

        @NotNull
        public static EnumEntries<ElementTypeCategory> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = elementTypeCategoryArray = new ElementTypeCategory[]{ElementTypeCategory.SINGLE, ElementTypeCategory.COLLECTION, ElementTypeCategory.ARRAY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

