/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.annotation.VisibleForTesting;
import androidx.appsearch.compiler.CodeGenerator;
import androidx.appsearch.compiler.DocumentMapGenerator;
import androidx.appsearch.compiler.DocumentModel;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.MissingTypeException;
import androidx.appsearch.compiler.ProcessingException;
import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreElements;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.JavaFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.jspecify.annotations.NonNull;

@SupportedAnnotationTypes(value={"androidx.appsearch.annotation.Document"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"AppSearchCompiler.OutputDir", "AppSearchCompiler.RestrictGeneratedCodeToLib"})
public class AppSearchCompiler
extends BasicAnnotationProcessor {
    @VisibleForTesting
    static final String OUTPUT_DIR_OPTION = "AppSearchCompiler.OutputDir";
    @VisibleForTesting
    static final String RESTRICT_GENERATED_CODE_TO_LIB_OPTION = "AppSearchCompiler.RestrictGeneratedCodeToLib";

    public @NonNull SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    protected Iterable<? extends BasicAnnotationProcessor.Step> steps() {
        return ImmutableList.of((Object)new AppSearchCompileStep(this.processingEnv));
    }

    private static final class AppSearchCompileStep
    implements BasicAnnotationProcessor.Step {
        private final ProcessingEnvironment mProcessingEnv;
        private final Messager mMessager;
        private final Map<String, List<String>> mDocumentClassMap;
        private int mRoundIndex;

        AppSearchCompileStep(ProcessingEnvironment processingEnv) {
            this.mProcessingEnv = processingEnv;
            this.mMessager = processingEnv.getMessager();
            this.mDocumentClassMap = new HashMap<String, List<String>>();
            this.mRoundIndex = -1;
        }

        public ImmutableSet<String> annotations() {
            return ImmutableSet.of((Object)IntrospectionHelper.DOCUMENT_ANNOTATION_CLASS.canonicalName());
        }

        public ImmutableSet<Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
            this.mDocumentClassMap.clear();
            ++this.mRoundIndex;
            Set<TypeElement> documentElements = ElementFilter.typesIn((Set<? extends Element>)elementsByAnnotation.get((Object)IntrospectionHelper.DOCUMENT_ANNOTATION_CLASS.canonicalName()));
            ImmutableSet.Builder nextRound = new ImmutableSet.Builder();
            String documentMapClassPackage = null;
            HashSet<String> classNames = new HashSet<String>();
            for (TypeElement document : documentElements) {
                try {
                    this.processDocument(document);
                }
                catch (MissingTypeException e) {
                    nextRound.add((Object)document);
                }
                catch (ProcessingException e) {
                    e.printDiagnostic(this.mMessager);
                }
                classNames.add(document.getQualifiedName().toString());
                String packageName = this.mProcessingEnv.getElementUtils().getPackageOf(document).toString();
                if (documentMapClassPackage != null && packageName.compareTo(documentMapClassPackage) >= 0) continue;
                documentMapClassPackage = packageName;
            }
            try {
                if (!classNames.isEmpty()) {
                    String classSuffix = AppSearchCompileStep.generateStringSetHash(classNames, ",") + "_" + this.mRoundIndex;
                    this.writeJavaFile(DocumentMapGenerator.generate(this.mProcessingEnv, documentMapClassPackage, classSuffix, this.mDocumentClassMap, this.getRestrictGeneratedCodeToLibOption()));
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                this.mProcessingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create the AppSearch document map class: " + String.valueOf(e));
            }
            return nextRound.build();
        }

        private void writeJavaFile(JavaFile javaFile) throws IOException {
            String outputDir = this.getOutputDirOption();
            if (outputDir == null || outputDir.isEmpty()) {
                javaFile.writeTo(this.mProcessingEnv.getFiler());
            } else {
                this.mMessager.printMessage(Diagnostic.Kind.NOTE, "Writing output to \"" + outputDir + "\" due to the presence of -AAppSearchCompiler.OutputDir");
                javaFile.writeTo(new File(outputDir));
            }
        }

        private void processDocument(@NonNull TypeElement element) throws ProcessingException, MissingTypeException {
            DocumentModel model;
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                throw new ProcessingException("@Document annotation on something other than a class or an interface", element);
            }
            if (element.getAnnotation(AutoValue.class) != null) {
                TypeElement generatedElement = this.mProcessingEnv.getElementUtils().getTypeElement(this.getAutoValueGeneratedClassName(element));
                if (generatedElement == null) {
                    throw new MissingTypeException(element);
                }
                model = DocumentModel.createAutoValueModel(this.mProcessingEnv, element, generatedElement);
            } else {
                model = DocumentModel.createPojoModel(this.mProcessingEnv, element);
            }
            CodeGenerator generator = new CodeGenerator(this.mProcessingEnv, model, this.getRestrictGeneratedCodeToLibOption());
            try {
                this.writeJavaFile(generator.createJavaFile());
            }
            catch (IOException e) {
                ProcessingException pe = new ProcessingException("Failed to write output", model.getClassElement());
                pe.initCause(e);
                throw pe;
            }
            List documentClassList = this.mDocumentClassMap.computeIfAbsent(model.getSchemaName(), k -> new ArrayList());
            documentClassList.add(this.mProcessingEnv.getElementUtils().getBinaryName(element).toString());
        }

        private boolean getRestrictGeneratedCodeToLibOption() {
            return Boolean.parseBoolean(this.mProcessingEnv.getOptions().get(AppSearchCompiler.RESTRICT_GENERATED_CODE_TO_LIB_OPTION));
        }

        @Nullable
        private String getOutputDirOption() {
            return this.mProcessingEnv.getOptions().get(AppSearchCompiler.OUTPUT_DIR_OPTION);
        }

        private String getAutoValueGeneratedClassName(TypeElement element) {
            TypeElement type = element;
            Object name = type.getSimpleName().toString();
            while (type.getEnclosingElement() instanceof TypeElement) {
                type = (TypeElement)type.getEnclosingElement();
                name = type.getSimpleName().toString() + "_" + (String)name;
            }
            String pkg = MoreElements.getPackage((Element)type).getQualifiedName().toString();
            String dot = pkg.isEmpty() ? "" : ".";
            return pkg + dot + "AutoValue_" + (String)name;
        }

        private static @NonNull String generateStringSetHash(@NonNull Set<String> set, @NonNull String delimiter) throws NoSuchAlgorithmException {
            ArrayList<String> sortedList = new ArrayList<String>(set);
            Collections.sort(sortedList);
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (String s : sortedList) {
                md.update(s.getBytes(StandardCharsets.UTF_8));
                md.update(delimiter.getBytes(StandardCharsets.UTF_8));
            }
            StringBuilder result = new StringBuilder();
            for (byte b : md.digest()) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    result.append('0');
                }
                result.append(hex);
            }
            return result.toString();
        }
    }
}

