/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AppSearchCompiler;
import androidx.appsearch.compiler.DocumentModel;
import androidx.appsearch.compiler.FromGenericDocumentCodeGenerator;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.SchemaCodeGenerator;
import androidx.appsearch.compiler.ToGenericDocumentCodeGenerator;
import com.google.auto.common.GeneratedAnnotationSpecs;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.jspecify.annotations.NonNull;

class CodeGenerator {
    private final ProcessingEnvironment mEnv;
    private final DocumentModel mModel;
    private final boolean mRestrictGeneratedCodeToLib;
    private final String mOutputPackage;

    CodeGenerator(@NonNull ProcessingEnvironment env, @NonNull DocumentModel model, boolean restrictGeneratedCodeToLib) {
        this.mEnv = env;
        this.mModel = model;
        this.mRestrictGeneratedCodeToLib = restrictGeneratedCodeToLib;
        this.mOutputPackage = this.mEnv.getElementUtils().getPackageOf(this.mModel.getClassElement()).toString();
    }

    public JavaFile createJavaFile() throws IOException, ProcessingException {
        TypeSpec outputClass = this.createClass();
        return JavaFile.builder((String)this.mOutputPackage, (TypeSpec)outputClass).build();
    }

    private TypeSpec createClass() throws ProcessingException {
        String qualifiedName = this.mModel.getQualifiedDocumentClassName();
        String className = qualifiedName.substring(this.mOutputPackage.length() + 1);
        ClassName genClassName = IntrospectionHelper.getDocumentClassFactoryForClass(this.mOutputPackage, className);
        TypeName genClassType = TypeName.get((TypeMirror)this.mModel.getClassElement().asType());
        ParameterizedTypeName factoryType = ParameterizedTypeName.get((ClassName)IntrospectionHelper.DOCUMENT_CLASS_FACTORY_CLASS, (TypeName[])new TypeName[]{genClassType});
        TypeSpec.Builder genClass = TypeSpec.classBuilder((ClassName)genClassName).addOriginatingElement((Element)this.mModel.getClassElement()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface((TypeName)factoryType);
        GeneratedAnnotationSpecs.generatedAnnotationSpec((Elements)this.mEnv.getElementUtils(), (SourceVersion)this.mEnv.getSourceVersion(), AppSearchCompiler.class).ifPresent(arg_0 -> ((TypeSpec.Builder)genClass).addAnnotation(arg_0));
        if (this.mRestrictGeneratedCodeToLib) {
            genClass.addAnnotation(AnnotationSpec.builder((ClassName)IntrospectionHelper.RESTRICT_TO_ANNOTATION_CLASS).addMember("value", "$T.LIBRARY", new Object[]{IntrospectionHelper.RESTRICT_TO_SCOPE_CLASS}).build());
        }
        SchemaCodeGenerator.generate(this.mEnv, this.mModel, genClass);
        ToGenericDocumentCodeGenerator.generate(this.mEnv, this.mModel, genClass);
        FromGenericDocumentCodeGenerator.generate(this.mEnv, this.mModel, genClass);
        return genClass.build();
    }
}

