/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import com.squareup.javapoet.CodeBlock;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.NonNull;

final class CodegenUtils {
    private CodegenUtils() {
    }

    static CodeBlock createNewArrayExpr(@NonNull TypeMirror componentType, @NonNull CodeBlock size, @NonNull ProcessingEnvironment env) {
        ArrayType arrayType = env.getTypeUtils().getArrayType(componentType);
        TypeMirror innerMostType = arrayType.getComponentType();
        int dims = 1;
        while (innerMostType.getKind() == TypeKind.ARRAY) {
            innerMostType = ((ArrayType)innerMostType).getComponentType();
            ++dims;
        }
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("new $T[$L]", new Object[]{innerMostType, size});
        for (int i = 1; i < dims; ++i) {
            codeBlock.add("[]", new Object[0]);
        }
        return codeBlock.build();
    }
}

