/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.ProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J-\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0011\u0010\u001c\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0010\u00a8\u0006("}, d2={"Landroidx/appsearch/compiler/CreationMethod;", "", "element", "Ljavax/lang/model/element/ExecutableElement;", "paramAssociations", "", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "returnsDocumentClass", "", "<init>", "(Ljavax/lang/model/element/ExecutableElement;Ljava/util/List;Z)V", "getElement", "()Ljavax/lang/model/element/ExecutableElement;", "getParamAssociations", "()Ljava/util/List;", "getReturnsDocumentClass", "()Z", "enclosingClass", "Ljavax/lang/model/type/DeclaredType;", "getEnclosingClass", "()Ljavax/lang/model/type/DeclaredType;", "returnType", "getReturnType", "jvmName", "", "getJvmName", "()Ljava/lang/String;", "isConstructor", "returnsBuilder", "getReturnsBuilder", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "appsearch-compiler"})
public final class CreationMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutableElement element;
    @NotNull
    private final List<AnnotatedGetterOrField> paramAssociations;
    private final boolean returnsDocumentClass;

    public CreationMethod(@NotNull ExecutableElement element, @NotNull List<AnnotatedGetterOrField> paramAssociations, boolean returnsDocumentClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(paramAssociations, (String)"paramAssociations");
        this.element = element;
        this.paramAssociations = paramAssociations;
        this.returnsDocumentClass = returnsDocumentClass;
    }

    @NotNull
    public final ExecutableElement getElement() {
        return this.element;
    }

    @NotNull
    public final List<AnnotatedGetterOrField> getParamAssociations() {
        return this.paramAssociations;
    }

    public final boolean getReturnsDocumentClass() {
        return this.returnsDocumentClass;
    }

    @NotNull
    public final DeclaredType getEnclosingClass() {
        TypeMirror typeMirror = this.element.getEnclosingElement().asType();
        Intrinsics.checkNotNull((Object)typeMirror, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
        return (DeclaredType)typeMirror;
    }

    @NotNull
    public final DeclaredType getReturnType() {
        DeclaredType declaredType;
        if (this.isConstructor()) {
            TypeMirror typeMirror = this.element.getEnclosingElement().asType();
            Intrinsics.checkNotNull((Object)typeMirror, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
            declaredType = (DeclaredType)typeMirror;
        } else {
            TypeMirror typeMirror = this.element.getReturnType();
            Intrinsics.checkNotNull((Object)typeMirror, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
            declaredType = (DeclaredType)typeMirror;
        }
        return declaredType;
    }

    @NotNull
    public final String getJvmName() {
        return this.element.getSimpleName().toString();
    }

    public final boolean isConstructor() {
        return this.element.getKind() == ElementKind.CONSTRUCTOR;
    }

    public final boolean getReturnsBuilder() {
        return !this.returnsDocumentClass;
    }

    @NotNull
    public final ExecutableElement component1() {
        return this.element;
    }

    @NotNull
    public final List<AnnotatedGetterOrField> component2() {
        return this.paramAssociations;
    }

    public final boolean component3() {
        return this.returnsDocumentClass;
    }

    @NotNull
    public final CreationMethod copy(@NotNull ExecutableElement element, @NotNull List<AnnotatedGetterOrField> paramAssociations, boolean returnsDocumentClass) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(paramAssociations, (String)"paramAssociations");
        return new CreationMethod(element, paramAssociations, returnsDocumentClass);
    }

    public static /* synthetic */ CreationMethod copy$default(CreationMethod creationMethod, ExecutableElement executableElement, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            executableElement = creationMethod.element;
        }
        if ((n & 2) != 0) {
            list = creationMethod.paramAssociations;
        }
        if ((n & 4) != 0) {
            bl = creationMethod.returnsDocumentClass;
        }
        return creationMethod.copy(executableElement, list, bl);
    }

    @NotNull
    public String toString() {
        return "CreationMethod(element=" + this.element + ", paramAssociations=" + this.paramAssociations + ", returnsDocumentClass=" + this.returnsDocumentClass + ")";
    }

    public int hashCode() {
        int result = this.element.hashCode();
        result = result * 31 + ((Object)this.paramAssociations).hashCode();
        result = result * 31 + Boolean.hashCode(this.returnsDocumentClass);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CreationMethod)) {
            return false;
        }
        CreationMethod creationMethod = (CreationMethod)other;
        if (!Intrinsics.areEqual((Object)this.element, (Object)creationMethod.element)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.paramAssociations, creationMethod.paramAssociations)) {
            return false;
        }
        return this.returnsDocumentClass == creationMethod.returnsDocumentClass;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Landroidx/appsearch/compiler/CreationMethod$Companion;", "", "<init>", "()V", "inferParamAssociationsAndCreate", "Landroidx/appsearch/compiler/CreationMethod;", "method", "Ljavax/lang/model/element/ExecutableElement;", "gettersAndFields", "", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "returnsDocumentClass", "", "appsearch-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CreationMethod inferParamAssociationsAndCreate(@NotNull ExecutableElement method, @NotNull Collection<AnnotatedGetterOrField> gettersAndFields, boolean returnsDocumentClass) throws ProcessingException {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(gettersAndFields, (String)"gettersAndFields");
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new ProcessingException("Method cannot be used to create a " + (returnsDocumentClass ? "document class" : "builder") + ": private visibility", method);
            }
            if (method.getKind() == ElementKind.CONSTRUCTOR && method.getEnclosingElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new ProcessingException("Method cannot be used to create a " + (returnsDocumentClass ? "document class" : "builder") + ": abstract constructor", method);
            }
            Map normalizedNameToGetterOrField = new LinkedHashMap();
            for (AnnotatedGetterOrField getterOrField : gettersAndFields) {
                normalizedNameToGetterOrField.put(getterOrField.getNormalizedName(), getterOrField);
            }
            List paramAssociations = new ArrayList();
            for (VariableElement variableElement : method.getParameters()) {
                AnnotatedGetterOrField correspondingGetterOrField;
                String paramName = variableElement.getSimpleName().toString();
                if ((AnnotatedGetterOrField)normalizedNameToGetterOrField.get(paramName) == null) {
                    throw new ProcessingException("Parameter \"" + paramName + "\" is not an AppSearch parameter; don't know how to supply it.", method);
                }
                paramAssociations.add(correspondingGetterOrField);
            }
            return new CreationMethod(method, paramAssociations, returnsDocumentClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

