/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.CreationMethod;
import androidx.appsearch.compiler.DocumentClassCreationInfo;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.SetterOrField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Landroidx/appsearch/compiler/DocumentClassCreationInfo;", "", "creationMethod", "Landroidx/appsearch/compiler/CreationMethod;", "settersAndFields", "", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "Landroidx/appsearch/compiler/SetterOrField;", "<init>", "(Landroidx/appsearch/compiler/CreationMethod;Ljava/util/Map;)V", "getCreationMethod", "()Landroidx/appsearch/compiler/CreationMethod;", "getSettersAndFields", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "BuilderProducer", "appsearch-compiler"})
public final class DocumentClassCreationInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CreationMethod creationMethod;
    @NotNull
    private final Map<AnnotatedGetterOrField, SetterOrField> settersAndFields;

    public DocumentClassCreationInfo(@NotNull CreationMethod creationMethod, @NotNull Map<AnnotatedGetterOrField, SetterOrField> settersAndFields) {
        Intrinsics.checkNotNullParameter((Object)creationMethod, (String)"creationMethod");
        Intrinsics.checkNotNullParameter(settersAndFields, (String)"settersAndFields");
        this.creationMethod = creationMethod;
        this.settersAndFields = settersAndFields;
    }

    @NotNull
    public final CreationMethod getCreationMethod() {
        return this.creationMethod;
    }

    @NotNull
    public final Map<AnnotatedGetterOrField, SetterOrField> getSettersAndFields() {
        return this.settersAndFields;
    }

    @NotNull
    public final CreationMethod component1() {
        return this.creationMethod;
    }

    @NotNull
    public final Map<AnnotatedGetterOrField, SetterOrField> component2() {
        return this.settersAndFields;
    }

    @NotNull
    public final DocumentClassCreationInfo copy(@NotNull CreationMethod creationMethod, @NotNull Map<AnnotatedGetterOrField, SetterOrField> settersAndFields) {
        Intrinsics.checkNotNullParameter((Object)creationMethod, (String)"creationMethod");
        Intrinsics.checkNotNullParameter(settersAndFields, (String)"settersAndFields");
        return new DocumentClassCreationInfo(creationMethod, settersAndFields);
    }

    public static /* synthetic */ DocumentClassCreationInfo copy$default(DocumentClassCreationInfo documentClassCreationInfo, CreationMethod creationMethod, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            creationMethod = documentClassCreationInfo.creationMethod;
        }
        if ((n & 2) != 0) {
            map = documentClassCreationInfo.settersAndFields;
        }
        return documentClassCreationInfo.copy(creationMethod, map);
    }

    @NotNull
    public String toString() {
        return "DocumentClassCreationInfo(creationMethod=" + this.creationMethod + ", settersAndFields=" + this.settersAndFields + ")";
    }

    public int hashCode() {
        int result = this.creationMethod.hashCode();
        result = result * 31 + ((Object)this.settersAndFields).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocumentClassCreationInfo)) {
            return false;
        }
        DocumentClassCreationInfo documentClassCreationInfo = (DocumentClassCreationInfo)other;
        if (!Intrinsics.areEqual((Object)this.creationMethod, (Object)documentClassCreationInfo.creationMethod)) {
            return false;
        }
        return Intrinsics.areEqual(this.settersAndFields, documentClassCreationInfo.settersAndFields);
    }

    @JvmStatic
    @NotNull
    public static final DocumentClassCreationInfo infer(@NotNull TypeElement documentClass, @NotNull Set<AnnotatedGetterOrField> annotatedGettersAndFields, @NotNull IntrospectionHelper helper) throws ProcessingException {
        return Companion.infer(documentClass, annotatedGettersAndFields, helper);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Landroidx/appsearch/compiler/DocumentClassCreationInfo$BuilderProducer;", "", "element", "Ljavax/lang/model/element/Element;", "builderType", "Ljavax/lang/model/type/DeclaredType;", "<init>", "(Ljavax/lang/model/element/Element;Ljavax/lang/model/type/DeclaredType;)V", "getElement", "()Ljavax/lang/model/element/Element;", "getBuilderType", "()Ljavax/lang/model/type/DeclaredType;", "isStaticMethod", "", "()Z", "Companion", "appsearch-compiler"})
    private static final class BuilderProducer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Element element;
        @NotNull
        private final DeclaredType builderType;

        public BuilderProducer(@NotNull Element element, @NotNull DeclaredType builderType) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)builderType, (String)"builderType");
            this.element = element;
            this.builderType = builderType;
        }

        @NotNull
        public final Element getElement() {
            return this.element;
        }

        @NotNull
        public final DeclaredType getBuilderType() {
            return this.builderType;
        }

        public final boolean isStaticMethod() {
            return this.element.getKind() == ElementKind.METHOD;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Landroidx/appsearch/compiler/DocumentClassCreationInfo$BuilderProducer$Companion;", "", "<init>", "()V", "tryCreate", "Landroidx/appsearch/compiler/DocumentClassCreationInfo$BuilderProducer;", "documentClass", "Ljavax/lang/model/element/TypeElement;", "helper", "Landroidx/appsearch/compiler/IntrospectionHelper;", "isAnnotatedWithBuilderProducer", "", "element", "Ljavax/lang/model/element/Element;", "requireBuilderProducerIsMethodOrClass", "", "annotatedElement", "requireBuilderProducerAccessible", "requireIsDeclaredTypeWithBuildMethod", "builderType", "Ljavax/lang/model/type/TypeMirror;", "appsearch-compiler"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final BuilderProducer tryCreate(@NotNull TypeElement documentClass, @NotNull IntrospectionHelper helper) throws ProcessingException {
                DeclaredType declaredType;
                Intrinsics.checkNotNullParameter((Object)documentClass, (String)"documentClass");
                Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
                List<Object> list = documentClass.getEnclosedElements().stream().filter(arg_0 -> Companion.tryCreate$lambda$0((Function1)new Function1<Element, Boolean>((Object)this){

                    public final Boolean invoke(Element p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return androidx.appsearch.compiler.DocumentClassCreationInfo$BuilderProducer$Companion.access$isAnnotatedWithBuilderProducer((Companion)this.receiver, p0);
                    }
                }, arg_0)).toList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                List<Object> annotatedElements2 = list;
                if (annotatedElements2.isEmpty()) {
                    return null;
                }
                if (annotatedElements2.size() > 1) {
                    throw new ProcessingException("Found duplicated builder producer", documentClass);
                }
                Element annotatedElement = (Element)annotatedElements2.get(0);
                this.requireBuilderProducerAccessible(annotatedElement);
                this.requireBuilderProducerIsMethodOrClass(annotatedElement);
                if (annotatedElement.getKind() == ElementKind.METHOD) {
                    Intrinsics.checkNotNull((Object)annotatedElement, (String)"null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
                    ExecutableElement method = (ExecutableElement)annotatedElement;
                    TypeMirror typeMirror = method.getReturnType();
                    Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"getReturnType(...)");
                    this.requireIsDeclaredTypeWithBuildMethod(typeMirror, documentClass, annotatedElement, helper);
                    TypeMirror typeMirror2 = method.getReturnType();
                    Intrinsics.checkNotNull((Object)typeMirror2, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
                    declaredType = (DeclaredType)typeMirror2;
                } else {
                    Intrinsics.checkNotNull((Object)annotatedElement, (String)"null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                    TypeElement builderClass = (TypeElement)annotatedElement;
                    TypeMirror typeMirror = builderClass.asType();
                    Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"asType(...)");
                    this.requireIsDeclaredTypeWithBuildMethod(typeMirror, documentClass, annotatedElement, helper);
                    TypeMirror typeMirror3 = ((TypeElement)annotatedElement).asType();
                    Intrinsics.checkNotNull((Object)typeMirror3, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
                    declaredType = (DeclaredType)typeMirror3;
                }
                DeclaredType builderType = declaredType;
                return new BuilderProducer(annotatedElement, builderType);
            }

            private final boolean isAnnotatedWithBuilderProducer(Element element) {
                return !IntrospectionHelper.Companion.getAnnotations(element, IntrospectionHelper.Companion.getBUILDER_PRODUCER_CLASS()).isEmpty();
            }

            private final void requireBuilderProducerIsMethodOrClass(Element annotatedElement) throws ProcessingException {
                if (annotatedElement.getKind() != ElementKind.METHOD && annotatedElement.getKind() != ElementKind.CLASS) {
                    throw new ProcessingException("Builder producer must be a method or a class", annotatedElement);
                }
            }

            private final void requireBuilderProducerAccessible(Element annotatedElement) throws ProcessingException {
                if (!annotatedElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new ProcessingException("Builder producer must be static", annotatedElement);
                }
                if (annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new ProcessingException("Builder producer cannot be private", annotatedElement);
                }
            }

            private final void requireIsDeclaredTypeWithBuildMethod(TypeMirror builderType, TypeElement documentClass, Element annotatedElement, IntrospectionHelper helper) throws ProcessingException {
                ProcessingException exception = new ProcessingException("Invalid builder producer: " + builderType + " does not have a method " + documentClass + " build()", annotatedElement);
                if (builderType.getKind() != TypeKind.DECLARED) {
                    throw exception;
                }
                Intrinsics.checkNotNull((Object)builderType, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
                boolean hasBuildMethod = helper.getAllMethods((DeclaredType)builderType).anyMatch(arg_0 -> Companion.requireIsDeclaredTypeWithBuildMethod$lambda$2(arg_0 -> Companion.requireIsDeclaredTypeWithBuildMethod$lambda$1(helper, documentClass, arg_0), arg_0));
                if (!hasBuildMethod) {
                    throw exception;
                }
            }

            private static final boolean tryCreate$lambda$0(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private static final boolean requireIsDeclaredTypeWithBuildMethod$lambda$1(IntrospectionHelper $helper, TypeElement $documentClass, IntrospectionHelper.MethodTypeAndElement method) {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                if (!method.getElement().getSimpleName().contentEquals("build")) return false;
                if (method.getElement().getModifiers().contains((Object)Modifier.STATIC)) return false;
                if (method.getElement().getModifiers().contains((Object)Modifier.PRIVATE)) return false;
                ExecutableType executableType = method.getType();
                TypeMirror typeMirror = $documentClass.asType();
                Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"asType(...)");
                if (!$helper.isReturnTypeMatching(executableType, typeMirror)) return false;
                if (!method.getType().getParameterTypes().isEmpty()) return false;
                return true;
            }

            private static final boolean requireIsDeclaredTypeWithBuildMethod$lambda$2(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }

            public static final /* synthetic */ boolean access$isAnnotatedWithBuilderProducer(Companion $this, Element element) {
                return $this.isAnnotatedWithBuilderProducer(element);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Landroidx/appsearch/compiler/DocumentClassCreationInfo$Companion;", "", "<init>", "()V", "infer", "Landroidx/appsearch/compiler/DocumentClassCreationInfo;", "documentClass", "Ljavax/lang/model/element/TypeElement;", "annotatedGettersAndFields", "", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "helper", "Landroidx/appsearch/compiler/IntrospectionHelper;", "findSetter", "Ljavax/lang/model/element/ExecutableElement;", "clazz", "getterOrField", "getAcceptableSetterNames", "", "fieldCanBeSetDirectly", "", "field", "Ljavax/lang/model/element/Element;", "extractPotentialCreationMethods", "", "Landroidx/appsearch/compiler/CreationMethod;", "builderProducer", "Landroidx/appsearch/compiler/DocumentClassCreationInfo$BuilderProducer;", "getCommaSeparatedJvmNames", "gettersAndFields", "", "appsearch-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DocumentClassCreationInfo infer(@NotNull TypeElement documentClass, @NotNull Set<AnnotatedGetterOrField> annotatedGettersAndFields, @NotNull IntrospectionHelper helper) throws ProcessingException {
            Intrinsics.checkNotNullParameter((Object)documentClass, (String)"documentClass");
            Intrinsics.checkNotNullParameter(annotatedGettersAndFields, (String)"annotatedGettersAndFields");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            BuilderProducer builderProducer = BuilderProducer.Companion.tryCreate(documentClass, helper);
            LinkedHashMap settersAndFields = new LinkedHashMap();
            List setterNotFoundErrors = new ArrayList();
            for (AnnotatedGetterOrField getterOrField : annotatedGettersAndFields) {
                Object targetClass;
                if (builderProducer == null && getterOrField.isField() && this.fieldCanBeSetDirectly(getterOrField.getElement())) {
                    ((Map)settersAndFields).put(getterOrField, new SetterOrField(getterOrField.getElement()));
                    continue;
                }
                try {
                    TypeElement typeElement;
                    if (builderProducer == null) {
                        typeElement = documentClass;
                    } else {
                        Element element = builderProducer.getBuilderType().asElement();
                        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                        typeElement = (TypeElement)element;
                    }
                    targetClass = typeElement;
                    ExecutableElement setter = this.findSetter((TypeElement)targetClass, getterOrField, helper);
                    ((Map)settersAndFields).put(getterOrField, new SetterOrField(setter));
                    targetClass = Unit.INSTANCE;
                }
                catch (ProcessingException e) {
                    targetClass = setterNotFoundErrors.add(e);
                }
            }
            List<CreationMethod> potentialCreationMethods = this.extractPotentialCreationMethods(documentClass, annotatedGettersAndFields, builderProducer, helper);
            Set set = settersAndFields.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            Set remainingGettersAndFields = SetsKt.minus(annotatedGettersAndFields, (Iterable)set);
            String string = "Could not find a suitable %s for \"%s\" that covers properties: [%s]. See the warnings for more details.";
            Object[] objectArray = new Object[]{builderProducer == null ? "constructor/factory method" : "builder producer", documentClass.getQualifiedName(), this.getCommaSeparatedJvmNames(remainingGettersAndFields)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            ProcessingException exception = new ProcessingException(string2, documentClass);
            exception.addWarnings(setterNotFoundErrors);
            for (CreationMethod creationMethod : potentialCreationMethods) {
                Set missingParams = SetsKt.minus((Set)remainingGettersAndFields, (Iterable)creationMethod.getParamAssociations());
                if (!((Collection)missingParams).isEmpty()) {
                    String string3 = "Cannot use this %s to construct the class: \"%s\". No parameters for the properties: [%s]";
                    Object[] objectArray2 = new Object[]{creationMethod.isConstructor() ? "constructor" : "creation method", documentClass.getQualifiedName(), this.getCommaSeparatedJvmNames(missingParams)};
                    String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                    exception.addWarning(new ProcessingException(string4, creationMethod.getElement()));
                    continue;
                }
                for (AnnotatedGetterOrField getterOrField : creationMethod.getParamAssociations()) {
                    settersAndFields.remove(getterOrField);
                }
                return new DocumentClassCreationInfo(creationMethod, settersAndFields);
            }
            throw exception;
        }

        private final ExecutableElement findSetter(TypeElement clazz, AnnotatedGetterOrField getterOrField, IntrospectionHelper helper) throws ProcessingException {
            Set<String> setterNames = this.getAcceptableSetterNames(getterOrField);
            String setterSignatures = setterNames.stream().map(arg_0 -> Companion.findSetter$lambda$1(arg_0 -> Companion.findSetter$lambda$0(getterOrField, arg_0), arg_0)).collect(Collectors.joining("|"));
            ProcessingException exception = new ProcessingException("Could not find any of the setter(s): " + setterSignatures, getterOrField.getElement());
            List<Object> potentialSetters = helper.getAllMethods(clazz).stream().filter(arg_0 -> Companion.findSetter$lambda$3(arg_0 -> Companion.findSetter$lambda$2(setterNames, arg_0), arg_0)).toList();
            for (ExecutableElement executableElement : potentialSetters) {
                if (executableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    exception.addWarning(new ProcessingException("Setter cannot be used: private visibility", executableElement));
                    continue;
                }
                if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    exception.addWarning(new ProcessingException("Setter cannot be used: static method", executableElement));
                    continue;
                }
                if (executableElement.getParameters().size() != 1) {
                    exception.addWarning(new ProcessingException("Setter cannot be used: takes " + executableElement.getParameters().size() + " parameters instead of 1", executableElement));
                    continue;
                }
                Intrinsics.checkNotNull((Object)executableElement);
                return executableElement;
            }
            throw exception;
        }

        private final Set<String> getAcceptableSetterNames(AnnotatedGetterOrField getterOrField) {
            Set setterNames = new LinkedHashSet();
            String normalizedName = getterOrField.getNormalizedName();
            setterNames.add(normalizedName);
            String string = normalizedName.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            String string4 = normalizedName.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String pascalCase = string3 + string4;
            setterNames.add("set" + pascalCase);
            switch (WhenMappings.$EnumSwitchMapping$0[getterOrField.getElementTypeCategory().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    setterNames.add("add" + pascalCase);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return setterNames;
        }

        private final boolean fieldCanBeSetDirectly(Element field) {
            Set<Modifier> modifiers = field.getModifiers();
            return !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.FINAL);
        }

        private final List<CreationMethod> extractPotentialCreationMethods(TypeElement documentClass, Set<AnnotatedGetterOrField> annotatedGettersAndFields, BuilderProducer builderProducer, IntrospectionHelper helper) throws ProcessingException {
            List<ExecutableElement> list;
            if (builderProducer != null && builderProducer.isStaticMethod()) {
                Element element = builderProducer.getElement();
                Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
                list = CollectionsKt.listOf((Object)((ExecutableElement)element));
            } else {
                TypeElement typeElement;
                if (builderProducer == null) {
                    typeElement = documentClass;
                } else {
                    Element element = builderProducer.getElement();
                    Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type javax.lang.model.element.TypeElement");
                    typeElement = (TypeElement)element;
                }
                TypeElement targetClass = typeElement;
                List<ExecutableElement> list2 = targetClass.getEnclosedElements().stream().filter(arg_0 -> Companion.extractPotentialCreationMethods$lambda$5(arg_0 -> Companion.extractPotentialCreationMethods$lambda$4(helper, arg_0), arg_0)).map(arg_0 -> Companion.extractPotentialCreationMethods$lambda$7(Companion::extractPotentialCreationMethods$lambda$6, arg_0)).toList();
                Intrinsics.checkNotNull(list2);
                list = list2;
            }
            List<ExecutableElement> potentialMethods = list;
            ProcessingException exception = new ProcessingException("Could not find a suitable creation method", documentClass);
            List creationMethods = new ArrayList();
            for (ExecutableElement candidate : potentialMethods) {
                try {
                    creationMethods.add(CreationMethod.Companion.inferParamAssociationsAndCreate(candidate, (Collection<AnnotatedGetterOrField>)annotatedGettersAndFields, builderProducer == null));
                }
                catch (ProcessingException e) {
                    exception.addWarning(e);
                }
            }
            if (creationMethods.isEmpty()) {
                throw exception;
            }
            return creationMethods;
        }

        private final String getCommaSeparatedJvmNames(Collection<AnnotatedGetterOrField> gettersAndFields) {
            String string = gettersAndFields.stream().map(arg_0 -> Companion.getCommaSeparatedJvmNames$lambda$8((Function1)getCommaSeparatedJvmNames.1.INSTANCE, arg_0)).collect(Collectors.joining(", "));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"collect(...)");
            return string;
        }

        private static final String findSetter$lambda$0(AnnotatedGetterOrField $getterOrField, String it) {
            return "[public] void " + it + "(" + $getterOrField.getJvmType() + ")";
        }

        private static final String findSetter$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final boolean findSetter$lambda$2(Set $setterNames, ExecutableElement method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            return $setterNames.contains(method.getSimpleName().toString());
        }

        private static final boolean findSetter$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean extractPotentialCreationMethods$lambda$4(IntrospectionHelper $helper, Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element.getKind() == ElementKind.CONSTRUCTOR || $helper.isStaticFactoryMethod(element);
        }

        private static final boolean extractPotentialCreationMethods$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final ExecutableElement extractPotentialCreationMethods$lambda$6(Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (ExecutableElement)element;
        }

        private static final ExecutableElement extractPotentialCreationMethods$lambda$7(Function1 $tmp0, Object p0) {
            return (ExecutableElement)$tmp0.invoke(p0);
        }

        private static final String getCommaSeparatedJvmNames$lambda$8(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AnnotatedGetterOrField.ElementTypeCategory.values().length];
                try {
                    nArray[AnnotatedGetterOrField.ElementTypeCategory.SINGLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AnnotatedGetterOrField.ElementTypeCategory.COLLECTION.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AnnotatedGetterOrField.ElementTypeCategory.ARRAY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

