/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AppSearchCompiler;
import androidx.appsearch.compiler.IntrospectionHelper;
import com.google.auto.common.GeneratedAnnotationSpecs;
import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.util.Elements;
import org.jspecify.annotations.NonNull;

public class DocumentMapGenerator {
    public static @NonNull JavaFile generate(@NonNull ProcessingEnvironment processingEnv, @NonNull String packageName, @NonNull String classSuffix, @NonNull Map<String, List<String>> documentClassMap, boolean restrictGeneratedCodeToLib) {
        ClassName superClassName = ClassName.get((String)"androidx.appsearch.app", (String)"AppSearchDocumentClassMap", (String[])new String[0]);
        TypeSpec.Builder genClass = TypeSpec.classBuilder((String)("$$__AppSearch__DocumentClassMap_" + classSuffix)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)superClassName).addAnnotation(AnnotationSpec.builder(AutoService.class).addMember("value", "$T.class", new Object[]{superClassName}).build());
        if (restrictGeneratedCodeToLib) {
            genClass.addAnnotation(AnnotationSpec.builder((ClassName)IntrospectionHelper.RESTRICT_TO_ANNOTATION_CLASS).addMember("value", "$T.LIBRARY", new Object[]{IntrospectionHelper.RESTRICT_TO_SCOPE_CLASS}).build());
        }
        GeneratedAnnotationSpecs.generatedAnnotationSpec((Elements)processingEnv.getElementUtils(), (SourceVersion)processingEnv.getSourceVersion(), AppSearchCompiler.class).ifPresent(arg_0 -> ((TypeSpec.Builder)genClass).addAnnotation(arg_0));
        ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get(String.class)})});
        genClass.addMethod(MethodSpec.methodBuilder((String)"getMap").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)returnType).addAnnotation(NonNull.class).addAnnotation(Override.class).addStatement("$T result = new $T<>()", new Object[]{returnType, ClassName.get(HashMap.class)}).addCode(DocumentMapGenerator.getMapConstructionCode(documentClassMap)).addStatement("return result", new Object[0]).build());
        return JavaFile.builder((String)packageName, (TypeSpec)genClass.build()).build();
    }

    private static CodeBlock getMapConstructionCode(@NonNull Map<String, List<String>> documentClassMap) {
        CodeBlock.Builder mapContentBuilder = CodeBlock.builder();
        documentClassMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            String valueString = ((List)entry.getValue()).stream().map(value -> "\"" + value + "\"").collect(Collectors.joining(", "));
            mapContentBuilder.addStatement("result.put($S, $T.asList($L))", new Object[]{entry.getKey(), ClassName.get(Arrays.class), valueString});
        });
        return mapContentBuilder.build();
    }

    private DocumentMapGenerator() {
    }
}

