/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.annotation.RestrictTo;
import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.DocumentClassCreationInfo;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.PropertyAccessor;
import androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.MetadataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.PropertyAnnotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class DocumentModel {
    private static final String CLASS_SUFFIX = ".class";
    private final IntrospectionHelper mHelper;
    private final Elements mElementUtil;
    private final TypeElement mClass;
    private final String mQualifiedDocumentClassName;
    private final String mSchemaName;
    private final LinkedHashSet<TypeElement> mParentTypes;
    private final LinkedHashSet<AnnotatedGetterOrField> mAnnotatedGettersAndFields;
    private final @NonNull AnnotatedGetterOrField mIdAnnotatedGetterOrField;
    private final @NonNull AnnotatedGetterOrField mNamespaceAnnotatedGetterOrField;
    private final @NonNull Map<AnnotatedGetterOrField, PropertyAccessor> mAccessors;
    private final @NonNull DocumentClassCreationInfo mDocumentClassCreationInfo;

    private DocumentModel(@NonNull ProcessingEnvironment env, @NonNull TypeElement clazz, @Nullable TypeElement generatedAutoValueElement) throws ProcessingException {
        if (clazz.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ProcessingException("@Document annotated class is private", clazz);
        }
        this.mHelper = new IntrospectionHelper(env);
        this.mElementUtil = env.getElementUtils();
        this.mClass = clazz;
        this.mQualifiedDocumentClassName = generatedAutoValueElement != null ? generatedAutoValueElement.getQualifiedName().toString() : clazz.getQualifiedName().toString();
        this.mParentTypes = this.getParentSchemaTypes(clazz);
        List<TypeElement> classHierarchy = IntrospectionHelper.generateClassHierarchy(clazz);
        this.mSchemaName = this.computeSchemaName(classHierarchy);
        this.mAnnotatedGettersAndFields = DocumentModel.scanAnnotatedGettersAndFields(classHierarchy, env);
        this.requireNoDuplicateMetadataProperties();
        this.mIdAnnotatedGetterOrField = this.requireGetterOrFieldMatchingPredicate(getterOrField -> getterOrField.getAnnotation() == MetadataPropertyAnnotation.ID, "All @Document classes must have exactly one field annotated with @Id");
        this.mNamespaceAnnotatedGetterOrField = this.requireGetterOrFieldMatchingPredicate(getterOrField -> getterOrField.getAnnotation() == MetadataPropertyAnnotation.NAMESPACE, "All @Document classes must have exactly one field annotated with @Namespace");
        LinkedHashSet<ExecutableElement> allMethods = this.mHelper.getAllMethods(clazz);
        this.mAccessors = DocumentModel.inferPropertyAccessors(this.mAnnotatedGettersAndFields, allMethods, this.mHelper);
        this.mDocumentClassCreationInfo = DocumentClassCreationInfo.infer(clazz, this.mAnnotatedGettersAndFields, this.mHelper);
    }

    private static LinkedHashSet<AnnotatedGetterOrField> scanAnnotatedGettersAndFields(@NonNull List<TypeElement> hierarchy, @NonNull ProcessingEnvironment env) throws ProcessingException {
        AnnotatedGetterAndFieldAccumulator accumulator = new AnnotatedGetterAndFieldAccumulator();
        for (TypeElement type : hierarchy) {
            for (Element element : type.getEnclosedElements()) {
                AnnotatedGetterOrField getterOrField = AnnotatedGetterOrField.tryCreateFor(element, env);
                if (getterOrField == null) continue;
                accumulator.add(getterOrField);
            }
        }
        return accumulator.getAccumulatedGettersAndFields();
    }

    private void requireNoDuplicateMetadataProperties() throws ProcessingException {
        Map<MetadataPropertyAnnotation, List<AnnotatedGetterOrField>> annotationToGettersAndFields = this.mAnnotatedGettersAndFields.stream().filter(getterOrField -> getterOrField.getAnnotation().getPropertyKind() == PropertyAnnotation.Kind.METADATA_PROPERTY).collect(Collectors.groupingBy(getterOrField -> (MetadataPropertyAnnotation)getterOrField.getAnnotation()));
        for (Map.Entry<MetadataPropertyAnnotation, List<AnnotatedGetterOrField>> entry : annotationToGettersAndFields.entrySet()) {
            MetadataPropertyAnnotation annotation = entry.getKey();
            List<AnnotatedGetterOrField> gettersAndFields = entry.getValue();
            if (gettersAndFields.size() <= 1) continue;
            throw new ProcessingException("Duplicate member annotated with @" + annotation.getClassName().simpleName(), gettersAndFields.get(0).getElement());
        }
    }

    private @NonNull AnnotatedGetterOrField requireGetterOrFieldMatchingPredicate(@NonNull Predicate<AnnotatedGetterOrField> predicate, @NonNull String errorMessage) throws ProcessingException {
        return this.mAnnotatedGettersAndFields.stream().filter(predicate).findFirst().orElseThrow(() -> new ProcessingException(errorMessage, this.mClass));
    }

    public static DocumentModel createPojoModel(@NonNull ProcessingEnvironment env, @NonNull TypeElement clazz) throws ProcessingException {
        return new DocumentModel(env, clazz, null);
    }

    public static DocumentModel createAutoValueModel(@NonNull ProcessingEnvironment env, @NonNull TypeElement clazz, @NonNull TypeElement generatedAutoValueElement) throws ProcessingException {
        return new DocumentModel(env, clazz, generatedAutoValueElement);
    }

    public @NonNull TypeElement getClassElement() {
        return this.mClass;
    }

    public @NonNull String getQualifiedDocumentClassName() {
        return this.mQualifiedDocumentClassName;
    }

    public @NonNull String getSchemaName() {
        return this.mSchemaName;
    }

    public @NonNull Set<TypeElement> getParentTypes() {
        return this.mParentTypes;
    }

    public @NonNull Set<AnnotatedGetterOrField> getAnnotatedGettersAndFields() {
        return this.mAnnotatedGettersAndFields;
    }

    public @NonNull AnnotatedGetterOrField getIdAnnotatedGetterOrField() {
        return this.mIdAnnotatedGetterOrField;
    }

    public @NonNull AnnotatedGetterOrField getNamespaceAnnotatedGetterOrField() {
        return this.mNamespaceAnnotatedGetterOrField;
    }

    public @NonNull PropertyAccessor getAccessor(@NonNull AnnotatedGetterOrField getterOrField) {
        PropertyAccessor accessor = this.mAccessors.get(getterOrField);
        if (accessor == null) {
            throw new IllegalArgumentException("No such getter/field belongs to this DocumentModel: " + String.valueOf(getterOrField));
        }
        return accessor;
    }

    public @NonNull DocumentClassCreationInfo getDocumentClassCreationInfo() {
        return this.mDocumentClassCreationInfo;
    }

    private static @NonNull Map<AnnotatedGetterOrField, PropertyAccessor> inferPropertyAccessors(@NonNull Collection<AnnotatedGetterOrField> annotatedGettersAndFields, @NonNull Collection<ExecutableElement> allMethods, @NonNull IntrospectionHelper helper) throws ProcessingException {
        HashMap<AnnotatedGetterOrField, PropertyAccessor> accessors = new HashMap<AnnotatedGetterOrField, PropertyAccessor>();
        for (AnnotatedGetterOrField getterOrField : annotatedGettersAndFields) {
            accessors.put(getterOrField, PropertyAccessor.infer(getterOrField, allMethods, helper));
        }
        return accessors;
    }

    private @NonNull LinkedHashSet<TypeElement> getParentSchemaTypes(@NonNull TypeElement documentClass) throws ProcessingException {
        AnnotationMirror documentAnnotation = Objects.requireNonNull(IntrospectionHelper.getDocumentAnnotation(documentClass));
        Map<String, Object> params = this.mHelper.getAnnotationParams(documentAnnotation);
        LinkedHashSet<TypeElement> parentsSchemaTypes = new LinkedHashSet<TypeElement>();
        Object parentsParam = params.get("parent");
        if (parentsParam instanceof List) {
            for (Object parent : (List)parentsParam) {
                String parentClassName = parent.toString();
                parentClassName = parentClassName.substring(0, parentClassName.length() - CLASS_SUFFIX.length());
                parentsSchemaTypes.add(this.mElementUtil.getTypeElement(parentClassName));
            }
        }
        if (!parentsSchemaTypes.isEmpty() && params.get("name").toString().isEmpty()) {
            throw new ProcessingException("All @Document classes with a parent must explicitly provide a name", this.mClass);
        }
        return parentsSchemaTypes;
    }

    private @NonNull String computeSchemaName(List<TypeElement> hierarchy) {
        for (int i = hierarchy.size() - 1; i >= 0; --i) {
            Map<String, Object> params;
            String name;
            AnnotationMirror documentAnnotation = IntrospectionHelper.getDocumentAnnotation(hierarchy.get(i));
            if (documentAnnotation == null || (name = (params = this.mHelper.getAnnotationParams(documentAnnotation)).get("name").toString()).isEmpty()) continue;
            return name;
        }
        TypeElement rootDocumentClass = hierarchy.get(0);
        AnnotationMirror rootDocumentAnnotation = IntrospectionHelper.getDocumentAnnotation(rootDocumentClass);
        if (rootDocumentAnnotation == null) {
            return this.mClass.getSimpleName().toString();
        }
        return rootDocumentClass.getSimpleName().toString();
    }

    private static final class AnnotatedGetterAndFieldAccumulator {
        private final Map<String, AnnotatedGetterOrField> mJvmNameToGetterOrField = new LinkedHashMap<String, AnnotatedGetterOrField>();
        private final Map<String, AnnotatedGetterOrField> mSerializedNameToGetterOrField = new HashMap<String, AnnotatedGetterOrField>();
        private final Map<String, AnnotatedGetterOrField> mNormalizedNameToGetterOrField = new HashMap<String, AnnotatedGetterOrField>();

        AnnotatedGetterAndFieldAccumulator() {
        }

        void add(@NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
            String jvmName = getterOrField.getJvmName();
            AnnotatedGetterOrField existingGetterOrField = this.mJvmNameToGetterOrField.get(jvmName);
            if (existingGetterOrField == null) {
                this.mJvmNameToGetterOrField.put(jvmName, getterOrField);
                this.requireUniqueNormalizedName(getterOrField);
                this.mNormalizedNameToGetterOrField.put(getterOrField.getNormalizedName(), getterOrField);
                if (AnnotatedGetterAndFieldAccumulator.hasDataPropertyAnnotation(getterOrField)) {
                    this.requireSerializedNameNeverSeenBefore(getterOrField);
                    this.mSerializedNameToGetterOrField.put(AnnotatedGetterAndFieldAccumulator.getSerializedName(getterOrField), getterOrField);
                }
            } else {
                AnnotatedGetterAndFieldAccumulator.requireAnnotationTypeIsConsistent(existingGetterOrField, getterOrField);
                this.mJvmNameToGetterOrField.put(jvmName, getterOrField);
                this.mNormalizedNameToGetterOrField.put(getterOrField.getNormalizedName(), getterOrField);
                if (AnnotatedGetterAndFieldAccumulator.hasDataPropertyAnnotation(getterOrField)) {
                    AnnotatedGetterAndFieldAccumulator.requireSerializedNameIsConsistent(existingGetterOrField, getterOrField);
                    this.mSerializedNameToGetterOrField.put(AnnotatedGetterAndFieldAccumulator.getSerializedName(getterOrField), getterOrField);
                }
            }
        }

        @NonNull LinkedHashSet<AnnotatedGetterOrField> getAccumulatedGettersAndFields() {
            return new LinkedHashSet<AnnotatedGetterOrField>(this.mJvmNameToGetterOrField.values());
        }

        private void requireUniqueNormalizedName(@NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
            AnnotatedGetterOrField existingGetterOrField = this.mNormalizedNameToGetterOrField.get(getterOrField.getNormalizedName());
            if (existingGetterOrField == null) {
                return;
            }
            if (existingGetterOrField.getJvmName().equals(getterOrField.getJvmName())) {
                return;
            }
            throw new ProcessingException("Normalized name \"%s\" is already taken up by pre-existing %s. Please rename this getter/field to something else.".formatted(getterOrField.getNormalizedName(), AnnotatedGetterAndFieldAccumulator.createSignatureString(existingGetterOrField)), getterOrField.getElement());
        }

        private void requireSerializedNameNeverSeenBefore(@NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
            String serializedName = AnnotatedGetterAndFieldAccumulator.getSerializedName(getterOrField);
            AnnotatedGetterOrField existingGetterOrField = this.mSerializedNameToGetterOrField.get(serializedName);
            if (existingGetterOrField != null) {
                throw new ProcessingException("Cannot give property the name '%s' because it is already used for %s".formatted(serializedName, existingGetterOrField.getJvmName()), getterOrField.getElement());
            }
        }

        private static @NonNull String getSerializedName(@NonNull AnnotatedGetterOrField getterOrField) {
            DataPropertyAnnotation annotation = (DataPropertyAnnotation)getterOrField.getAnnotation();
            return annotation.getName();
        }

        private static boolean hasDataPropertyAnnotation(@NonNull AnnotatedGetterOrField getterOrField) {
            PropertyAnnotation annotation = getterOrField.getAnnotation();
            return annotation.getPropertyKind() == PropertyAnnotation.Kind.DATA_PROPERTY;
        }

        private static void requireAnnotationTypeIsConsistent(@NonNull AnnotatedGetterOrField existingGetterOrField, @NonNull AnnotatedGetterOrField overriddenGetterOfField) throws ProcessingException {
            PropertyAnnotation existingAnnotation = existingGetterOrField.getAnnotation();
            PropertyAnnotation overriddenAnnotation = overriddenGetterOfField.getAnnotation();
            if (!existingAnnotation.getClassName().equals((Object)overriddenAnnotation.getClassName())) {
                throw new ProcessingException("Property type must stay consistent when overriding annotated members but changed from @%s -> @%s".formatted(existingAnnotation.getClassName().simpleName(), overriddenAnnotation.getClassName().simpleName()), overriddenGetterOfField.getElement());
            }
        }

        private static void requireSerializedNameIsConsistent(@NonNull AnnotatedGetterOrField existingGetterOrField, @NonNull AnnotatedGetterOrField overriddenGetterOrField) throws ProcessingException {
            String overriddenSerializedName;
            String existingSerializedName = AnnotatedGetterAndFieldAccumulator.getSerializedName(existingGetterOrField);
            if (!existingSerializedName.equals(overriddenSerializedName = AnnotatedGetterAndFieldAccumulator.getSerializedName(overriddenGetterOrField))) {
                throw new ProcessingException("Property name within the annotation must stay consistent when overriding " + "annotated members but changed from '%s' -> '%s'".formatted(existingSerializedName, overriddenSerializedName), overriddenGetterOrField.getElement());
            }
        }

        private static @NonNull String createSignatureString(@NonNull AnnotatedGetterOrField getterOrField) {
            return String.valueOf(getterOrField.getJvmType()) + " " + String.valueOf(getterOrField.getElement().getEnclosingElement().getSimpleName()) + "#" + getterOrField.getJvmName() + (getterOrField.isGetter() ? "()" : "");
        }
    }
}

