/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.CodegenUtils;
import androidx.appsearch.compiler.CreationMethod;
import androidx.appsearch.compiler.DocumentClassCreationInfo;
import androidx.appsearch.compiler.DocumentModel;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.SetterOrField;
import androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.LongPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.MetadataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.PropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.SerializerClass;
import androidx.appsearch.compiler.annotationwrapper.StringPropertyAnnotation;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.NonNull;

class FromGenericDocumentCodeGenerator {
    private final ProcessingEnvironment mEnv;
    private final IntrospectionHelper mHelper;
    private final DocumentModel mModel;

    private FromGenericDocumentCodeGenerator(@NonNull ProcessingEnvironment env, @NonNull DocumentModel model) {
        this.mEnv = env;
        this.mHelper = new IntrospectionHelper(env);
        this.mModel = model;
    }

    public static void generate(@NonNull ProcessingEnvironment env, @NonNull DocumentModel model, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TypeSpec.Builder classBuilder) {
        new FromGenericDocumentCodeGenerator(env, model).generate(classBuilder);
    }

    private void generate(TypeSpec.Builder classBuilder) {
        classBuilder.addMethod(this.createFromGenericDocumentMethod());
    }

    private MethodSpec createFromGenericDocumentMethod() {
        TypeName documentClass = TypeName.get((TypeMirror)this.mModel.getClassElement().asType());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"fromGenericDocument").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(documentClass).addAnnotation(Override.class).addParameter((TypeName)IntrospectionHelper.GENERIC_DOCUMENT_CLASS, "genericDoc", new Modifier[0]).addParameter((TypeName)IntrospectionHelper.DOCUMENT_CLASS_MAPPING_CONTEXT_CLASS, "documentClassMappingContext", new Modifier[0]).addException((TypeName)IntrospectionHelper.APPSEARCH_EXCEPTION_CLASS);
        for (AnnotatedGetterOrField getterOrField : this.mModel.getAnnotatedGettersAndFields()) {
            if (getterOrField.getAnnotation().getPropertyKind() != PropertyAnnotation.Kind.METADATA_PROPERTY) continue;
            methodBuilder.addCode(this.createCodeToExtractFromGenericDoc((MetadataPropertyAnnotation)getterOrField.getAnnotation(), getterOrField));
        }
        for (AnnotatedGetterOrField getterOrField : this.mModel.getAnnotatedGettersAndFields()) {
            if (getterOrField.getAnnotation().getPropertyKind() != PropertyAnnotation.Kind.DATA_PROPERTY) continue;
            methodBuilder.addCode(this.createCodeToExtractFromGenericDoc((DataPropertyAnnotation)getterOrField.getAnnotation(), getterOrField));
        }
        DocumentClassCreationInfo documentClassCreationInfo = this.mModel.getDocumentClassCreationInfo();
        CreationMethod creationMethod = documentClassCreationInfo.getCreationMethod();
        String variableName = creationMethod.getReturnsBuilder() ? "builder" : "document";
        List<CodeBlock> params = creationMethod.getParamAssociations().stream().map(annotatedGetterOrField -> CodeBlock.of((String)"$NConv", (Object[])new Object[]{annotatedGetterOrField.getJvmName()})).toList();
        if (creationMethod.isConstructor()) {
            methodBuilder.addStatement("$T $N = new $T($L)", new Object[]{creationMethod.getReturnType(), variableName, creationMethod.getReturnType(), CodeBlock.join(params, (String)", ")});
        } else {
            methodBuilder.addStatement("$T $N = $T.$N($L)", new Object[]{creationMethod.getReturnType(), variableName, creationMethod.getEnclosingClass(), creationMethod.getJvmName(), CodeBlock.join(params, (String)", ")});
        }
        for (Map.Entry<AnnotatedGetterOrField, SetterOrField> entry : documentClassCreationInfo.getSettersAndFields().entrySet()) {
            AnnotatedGetterOrField getterOrField = entry.getKey();
            SetterOrField setterOrField = entry.getValue();
            if (setterOrField.isSetter()) {
                methodBuilder.addStatement("$N.$N($NConv)", new Object[]{variableName, setterOrField.getJvmName(), getterOrField.getJvmName()});
                continue;
            }
            methodBuilder.addStatement("$N.$N = $NConv", new Object[]{variableName, setterOrField.getJvmName(), getterOrField.getJvmName()});
        }
        if (creationMethod.getReturnsBuilder()) {
            methodBuilder.addStatement("return $N.build()", new Object[]{variableName});
        } else {
            methodBuilder.addStatement("return $N", new Object[]{variableName});
        }
        return methodBuilder.build();
    }

    private CodeBlock createCodeToExtractFromGenericDoc(@NonNull MetadataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        return CodeBlock.builder().addStatement("$T $NConv = $L", new Object[]{getterOrField.getJvmType(), getterOrField.getJvmName(), this.maybeApplyNarrowingCast(CodeBlock.of((String)"genericDoc.$N()", (Object[])new Object[]{annotation.getGenericDocGetterName()}), annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), getterOrField.getJvmType())}).build();
    }

    private CodeBlock createCodeToExtractFromGenericDoc(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        AnnotatedGetterOrField.ElementTypeCategory typeCategory = getterOrField.getElementTypeCategory();
        switch (annotation.getDataPropertyKind()) {
            case STRING_PROPERTY: {
                SerializerClass stringSerializer = ((StringPropertyAnnotation)annotation).getCustomSerializer();
                switch (typeCategory) {
                    case COLLECTION: {
                        if (stringSerializer != null) {
                            return this.listForLoopCallDeserialize(annotation, getterOrField, stringSerializer);
                        }
                        return this.listCallArraysAsList(annotation, getterOrField);
                    }
                    case ARRAY: {
                        if (stringSerializer != null) {
                            return this.arrayForLoopCallDeserialize(annotation, getterOrField, stringSerializer);
                        }
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        if (stringSerializer != null) {
                            return this.fieldCallDeserialize(annotation, getterOrField, stringSerializer);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case DOCUMENT_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.listForLoopCallFromGenericDocument(annotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayForLoopCallFromGenericDocument(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldCallFromGenericDocument(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case LONG_PROPERTY: {
                SerializerClass longSerializer = ((LongPropertyAnnotation)annotation).getCustomSerializer();
                switch (typeCategory) {
                    case COLLECTION: {
                        if (longSerializer != null) {
                            return this.listForLoopCallDeserialize(annotation, getterOrField, longSerializer);
                        }
                        return this.listForLoopAssign(annotation, getterOrField);
                    }
                    case ARRAY: {
                        if (longSerializer != null) {
                            return this.arrayForLoopCallDeserialize(annotation, getterOrField, longSerializer);
                        }
                        if (this.mHelper.isPrimitiveLongArray(getterOrField.getJvmType())) {
                            return this.arrayUseDirectly(annotation, getterOrField);
                        }
                        return this.arrayForLoopAssign(annotation, getterOrField);
                    }
                    case SINGLE: {
                        if (longSerializer != null) {
                            return this.fieldCallDeserialize(annotation, getterOrField, longSerializer);
                        }
                        if (getterOrField.getJvmType() instanceof PrimitiveType) {
                            return this.fieldUseDirectlyWithoutNullCheck(annotation, getterOrField);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case DOUBLE_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.listForLoopAssign(annotation, getterOrField);
                    }
                    case ARRAY: {
                        if (this.mHelper.isPrimitiveDoubleArray(getterOrField.getJvmType())) {
                            return this.arrayUseDirectly(annotation, getterOrField);
                        }
                        return this.arrayForLoopAssign(annotation, getterOrField);
                    }
                    case SINGLE: {
                        if (getterOrField.getJvmType() instanceof PrimitiveType) {
                            return this.fieldUseDirectlyWithoutNullCheck(annotation, getterOrField);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case BOOLEAN_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.listForLoopAssign(annotation, getterOrField);
                    }
                    case ARRAY: {
                        if (this.mHelper.isPrimitiveBooleanArray(getterOrField.getJvmType())) {
                            return this.arrayUseDirectly(annotation, getterOrField);
                        }
                        return this.arrayForLoopAssign(annotation, getterOrField);
                    }
                    case SINGLE: {
                        if (getterOrField.getJvmType() instanceof PrimitiveType) {
                            return this.fieldUseDirectlyWithoutNullCheck(annotation, getterOrField);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case BYTES_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.listForLoopAssign(annotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case EMBEDDING_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.listCallArraysAsList(annotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case BLOB_HANDLE_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.listCallArraysAsList(annotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
        }
        throw new IllegalStateException("Unhandled annotation: " + String.valueOf(annotation));
    }

    private void addDefaultValueForList(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CodeBlock.Builder codeBlockBuilder, @NonNull AnnotatedGetterOrField getterOrField) {
        Objects.requireNonNull(codeBlockBuilder);
        Objects.requireNonNull(getterOrField);
        if (IntrospectionHelper.isNonNullKotlinField(getterOrField)) {
            codeBlockBuilder.addStatement("$T<$T> $NConv = $T.emptyList()", new Object[]{List.class, getterOrField.getComponentType(), getterOrField.getJvmName(), Collections.class});
        } else {
            codeBlockBuilder.addStatement("$T<$T> $NConv = null", new Object[]{List.class, getterOrField.getComponentType(), getterOrField.getJvmName()});
        }
    }

    private @NonNull CodeBlock listForLoopAssign(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror serializedType = annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.$N($S)", new Object[]{serializedType, getterOrField.getJvmName(), annotation.getGenericDocArrayGetterName(), annotation.getName()});
        this.addDefaultValueForList(codeBlockBuilder, getterOrField);
        return codeBlockBuilder.beginControlFlow("if ($NCopy != null)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv = new $T<>($NCopy.length)", new Object[]{getterOrField.getJvmName(), ArrayList.class, getterOrField.getJvmName()}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv.add($L)", new Object[]{getterOrField.getJvmName(), this.maybeApplyNarrowingCast(CodeBlock.of((String)"$NCopy[i]", (Object[])new Object[]{getterOrField.getJvmName()}), serializedType, getterOrField.getComponentType())}).endControlFlow().endControlFlow().build();
    }

    private @NonNull CodeBlock listCallArraysAsList(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        CodeBlock.Builder builder = CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.$N($S)", new Object[]{annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), getterOrField.getJvmName(), annotation.getGenericDocArrayGetterName(), annotation.getName()});
        this.addDefaultValueForList(builder, getterOrField);
        return builder.beginControlFlow("if ($NCopy != null)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv = $T.asList($NCopy)", new Object[]{getterOrField.getJvmName(), Arrays.class, getterOrField.getJvmName()}).endControlFlow().build();
    }

    private @NonNull CodeBlock listForLoopCallFromGenericDocument(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.getPropertyDocumentArray($S)", new Object[]{IntrospectionHelper.GENERIC_DOCUMENT_CLASS, getterOrField.getJvmName(), annotation.getName()});
        this.addDefaultValueForList(codeBlockBuilder, getterOrField);
        return codeBlockBuilder.beginControlFlow("if ($NCopy != null)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv = new $T<>($NCopy.length)", new Object[]{getterOrField.getJvmName(), ArrayList.class, getterOrField.getJvmName()}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv.add($NCopy[i].toDocumentClass($T.class, documentClassMappingContext))", new Object[]{getterOrField.getJvmName(), getterOrField.getJvmName(), getterOrField.getComponentType()}).endControlFlow().endControlFlow().build();
    }

    private @NonNull CodeBlock listForLoopCallDeserialize(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull SerializerClass serializerClass) {
        TypeMirror customType = getterOrField.getComponentType();
        String jvmName = getterOrField.getJvmName();
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.$N($S)", new Object[]{annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), jvmName, annotation.getGenericDocArrayGetterName(), annotation.getName()});
        this.addDefaultValueForList(codeBlockBuilder, getterOrField);
        return codeBlockBuilder.beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$NConv = new $T<>($NCopy.length)", new Object[]{jvmName, ArrayList.class, jvmName}).addStatement("$T serializer = new $T()", new Object[]{serializerClass.getElement(), serializerClass.getElement()}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{jvmName}).addStatement("$T elem = serializer.deserialize($NCopy[i])", new Object[]{customType, jvmName}).beginControlFlow("if (elem == null)", new Object[0]).addStatement("$NConv = null", new Object[]{jvmName}).addStatement("break", new Object[0]).endControlFlow().addStatement("$NConv.add(elem)", new Object[]{jvmName}).endControlFlow().endControlFlow().build();
    }

    private @NonNull CodeBlock arrayForLoopAssign(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror serializedType = annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper);
        return CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.$N($S)", new Object[]{serializedType, getterOrField.getJvmName(), annotation.getGenericDocArrayGetterName(), annotation.getName()}).addStatement("$T[] $NConv = null", new Object[]{getterOrField.getComponentType(), getterOrField.getJvmName()}).beginControlFlow("if ($NCopy != null)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv = $L", new Object[]{getterOrField.getJvmName(), CodegenUtils.createNewArrayExpr(getterOrField.getComponentType(), CodeBlock.of((String)"$NCopy.length", (Object[])new Object[]{getterOrField.getJvmName()}), this.mEnv)}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv[i] = $L", new Object[]{getterOrField.getJvmName(), this.maybeApplyNarrowingCast(CodeBlock.of((String)"$NCopy[i]", (Object[])new Object[]{getterOrField.getJvmName()}), serializedType, getterOrField.getComponentType())}).endControlFlow().endControlFlow().build();
    }

    private @NonNull CodeBlock arrayUseDirectly(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        return CodeBlock.builder().addStatement("$T[] $NConv = genericDoc.$N($S)", new Object[]{annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), getterOrField.getJvmName(), annotation.getGenericDocArrayGetterName(), annotation.getName()}).build();
    }

    private @NonNull CodeBlock arrayForLoopCallFromGenericDocument(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        return CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.getPropertyDocumentArray($S)", new Object[]{IntrospectionHelper.GENERIC_DOCUMENT_CLASS, getterOrField.getJvmName(), annotation.getName()}).addStatement("$T[] $NConv = null", new Object[]{getterOrField.getComponentType(), getterOrField.getJvmName()}).beginControlFlow("if ($NCopy != null)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv = new $T[$NCopy.length]", new Object[]{getterOrField.getJvmName(), getterOrField.getComponentType(), getterOrField.getJvmName()}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv[i] = $NCopy[i].toDocumentClass($T.class, documentClassMappingContext)", new Object[]{getterOrField.getJvmName(), getterOrField.getJvmName(), getterOrField.getComponentType()}).endControlFlow().endControlFlow().build();
    }

    private @NonNull CodeBlock arrayForLoopCallDeserialize(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull SerializerClass serializerClass) {
        TypeMirror customType = getterOrField.getComponentType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.$N($S)", new Object[]{annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), jvmName, annotation.getGenericDocArrayGetterName(), annotation.getName()}).addStatement("$T[] $NConv = null", new Object[]{customType, jvmName}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$NConv = $L", new Object[]{jvmName, CodegenUtils.createNewArrayExpr(customType, CodeBlock.of((String)"$NCopy.length", (Object[])new Object[]{jvmName}), this.mEnv)}).addStatement("$T serializer = new $T()", new Object[]{serializerClass.getElement(), serializerClass.getElement()}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{jvmName}).addStatement("$T elem = serializer.deserialize($NCopy[i])", new Object[]{customType, jvmName}).beginControlFlow("if (elem == null)", new Object[0]).addStatement("$NConv = null", new Object[]{jvmName}).addStatement("break", new Object[0]).endControlFlow().addStatement("$NConv[i] = elem", new Object[]{jvmName}).endControlFlow().endControlFlow().build();
    }

    private @NonNull CodeBlock fieldUseDirectlyWithNullCheck(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror serializedType = annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper);
        return CodeBlock.builder().addStatement("$T[] $NCopy = genericDoc.$N($S)", new Object[]{serializedType, getterOrField.getJvmName(), annotation.getGenericDocArrayGetterName(), annotation.getName()}).addStatement("$T $NConv = null", new Object[]{getterOrField.getJvmType(), getterOrField.getJvmName()}).beginControlFlow("if ($NCopy != null && $NCopy.length != 0)", new Object[]{getterOrField.getJvmName(), getterOrField.getJvmName()}).addStatement("$NConv = $L", new Object[]{getterOrField.getJvmName(), this.maybeApplyNarrowingCast(CodeBlock.of((String)"$NCopy[0]", (Object[])new Object[]{getterOrField.getJvmName()}), serializedType, getterOrField.getJvmType())}).endControlFlow().build();
    }

    private @NonNull CodeBlock fieldUseDirectlyWithoutNullCheck(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        return CodeBlock.builder().addStatement("$T $NConv = $L", new Object[]{getterOrField.getJvmType(), getterOrField.getJvmName(), this.maybeApplyNarrowingCast(CodeBlock.of((String)"genericDoc.$N($S)", (Object[])new Object[]{annotation.getGenericDocGetterName(), annotation.getName()}), annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), getterOrField.getJvmType())}).build();
    }

    private @NonNull CodeBlock fieldCallFromGenericDocument(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        return CodeBlock.builder().addStatement("$T $NCopy = genericDoc.getPropertyDocument($S)", new Object[]{IntrospectionHelper.GENERIC_DOCUMENT_CLASS, getterOrField.getJvmName(), annotation.getName()}).addStatement("$T $NConv = null", new Object[]{getterOrField.getJvmType(), getterOrField.getJvmName()}).beginControlFlow("if ($NCopy != null)", new Object[]{getterOrField.getJvmName()}).addStatement("$NConv = $NCopy.toDocumentClass($T.class, documentClassMappingContext)", new Object[]{getterOrField.getJvmName(), getterOrField.getJvmName(), getterOrField.getJvmType()}).endControlFlow().build();
    }

    private @NonNull CodeBlock fieldCallDeserialize(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull SerializerClass serializerClass) {
        boolean nullCheckRequired;
        TypeMirror customType = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        TypeMirror propType = annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper);
        CodeBlock.Builder codeBlock = CodeBlock.builder().addStatement("$T $NCopy = genericDoc.$N($S)", new Object[]{propType, jvmName, annotation.getGenericDocGetterName(), annotation.getName()}).addStatement("$T $NConv = null", new Object[]{customType, jvmName});
        boolean bl = nullCheckRequired = !(propType instanceof PrimitiveType);
        if (nullCheckRequired) {
            codeBlock.beginControlFlow("if ($NCopy != null)", new Object[]{jvmName});
        }
        codeBlock.addStatement("$NConv = new $T().deserialize($NCopy)", new Object[]{jvmName, serializerClass.getElement(), jvmName});
        if (nullCheckRequired) {
            codeBlock.endControlFlow();
        }
        return codeBlock.build();
    }

    private @NonNull CodeBlock maybeApplyNarrowingCast(@NonNull CodeBlock expr, @NonNull TypeMirror exprType, @NonNull TypeMirror targetType) {
        TypeMirror castType = this.mHelper.getNarrowingCastType(exprType, targetType);
        if (castType == null) {
            return expr;
        }
        return CodeBlock.of((String)"($T) $L", (Object[])new Object[]{castType, expr});
    }
}

