/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.DocumentPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.PropertyAnnotation;
import com.google.auto.common.MoreTypes;
import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.Attributes;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmProperty;
import kotlin.metadata.KmType;
import kotlin.metadata.jvm.KotlinClassMetadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 [2\u00020\u0001:\u0002[\\B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u0002002\u0006\u00107\u001a\u000208J'\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0>\"\u00020\u000b\u00a2\u0006\u0002\u0010?J\u000e\u0010@\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u001c\u0010A\u001a\u0010\u0012\u0004\u0012\u000208\u0012\u0006\u0012\u0004\u0018\u00010\u00010B2\u0006\u0010C\u001a\u00020DJ\u001e\u0010E\u001a\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`32\u0006\u00106\u001a\u000200J\u000e\u0010F\u001a\u00020:2\u0006\u0010G\u001a\u00020\u000bJ\u000e\u0010H\u001a\u00020:2\u0006\u0010G\u001a\u00020\u000bJ\u000e\u0010I\u001a\u00020:2\u0006\u0010G\u001a\u00020\u000bJ\u0018\u0010J\u001a\u00020:2\u0006\u0010G\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u000bH\u0002J\u001c\u0010L\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010O\u001a\u0002022\u0006\u0010P\u001a\u00020\u000bJ\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020R0Q2\u0006\u0010G\u001a\u00020SJ\u0016\u0010T\u001a\u00020:2\u0006\u0010O\u001a\u00020U2\u0006\u0010G\u001a\u00020\u000bJ\u0018\u0010V\u001a\u0004\u0018\u00010\u000b2\u0006\u0010W\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u000bJ\u000e\u0010Y\u001a\u00020:2\u0006\u0010Z\u001a\u00020<R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0010\u0010\u0016\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u0011\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\rR\u0011\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0011\u0010\u001d\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\rR\u0011\u0010\u001f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u0011\u0010!\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\rR\u0011\u0010#\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\rR\u0010\u0010%\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\rR\u0010\u0010(\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\rR\u0010\u0010,\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R*\u0010.\u001a\u001e\u0012\u0004\u0012\u000200\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020201j\b\u0012\u0004\u0012\u000202`30/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Landroidx/appsearch/compiler/IntrospectionHelper;", "", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "<init>", "(Ljavax/annotation/processing/ProcessingEnvironment;)V", "typeUtils", "Ljavax/lang/model/util/Types;", "elementUtils", "Ljavax/lang/model/util/Elements;", "blobHandleType", "Ljavax/lang/model/type/TypeMirror;", "getBlobHandleType", "()Ljavax/lang/model/type/TypeMirror;", "collectionType", "getCollectionType", "embeddingType", "getEmbeddingType", "genericDocumentType", "getGenericDocumentType", "listType", "getListType", "stringType", "booleanBoxType", "getBooleanBoxType", "byteBoxType", "getByteBoxType", "byteBoxArrayType", "getByteBoxArrayType", "doubleBoxType", "getDoubleBoxType", "floatBoxType", "getFloatBoxType", "integerBoxType", "getIntegerBoxType", "longBoxType", "getLongBoxType", "booleanPrimitiveType", "bytePrimitiveType", "getBytePrimitiveType", "bytePrimitiveArrayType", "doublePrimitiveType", "floatPrimitiveType", "getFloatPrimitiveType", "intPrimitiveType", "longPrimitiveType", "allMethodsCache", "Ljava/util/WeakHashMap;", "Ljavax/lang/model/element/TypeElement;", "Ljava/util/LinkedHashSet;", "Ljavax/lang/model/element/ExecutableElement;", "Lkotlin/collections/LinkedHashSet;", "getDocumentPropertyAnnotation", "Landroidx/appsearch/compiler/annotationwrapper/DocumentPropertyAnnotation;", "clazz", "propertyName", "", "isFieldOfExactType", "", "property", "Ljavax/lang/model/element/Element;", "validTypes", "", "(Ljavax/lang/model/element/Element;[Ljavax/lang/model/type/TypeMirror;)Z", "isFieldOfBooleanType", "getAnnotationParams", "", "annotation", "Ljavax/lang/model/element/AnnotationMirror;", "getAllMethods", "isPrimitiveLongArray", "type", "isPrimitiveDoubleArray", "isPrimitiveBooleanArray", "isArrayOf", "arrayComponentType", "validateIsGetterThatReturns", "", "Landroidx/appsearch/compiler/ProcessingException;", "method", "expectedReturnType", "Ljava/util/stream/Stream;", "Landroidx/appsearch/compiler/IntrospectionHelper$MethodTypeAndElement;", "Ljavax/lang/model/type/DeclaredType;", "isReturnTypeMatching", "Ljavax/lang/model/type/ExecutableType;", "getNarrowingCastType", "sourceType", "targetType", "isStaticFactoryMethod", "element", "Companion", "MethodTypeAndElement", "appsearch-compiler"})
public final class IntrospectionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessingEnvironment env;
    @NotNull
    private final Types typeUtils;
    @NotNull
    private final Elements elementUtils;
    @NotNull
    private final TypeMirror blobHandleType;
    @NotNull
    private final TypeMirror collectionType;
    @NotNull
    private final TypeMirror embeddingType;
    @NotNull
    private final TypeMirror genericDocumentType;
    @NotNull
    private final TypeMirror listType;
    @JvmField
    @NotNull
    public final TypeMirror stringType;
    @NotNull
    private final TypeMirror booleanBoxType;
    @NotNull
    private final TypeMirror byteBoxType;
    @NotNull
    private final TypeMirror byteBoxArrayType;
    @NotNull
    private final TypeMirror doubleBoxType;
    @NotNull
    private final TypeMirror floatBoxType;
    @NotNull
    private final TypeMirror integerBoxType;
    @NotNull
    private final TypeMirror longBoxType;
    @JvmField
    @NotNull
    public final TypeMirror booleanPrimitiveType;
    @NotNull
    private final TypeMirror bytePrimitiveType;
    @JvmField
    @NotNull
    public final TypeMirror bytePrimitiveArrayType;
    @JvmField
    @NotNull
    public final TypeMirror doublePrimitiveType;
    @NotNull
    private final TypeMirror floatPrimitiveType;
    @JvmField
    @NotNull
    public final TypeMirror intPrimitiveType;
    @JvmField
    @NotNull
    public final TypeMirror longPrimitiveType;
    @NotNull
    private final WeakHashMap<TypeElement, LinkedHashSet<ExecutableElement>> allMethodsCache;
    @NotNull
    public static final String GEN_CLASS_PREFIX = "$$__AppSearch__";
    @NotNull
    public static final String APPSEARCH_PKG = "androidx.appsearch.app";
    @JvmField
    @NotNull
    public static final ClassName APPSEARCH_SCHEMA_CLASS;
    @JvmField
    @NotNull
    public static final ClassName PROPERTY_CONFIG_CLASS;
    @NotNull
    public static final String APPSEARCH_EXCEPTION_PKG = "androidx.appsearch.exceptions";
    @JvmField
    @NotNull
    public static final ClassName APPSEARCH_EXCEPTION_CLASS;
    @NotNull
    public static final String APPSEARCH_ANNOTATION_PKG = "androidx.appsearch.annotation";
    @NotNull
    public static final String DOCUMENT_ANNOTATION_SIMPLE_CLASS_NAME = "Document";
    @JvmField
    @NotNull
    public static final ClassName DOCUMENT_ANNOTATION_CLASS;
    @JvmField
    @NotNull
    public static final ClassName GENERIC_DOCUMENT_CLASS;
    @NotNull
    private static final ClassName EMBEDDING_VECTOR_CLASS;
    @NotNull
    private static final ClassName APPSEARCH_BLOB_HANDLE_CLASS;
    @NotNull
    private static final ClassName BUILDER_PRODUCER_CLASS;
    @JvmField
    @NotNull
    public static final ClassName DOCUMENT_CLASS_FACTORY_CLASS;
    @JvmField
    @NotNull
    public static final ClassName RESTRICT_TO_ANNOTATION_CLASS;
    @JvmField
    @NotNull
    public static final ClassName RESTRICT_TO_SCOPE_CLASS;
    @JvmField
    @NotNull
    public static final ClassName DOCUMENT_CLASS_MAPPING_CONTEXT_CLASS;

    public IntrospectionHelper(@NotNull ProcessingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
        Types types = this.env.getTypeUtils();
        Intrinsics.checkNotNullExpressionValue((Object)types, (String)"getTypeUtils(...)");
        this.typeUtils = types;
        Elements elements = this.env.getElementUtils();
        Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"getElementUtils(...)");
        this.elementUtils = elements;
        TypeMirror typeMirror = this.elementUtils.getTypeElement(APPSEARCH_BLOB_HANDLE_CLASS.canonicalName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"asType(...)");
        this.blobHandleType = typeMirror;
        TypeMirror typeMirror2 = this.elementUtils.getTypeElement(Collection.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror2, (String)"asType(...)");
        this.collectionType = typeMirror2;
        TypeMirror typeMirror3 = this.elementUtils.getTypeElement(EMBEDDING_VECTOR_CLASS.canonicalName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror3, (String)"asType(...)");
        this.embeddingType = typeMirror3;
        TypeMirror typeMirror4 = this.elementUtils.getTypeElement(GENERIC_DOCUMENT_CLASS.canonicalName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror4, (String)"asType(...)");
        this.genericDocumentType = typeMirror4;
        TypeMirror typeMirror5 = this.elementUtils.getTypeElement(List.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror5, (String)"asType(...)");
        this.listType = typeMirror5;
        TypeMirror typeMirror6 = this.elementUtils.getTypeElement(String.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror6, (String)"asType(...)");
        this.stringType = typeMirror6;
        TypeMirror typeMirror7 = this.elementUtils.getTypeElement(Boolean.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror7, (String)"asType(...)");
        this.booleanBoxType = typeMirror7;
        TypeMirror typeMirror8 = this.elementUtils.getTypeElement(Byte.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror8, (String)"asType(...)");
        this.byteBoxType = typeMirror8;
        ArrayType arrayType = this.typeUtils.getArrayType(this.byteBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)arrayType, (String)"getArrayType(...)");
        this.byteBoxArrayType = arrayType;
        TypeMirror typeMirror9 = this.elementUtils.getTypeElement(Double.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror9, (String)"asType(...)");
        this.doubleBoxType = typeMirror9;
        TypeMirror typeMirror10 = this.elementUtils.getTypeElement(Float.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror10, (String)"asType(...)");
        this.floatBoxType = typeMirror10;
        TypeMirror typeMirror11 = this.elementUtils.getTypeElement(Integer.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror11, (String)"asType(...)");
        this.integerBoxType = typeMirror11;
        TypeMirror typeMirror12 = this.elementUtils.getTypeElement(Long.class.getName()).asType();
        Intrinsics.checkNotNullExpressionValue((Object)typeMirror12, (String)"asType(...)");
        this.longBoxType = typeMirror12;
        PrimitiveType primitiveType = this.typeUtils.unboxedType(this.booleanBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveType, (String)"unboxedType(...)");
        this.booleanPrimitiveType = primitiveType;
        PrimitiveType primitiveType2 = this.typeUtils.unboxedType(this.byteBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveType2, (String)"unboxedType(...)");
        this.bytePrimitiveType = primitiveType2;
        ArrayType arrayType2 = this.typeUtils.getArrayType(this.bytePrimitiveType);
        Intrinsics.checkNotNullExpressionValue((Object)arrayType2, (String)"getArrayType(...)");
        this.bytePrimitiveArrayType = arrayType2;
        PrimitiveType primitiveType3 = this.typeUtils.unboxedType(this.doubleBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveType3, (String)"unboxedType(...)");
        this.doublePrimitiveType = primitiveType3;
        PrimitiveType primitiveType4 = this.typeUtils.unboxedType(this.floatBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveType4, (String)"unboxedType(...)");
        this.floatPrimitiveType = primitiveType4;
        PrimitiveType primitiveType5 = this.typeUtils.unboxedType(this.integerBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveType5, (String)"unboxedType(...)");
        this.intPrimitiveType = primitiveType5;
        PrimitiveType primitiveType6 = this.typeUtils.unboxedType(this.longBoxType);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveType6, (String)"unboxedType(...)");
        this.longPrimitiveType = primitiveType6;
        this.allMethodsCache = new WeakHashMap();
    }

    @NotNull
    public final TypeMirror getBlobHandleType() {
        return this.blobHandleType;
    }

    @NotNull
    public final TypeMirror getCollectionType() {
        return this.collectionType;
    }

    @NotNull
    public final TypeMirror getEmbeddingType() {
        return this.embeddingType;
    }

    @NotNull
    public final TypeMirror getGenericDocumentType() {
        return this.genericDocumentType;
    }

    @NotNull
    public final TypeMirror getListType() {
        return this.listType;
    }

    @NotNull
    public final TypeMirror getBooleanBoxType() {
        return this.booleanBoxType;
    }

    @NotNull
    public final TypeMirror getByteBoxType() {
        return this.byteBoxType;
    }

    @NotNull
    public final TypeMirror getByteBoxArrayType() {
        return this.byteBoxArrayType;
    }

    @NotNull
    public final TypeMirror getDoubleBoxType() {
        return this.doubleBoxType;
    }

    @NotNull
    public final TypeMirror getFloatBoxType() {
        return this.floatBoxType;
    }

    @NotNull
    public final TypeMirror getIntegerBoxType() {
        return this.integerBoxType;
    }

    @NotNull
    public final TypeMirror getLongBoxType() {
        return this.longBoxType;
    }

    @NotNull
    public final TypeMirror getBytePrimitiveType() {
        return this.bytePrimitiveType;
    }

    @NotNull
    public final TypeMirror getFloatPrimitiveType() {
        return this.floatPrimitiveType;
    }

    @Nullable
    public final DocumentPropertyAnnotation getDocumentPropertyAnnotation(@NotNull TypeElement clazz, @NotNull String propertyName) throws ProcessingException {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        for (Element element : clazz.getEnclosedElements()) {
            Intrinsics.checkNotNull((Object)element);
            AnnotatedGetterOrField getterOrField = AnnotatedGetterOrField.Companion.tryCreateFor(element, this.env);
            if (getterOrField == null || getterOrField.getAnnotation().getPropertyKind() != PropertyAnnotation.Kind.DATA_PROPERTY) continue;
            PropertyAnnotation propertyAnnotation = getterOrField.getAnnotation();
            Intrinsics.checkNotNull((Object)propertyAnnotation, (String)"null cannot be cast to non-null type androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation");
            if (((DataPropertyAnnotation)propertyAnnotation).getDataPropertyKind() != DataPropertyAnnotation.Kind.DOCUMENT_PROPERTY) continue;
            PropertyAnnotation propertyAnnotation2 = getterOrField.getAnnotation();
            Intrinsics.checkNotNull((Object)propertyAnnotation2, (String)"null cannot be cast to non-null type androidx.appsearch.compiler.annotationwrapper.DocumentPropertyAnnotation");
            DocumentPropertyAnnotation documentPropertyAnnotation = (DocumentPropertyAnnotation)propertyAnnotation2;
            if (!Intrinsics.areEqual((Object)documentPropertyAnnotation.getName(), (Object)propertyName)) continue;
            return documentPropertyAnnotation;
        }
        return null;
    }

    public final boolean isFieldOfExactType(@NotNull Element property, TypeMirror ... validTypes) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)validTypes, (String)"validTypes");
        TypeMirror propertyType = Companion.getPropertyType(property);
        for (TypeMirror validType : validTypes) {
            if (propertyType.getKind() == TypeKind.ARRAY) {
                Intrinsics.checkNotNull((Object)propertyType, (String)"null cannot be cast to non-null type javax.lang.model.type.ArrayType");
                if (!this.typeUtils.isSameType(((ArrayType)propertyType).getComponentType(), validType)) continue;
                return true;
            }
            if (this.typeUtils.isAssignable(this.typeUtils.erasure(propertyType), this.collectionType)) {
                Intrinsics.checkNotNull((Object)propertyType, (String)"null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
                List<? extends TypeMirror> list = ((DeclaredType)propertyType).getTypeArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeArguments(...)");
                if (!this.typeUtils.isSameType((TypeMirror)CollectionsKt.first(list), validType)) continue;
                return true;
            }
            if (!this.typeUtils.isSameType(propertyType, validType)) continue;
            return true;
        }
        return false;
    }

    public final boolean isFieldOfBooleanType(@NotNull Element property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        TypeMirror[] typeMirrorArray = new TypeMirror[]{this.booleanBoxType, this.booleanPrimitiveType};
        return this.isFieldOfExactType(property, typeMirrorArray);
    }

    @NotNull
    public final Map<String, Object> getAnnotationParams(@NotNull AnnotationMirror annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Map<? extends ExecutableElement, ? extends AnnotationValue> values = this.env.getElementUtils().getElementValuesWithDefaults(annotation);
        Map ret = new LinkedHashMap();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : values.entrySet()) {
            String key = entry.getKey().getSimpleName().toString();
            ret.put(key, entry.getValue().getValue());
        }
        return ret;
    }

    @NotNull
    public final LinkedHashSet<ExecutableElement> getAllMethods(@NotNull TypeElement clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        LinkedHashSet linkedHashSet = this.allMethodsCache.computeIfAbsent(clazz, arg_0 -> IntrospectionHelper.getAllMethods$lambda$4(arg_0 -> IntrospectionHelper.getAllMethods$lambda$3(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"computeIfAbsent(...)");
        return linkedHashSet;
    }

    public final boolean isPrimitiveLongArray(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.isArrayOf(type, this.longPrimitiveType);
    }

    public final boolean isPrimitiveDoubleArray(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.isArrayOf(type, this.doublePrimitiveType);
    }

    public final boolean isPrimitiveBooleanArray(@NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.isArrayOf(type, this.booleanPrimitiveType);
    }

    private final boolean isArrayOf(TypeMirror type, TypeMirror arrayComponentType) {
        return this.typeUtils.isSameType(type, this.typeUtils.getArrayType(arrayComponentType));
    }

    @NotNull
    public final List<ProcessingException> validateIsGetterThatReturns(@NotNull ExecutableElement method, @NotNull TypeMirror expectedReturnType) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)expectedReturnType, (String)"expectedReturnType");
        List<ProcessingException> errors = Companion.validateIsGetter(method);
        if (!this.typeUtils.isAssignable(method.getReturnType(), expectedReturnType)) {
            errors.add(new ProcessingException("Getter cannot be used: Does not return " + expectedReturnType, method));
        }
        return errors;
    }

    @NotNull
    public final Stream<MethodTypeAndElement> getAllMethods(@NotNull DeclaredType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Element element = type.asElement();
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type javax.lang.model.element.TypeElement");
        Stream<MethodTypeAndElement> stream = this.elementUtils.getAllMembers((TypeElement)element).stream().filter(arg_0 -> IntrospectionHelper.getAllMethods$lambda$5(getAllMethods.2.INSTANCE, arg_0)).map(arg_0 -> IntrospectionHelper.getAllMethods$lambda$6(new Function1(this, type){
            final /* synthetic */ IntrospectionHelper this$0;
            final /* synthetic */ DeclaredType $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
            }

            public final MethodTypeAndElement invoke(Element it) {
                TypeMirror typeMirror = IntrospectionHelper.access$getTypeUtils$p(this.this$0).asMemberOf(this.$type, it);
                Intrinsics.checkNotNull((Object)typeMirror, (String)"null cannot be cast to non-null type javax.lang.model.type.ExecutableType");
                ExecutableType executableType = (ExecutableType)typeMirror;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
                return new MethodTypeAndElement(executableType, (ExecutableElement)it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"map(...)");
        return stream;
    }

    public final boolean isReturnTypeMatching(@NotNull ExecutableType method, @NotNull TypeMirror type) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.typeUtils.isAssignable(method.getReturnType(), type);
    }

    @Nullable
    public final TypeMirror getNarrowingCastType(@NotNull TypeMirror sourceType, @NotNull TypeMirror targetType) {
        Intrinsics.checkNotNullParameter((Object)sourceType, (String)"sourceType");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if ((this.typeUtils.isSameType(targetType, this.intPrimitiveType) || this.typeUtils.isSameType(targetType, this.integerBoxType)) && (this.typeUtils.isSameType(sourceType, this.longPrimitiveType) || this.typeUtils.isSameType(sourceType, this.longBoxType))) {
            return this.intPrimitiveType;
        }
        if ((this.typeUtils.isSameType(targetType, this.floatPrimitiveType) || this.typeUtils.isSameType(targetType, this.floatBoxType)) && (this.typeUtils.isSameType(sourceType, this.doublePrimitiveType) || this.typeUtils.isSameType(sourceType, this.doubleBoxType))) {
            return this.floatPrimitiveType;
        }
        return null;
    }

    public final boolean isStaticFactoryMethod(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        ExecutableElement method = (ExecutableElement)element;
        TypeMirror enclosingType = method.getEnclosingElement().asType();
        return this.typeUtils.isSameType(method.getReturnType(), enclosingType);
    }

    private static final boolean getAllMethods$lambda$3$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final ExecutableElement getAllMethods$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        return (ExecutableElement)$tmp0.invoke(p0);
    }

    private static final LinkedHashSet getAllMethods$lambda$3$lambda$2() {
        return new LinkedHashSet();
    }

    private static final LinkedHashSet getAllMethods$lambda$3(IntrospectionHelper this$0, TypeElement type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this$0.env.getElementUtils().getAllMembers(type).stream().filter(arg_0 -> IntrospectionHelper.getAllMethods$lambda$3$lambda$0(getAllMethods.1.1.INSTANCE, arg_0)).map(arg_0 -> IntrospectionHelper.getAllMethods$lambda$3$lambda$1(getAllMethods.1.2.INSTANCE, arg_0)).collect(Collectors.toCollection(IntrospectionHelper::getAllMethods$lambda$3$lambda$2));
    }

    private static final LinkedHashSet getAllMethods$lambda$4(Function1 $tmp0, Object p0) {
        return (LinkedHashSet)$tmp0.invoke(p0);
    }

    private static final boolean getAllMethods$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final MethodTypeAndElement getAllMethods$lambda$6(Function1 $tmp0, Object p0) {
        return (MethodTypeAndElement)$tmp0.invoke(p0);
    }

    @JvmStatic
    @Nullable
    public static final AnnotationMirror getDocumentAnnotation(@NotNull Element element) {
        return Companion.getDocumentAnnotation(element);
    }

    @JvmStatic
    @NotNull
    public static final ClassName getDocumentClassFactoryForClass(@NotNull String pkg, @NotNull String className) {
        return Companion.getDocumentClassFactoryForClass(pkg, className);
    }

    @JvmStatic
    @NotNull
    public static final ClassName getDocumentClassFactoryForClass(@NotNull ClassName clazz) {
        return Companion.getDocumentClassFactoryForClass(clazz);
    }

    @JvmStatic
    @NotNull
    public static final List<TypeElement> generateClassHierarchy(@NotNull TypeElement element) throws ProcessingException {
        return Companion.generateClassHierarchy(element);
    }

    @JvmStatic
    public static final boolean isNonNullKotlinField(@NotNull AnnotatedGetterOrField getterOrField) {
        return Companion.isNonNullKotlinField(getterOrField);
    }

    public static final /* synthetic */ Types access$getTypeUtils$p(IntrospectionHelper $this) {
        return $this.typeUtils;
    }

    static {
        ClassName className = ClassName.get((String)APPSEARCH_PKG, (String)"AppSearchSchema", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
        APPSEARCH_SCHEMA_CLASS = className;
        ClassName className2 = APPSEARCH_SCHEMA_CLASS.nestedClass("PropertyConfig");
        Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"nestedClass(...)");
        PROPERTY_CONFIG_CLASS = className2;
        ClassName className3 = ClassName.get((String)APPSEARCH_EXCEPTION_PKG, (String)"AppSearchException", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className3, (String)"get(...)");
        APPSEARCH_EXCEPTION_CLASS = className3;
        ClassName className4 = ClassName.get((String)APPSEARCH_ANNOTATION_PKG, (String)DOCUMENT_ANNOTATION_SIMPLE_CLASS_NAME, (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className4, (String)"get(...)");
        DOCUMENT_ANNOTATION_CLASS = className4;
        ClassName className5 = ClassName.get((String)APPSEARCH_PKG, (String)"GenericDocument", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className5, (String)"get(...)");
        GENERIC_DOCUMENT_CLASS = className5;
        ClassName className6 = ClassName.get((String)APPSEARCH_PKG, (String)"EmbeddingVector", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className6, (String)"get(...)");
        EMBEDDING_VECTOR_CLASS = className6;
        ClassName className7 = ClassName.get((String)APPSEARCH_PKG, (String)"AppSearchBlobHandle", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className7, (String)"get(...)");
        APPSEARCH_BLOB_HANDLE_CLASS = className7;
        ClassName className8 = DOCUMENT_ANNOTATION_CLASS.nestedClass("BuilderProducer");
        Intrinsics.checkNotNullExpressionValue((Object)className8, (String)"nestedClass(...)");
        BUILDER_PRODUCER_CLASS = className8;
        ClassName className9 = ClassName.get((String)APPSEARCH_PKG, (String)"DocumentClassFactory", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className9, (String)"get(...)");
        DOCUMENT_CLASS_FACTORY_CLASS = className9;
        ClassName className10 = ClassName.get((String)"androidx.annotation", (String)"RestrictTo", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className10, (String)"get(...)");
        RESTRICT_TO_ANNOTATION_CLASS = className10;
        ClassName className11 = RESTRICT_TO_ANNOTATION_CLASS.nestedClass("Scope");
        Intrinsics.checkNotNullExpressionValue((Object)className11, (String)"nestedClass(...)");
        RESTRICT_TO_SCOPE_CLASS = className11;
        ClassName className12 = ClassName.get((String)APPSEARCH_PKG, (String)"DocumentClassMappingContext", (String[])new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)className12, (String)"get(...)");
        DOCUMENT_CLASS_MAPPING_CONTEXT_CLASS = className12;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0 2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001eJ\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0007J\u0010\u0010%\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bH\u0007J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0 2\u0006\u0010\u001d\u001a\u00020)H\u0007J\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.J4\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020)2\f\u00103\u001a\b\u0012\u0004\u0012\u00020)042\f\u00105\u001a\b\u0012\u0004\u0012\u00020)06H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0010\u0010\u0017\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Landroidx/appsearch/compiler/IntrospectionHelper$Companion;", "", "<init>", "()V", "GEN_CLASS_PREFIX", "", "APPSEARCH_PKG", "APPSEARCH_SCHEMA_CLASS", "Lcom/squareup/javapoet/ClassName;", "PROPERTY_CONFIG_CLASS", "APPSEARCH_EXCEPTION_PKG", "APPSEARCH_EXCEPTION_CLASS", "APPSEARCH_ANNOTATION_PKG", "DOCUMENT_ANNOTATION_SIMPLE_CLASS_NAME", "DOCUMENT_ANNOTATION_CLASS", "GENERIC_DOCUMENT_CLASS", "EMBEDDING_VECTOR_CLASS", "getEMBEDDING_VECTOR_CLASS", "()Lcom/squareup/javapoet/ClassName;", "APPSEARCH_BLOB_HANDLE_CLASS", "getAPPSEARCH_BLOB_HANDLE_CLASS", "BUILDER_PRODUCER_CLASS", "getBUILDER_PRODUCER_CLASS", "DOCUMENT_CLASS_FACTORY_CLASS", "RESTRICT_TO_ANNOTATION_CLASS", "RESTRICT_TO_SCOPE_CLASS", "DOCUMENT_CLASS_MAPPING_CONTEXT_CLASS", "getDocumentAnnotation", "Ljavax/lang/model/element/AnnotationMirror;", "element", "Ljavax/lang/model/element/Element;", "getAnnotations", "", "className", "getPropertyType", "Ljavax/lang/model/type/TypeMirror;", "property", "getDocumentClassFactoryForClass", "pkg", "clazz", "generateClassHierarchy", "Ljavax/lang/model/element/TypeElement;", "validateIsGetter", "", "Landroidx/appsearch/compiler/ProcessingException;", "method", "Ljavax/lang/model/element/ExecutableElement;", "generateClassHierarchyHelper", "", "leafElement", "currentClass", "hierarchy", "Ljava/util/Deque;", "visited", "", "isNonNullKotlinField", "", "getterOrField", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "appsearch-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClassName getEMBEDDING_VECTOR_CLASS() {
            return EMBEDDING_VECTOR_CLASS;
        }

        @NotNull
        public final ClassName getAPPSEARCH_BLOB_HANDLE_CLASS() {
            return APPSEARCH_BLOB_HANDLE_CLASS;
        }

        @NotNull
        public final ClassName getBUILDER_PRODUCER_CLASS() {
            return BUILDER_PRODUCER_CLASS;
        }

        @JvmStatic
        @Nullable
        public final AnnotationMirror getDocumentAnnotation(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            List<AnnotationMirror> annotations2 = this.getAnnotations(element, DOCUMENT_ANNOTATION_CLASS);
            return (AnnotationMirror)CollectionsKt.firstOrNull(annotations2);
        }

        @NotNull
        public final List<AnnotationMirror> getAnnotations(@NotNull Element element, @NotNull ClassName className) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            List<Object> list = element.getAnnotationMirrors().stream().filter(arg_0 -> Companion.getAnnotations$lambda$0(new Function1(className){
                final /* synthetic */ ClassName $className;
                {
                    this.$className = $className;
                }

                public final Boolean invoke(AnnotationMirror it) {
                    return Intrinsics.areEqual((Object)it.getAnnotationType().toString(), (Object)this.$className.canonicalName());
                }
            }, arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            return list;
        }

        @NotNull
        public final TypeMirror getPropertyType(@NotNull Element property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            TypeMirror propertyType = property.asType();
            if (property.getKind() == ElementKind.METHOD) {
                TypeMirror typeMirror = propertyType;
                Intrinsics.checkNotNull((Object)typeMirror, (String)"null cannot be cast to non-null type javax.lang.model.type.ExecutableType");
                propertyType = ((ExecutableType)typeMirror).getReturnType();
            }
            TypeMirror typeMirror = propertyType;
            Intrinsics.checkNotNull((Object)typeMirror);
            return typeMirror;
        }

        @JvmStatic
        @NotNull
        public final ClassName getDocumentClassFactoryForClass(@NotNull String pkg, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            String genClassName = IntrospectionHelper.GEN_CLASS_PREFIX + StringsKt.replace$default((String)className, (String)".", (String)"$$__", (boolean)false, (int)4, null);
            ClassName className2 = ClassName.get((String)pkg, (String)genClassName, (String[])new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)className2, (String)"get(...)");
            return className2;
        }

        @JvmStatic
        @NotNull
        public final ClassName getDocumentClassFactoryForClass(@NotNull ClassName clazz) {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            String string = clazz.canonicalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"canonicalName(...)");
            String string2 = string;
            int n = clazz.packageName().length() + 1;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String className = string3;
            String string4 = clazz.packageName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"packageName(...)");
            return this.getDocumentClassFactoryForClass(string4, className);
        }

        @JvmStatic
        @NotNull
        public final List<TypeElement> generateClassHierarchy(@NotNull TypeElement element) throws ProcessingException {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Deque hierarchy = new ArrayDeque();
            if (element.getAnnotation(AutoValue.class) != null) {
                TypeElement superClass = MoreTypes.asTypeElement((TypeMirror)element.getSuperclass());
                if (!superClass.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                    throw new ProcessingException("A class annotated with AutoValue and Document cannot have a superclass", element);
                }
                hierarchy.add(element);
            } else {
                Set visited = new LinkedHashSet();
                this.generateClassHierarchyHelper(element, element, hierarchy, visited);
            }
            return CollectionsKt.toList((Iterable)hierarchy);
        }

        @NotNull
        public final List<ProcessingException> validateIsGetter(@NotNull ExecutableElement method) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            List errors = new ArrayList();
            List<? extends VariableElement> list = method.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            if (!((Collection)list).isEmpty()) {
                errors.add(new ProcessingException("Getter cannot be used: should take no parameters", method));
            }
            if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
                errors.add(new ProcessingException("Getter cannot be used: private visibility", method));
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                errors.add(new ProcessingException("Getter cannot be used: must not be static", method));
            }
            return errors;
        }

        private final void generateClassHierarchyHelper(TypeElement leafElement, TypeElement currentClass, Deque<TypeElement> hierarchy, Set<TypeElement> visited) throws ProcessingException {
            TypeMirror superclass;
            if (currentClass.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                return;
            }
            if (currentClass.getAnnotation(AutoValue.class) != null) {
                throw new ProcessingException("A class annotated with Document cannot inherit from a class annotated with AutoValue", leafElement);
            }
            if (visited.contains(currentClass)) {
                return;
            }
            visited.add(currentClass);
            if (this.getDocumentAnnotation(currentClass) != null) {
                hierarchy.addFirst(currentClass);
            }
            if ((superclass = currentClass.getSuperclass()).getKind() != TypeKind.NONE) {
                TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)superclass);
                Intrinsics.checkNotNullExpressionValue((Object)typeElement, (String)"asTypeElement(...)");
                this.generateClassHierarchyHelper(leafElement, typeElement, hierarchy, visited);
            }
            for (TypeMirror typeMirror : currentClass.getInterfaces()) {
                TypeElement typeElement = MoreTypes.asTypeElement((TypeMirror)typeMirror);
                Intrinsics.checkNotNullExpressionValue((Object)typeElement, (String)"asTypeElement(...)");
                this.generateClassHierarchyHelper(leafElement, typeElement, hierarchy, visited);
            }
        }

        @JvmStatic
        public final boolean isNonNullKotlinField(@NotNull AnnotatedGetterOrField getterOrField) {
            KotlinClassMetadata kotlinMetadata;
            Intrinsics.checkNotNullParameter((Object)getterOrField, (String)"getterOrField");
            Metadata metadata = getterOrField.getElement().getEnclosingElement().getAnnotation(Metadata.class);
            if (metadata != null && (kotlinMetadata = KotlinClassMetadata.Companion.readStrict(metadata)) instanceof KotlinClassMetadata.Class) {
                KmClass kmClass = ((KotlinClassMetadata.Class)kotlinMetadata).getKmClass();
                List properties = kmClass.getProperties();
                for (KmProperty property : properties) {
                    if (!Intrinsics.areEqual((Object)property.getName(), (Object)getterOrField.getJvmName())) continue;
                    return !Attributes.isNullable((KmType)property.getReturnType());
                }
            }
            return false;
        }

        private static final boolean getAnnotations$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/appsearch/compiler/IntrospectionHelper$MethodTypeAndElement;", "", "type", "Ljavax/lang/model/type/ExecutableType;", "element", "Ljavax/lang/model/element/ExecutableElement;", "<init>", "(Ljavax/lang/model/type/ExecutableType;Ljavax/lang/model/element/ExecutableElement;)V", "getType", "()Ljavax/lang/model/type/ExecutableType;", "getElement", "()Ljavax/lang/model/element/ExecutableElement;", "appsearch-compiler"})
    public static final class MethodTypeAndElement {
        @NotNull
        private final ExecutableType type;
        @NotNull
        private final ExecutableElement element;

        public MethodTypeAndElement(@NotNull ExecutableType type, @NotNull ExecutableElement element) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.type = type;
            this.element = element;
        }

        @NotNull
        public final ExecutableType getType() {
            return this.type;
        }

        @NotNull
        public final ExecutableElement getElement() {
            return this.element;
        }
    }
}

