/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ProcessingException
extends Exception {
    private final @Nullable Element mCulprit;
    private final List<ProcessingException> mWarnings = new ArrayList<ProcessingException>();

    public ProcessingException(@NonNull String message, @Nullable Element culprit) {
        super(message);
        this.mCulprit = culprit;
    }

    public void addWarning(@NonNull ProcessingException warning) {
        this.mWarnings.add(warning);
    }

    public void addWarnings(@NonNull Collection<ProcessingException> warnings) {
        this.mWarnings.addAll(warnings);
    }

    public void printDiagnostic(Messager messager) {
        this.printDiagnostic(messager, Diagnostic.Kind.ERROR);
    }

    private void printDiagnostic(Messager messager, Diagnostic.Kind level) {
        messager.printMessage(level, this.getMessage(), this.mCulprit);
        for (ProcessingException warning : this.mWarnings) {
            warning.printDiagnostic(messager, Diagnostic.Kind.WARNING);
        }
    }
}

