/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/appsearch/compiler/PropertyAccessor;", "", "element", "Ljavax/lang/model/element/Element;", "<init>", "(Ljavax/lang/model/element/Element;)V", "getElement", "()Ljavax/lang/model/element/Element;", "isGetter", "", "()Z", "isField", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "appsearch-compiler"})
public final class PropertyAccessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Element element;

    public PropertyAccessor(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    public final boolean isGetter() {
        return this.element.getKind() == ElementKind.METHOD;
    }

    public final boolean isField() {
        return this.element.getKind() == ElementKind.FIELD;
    }

    @NotNull
    public final Element component1() {
        return this.element;
    }

    @NotNull
    public final PropertyAccessor copy(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new PropertyAccessor(element);
    }

    public static /* synthetic */ PropertyAccessor copy$default(PropertyAccessor propertyAccessor, Element element, int n, Object object) {
        if ((n & 1) != 0) {
            element = propertyAccessor.element;
        }
        return propertyAccessor.copy(element);
    }

    @NotNull
    public String toString() {
        return "PropertyAccessor(element=" + this.element + ")";
    }

    public int hashCode() {
        return ((Object)this.element).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyAccessor)) {
            return false;
        }
        PropertyAccessor propertyAccessor = (PropertyAccessor)other;
        return Intrinsics.areEqual((Object)this.element, (Object)propertyAccessor.element);
    }

    @JvmStatic
    @NotNull
    public static final PropertyAccessor infer(@NotNull AnnotatedGetterOrField getterOrField, @NotNull Collection<? extends ExecutableElement> neighboringMethods, @NotNull IntrospectionHelper helper) throws ProcessingException {
        return Companion.infer(getterOrField, neighboringMethods, helper);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J&\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0012"}, d2={"Landroidx/appsearch/compiler/PropertyAccessor$Companion;", "", "<init>", "()V", "infer", "Landroidx/appsearch/compiler/PropertyAccessor;", "getterOrField", "Landroidx/appsearch/compiler/AnnotatedGetterOrField;", "neighboringMethods", "", "Ljavax/lang/model/element/ExecutableElement;", "helper", "Landroidx/appsearch/compiler/IntrospectionHelper;", "findCorrespondingGetter", "privateField", "getAcceptableGetterNames", "", "", "appsearch-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final PropertyAccessor infer(@NotNull AnnotatedGetterOrField getterOrField, @NotNull Collection<? extends ExecutableElement> neighboringMethods, @NotNull IntrospectionHelper helper) throws ProcessingException {
            Intrinsics.checkNotNullParameter((Object)getterOrField, (String)"getterOrField");
            Intrinsics.checkNotNullParameter(neighboringMethods, (String)"neighboringMethods");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            if (!getterOrField.getElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
                return new PropertyAccessor(getterOrField.getElement());
            }
            if (getterOrField.isGetter()) {
                throw new ProcessingException("Annotated getter must not be private", getterOrField.getElement());
            }
            return new PropertyAccessor(this.findCorrespondingGetter(getterOrField, neighboringMethods, helper));
        }

        private final ExecutableElement findCorrespondingGetter(AnnotatedGetterOrField privateField, Collection<? extends ExecutableElement> neighboringMethods, IntrospectionHelper helper) throws ProcessingException {
            Set<String> getterNames = this.getAcceptableGetterNames(privateField, helper);
            List<Object> list = neighboringMethods.stream().filter(arg_0 -> Companion.findCorrespondingGetter$lambda$1(arg_0 -> Companion.findCorrespondingGetter$lambda$0(getterNames, arg_0), arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            List<Object> potentialGetters = list;
            String potentialSignatures = getterNames.stream().map(arg_0 -> Companion.findCorrespondingGetter$lambda$3(arg_0 -> Companion.findCorrespondingGetter$lambda$2(privateField, arg_0), arg_0)).collect(Collectors.joining(" OR "));
            ProcessingException processingException = new ProcessingException("Field '" + privateField.getJvmName() + "' cannot be read: it is private and has no suitable getters " + potentialSignatures, privateField.getElement());
            for (ExecutableElement executableElement : potentialGetters) {
                List<ProcessingException> errors = helper.validateIsGetterThatReturns(executableElement, privateField.getJvmType());
                if (!((Collection)errors).isEmpty()) {
                    processingException.addWarnings((Collection<ProcessingException>)errors);
                    continue;
                }
                return executableElement;
            }
            throw processingException;
        }

        private final Set<String> getAcceptableGetterNames(AnnotatedGetterOrField privateField, IntrospectionHelper helper) {
            String normalizedName = privateField.getNormalizedName();
            Object[] objectArray = new String[]{normalizedName};
            Set getterNames = SetsKt.mutableSetOf((Object[])objectArray);
            String string = normalizedName.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            String string4 = normalizedName.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String upperCamelCase = string3 + string4;
            getterNames.add("get" + upperCamelCase);
            TypeMirror[] typeMirrorArray = new TypeMirror[]{helper.booleanPrimitiveType, helper.getBooleanBoxType()};
            boolean isBooleanField = helper.isFieldOfExactType(privateField.getElement(), typeMirrorArray);
            if (isBooleanField && privateField.getElementTypeCategory() == AnnotatedGetterOrField.ElementTypeCategory.SINGLE) {
                getterNames.add("is" + upperCamelCase);
            }
            return getterNames;
        }

        private static final boolean findCorrespondingGetter$lambda$0(Set $getterNames, ExecutableElement it) {
            return $getterNames.contains(it.getSimpleName().toString());
        }

        private static final boolean findCorrespondingGetter$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final String findCorrespondingGetter$lambda$2(AnnotatedGetterOrField $privateField, String it) {
            return "[public] " + $privateField.getJvmType() + " " + it + "()";
        }

        private static final String findCorrespondingGetter$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

