/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.DocumentModel;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.DocumentPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.EmbeddingPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.LongPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.StringPropertyAnnotation;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.NonNull;

class SchemaCodeGenerator {
    private final DocumentModel mModel;
    private final IntrospectionHelper mHelper;
    private final LinkedHashSet<TypeElement> mDependencyDocumentClasses;

    public static void generate(@NonNull ProcessingEnvironment env, @NonNull DocumentModel model, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TypeSpec.Builder classBuilder) throws ProcessingException {
        new SchemaCodeGenerator(model, env).generate(classBuilder);
    }

    private SchemaCodeGenerator(@NonNull DocumentModel model, @NonNull ProcessingEnvironment env) {
        this.mModel = model;
        this.mHelper = new IntrospectionHelper(env);
        this.mDependencyDocumentClasses = SchemaCodeGenerator.computeDependencyClasses(model, env);
    }

    private static @NonNull LinkedHashSet<TypeElement> computeDependencyClasses(@NonNull DocumentModel model, @NonNull ProcessingEnvironment env) {
        LinkedHashSet<TypeElement> dependencies = new LinkedHashSet<TypeElement>(model.getParentTypes());
        for (AnnotatedGetterOrField getterOrField : model.getAnnotatedGettersAndFields()) {
            if (!(getterOrField.getAnnotation() instanceof DocumentPropertyAnnotation)) continue;
            TypeMirror documentClass = getterOrField.getComponentType();
            dependencies.add((TypeElement)env.getTypeUtils().asElement(documentClass));
        }
        return dependencies;
    }

    private void generate(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TypeSpec.Builder classBuilder) throws ProcessingException {
        classBuilder.addField(FieldSpec.builder(String.class, (String)"SCHEMA_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.mModel.getSchemaName()}).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"getSchemaName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addAnnotation(Override.class).addStatement("return SCHEMA_NAME", new Object[0]).build());
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"getSchema").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)IntrospectionHelper.APPSEARCH_SCHEMA_CLASS).addAnnotation(Override.class).addException((TypeName)IntrospectionHelper.APPSEARCH_EXCEPTION_CLASS).addStatement("return $L", new Object[]{this.createSchemaInitializerGetDocumentTypes()}).build());
        classBuilder.addMethod(this.createDependencyClassesMethod());
    }

    private @NonNull MethodSpec createDependencyClassesMethod() {
        ParameterizedTypeName listOfClasses = ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
        ParameterizedTypeName arrayListOfClasses = ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"ArrayList", (String[])new String[0]), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})});
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getDependencyDocumentClasses").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)listOfClasses).addAnnotation(Override.class).addException((TypeName)IntrospectionHelper.APPSEARCH_EXCEPTION_CLASS);
        if (this.mDependencyDocumentClasses.isEmpty()) {
            methodBuilder.addStatement("return $T.emptyList()", new Object[]{ClassName.get(Collections.class)});
        } else {
            methodBuilder.addStatement("$T classSet = new $T()", new Object[]{listOfClasses, arrayListOfClasses});
            for (TypeElement dependencyType : this.mDependencyDocumentClasses) {
                methodBuilder.addStatement("classSet.add($T.class)", new Object[]{ClassName.get((TypeElement)dependencyType)});
            }
            methodBuilder.addStatement("return classSet", new Object[0]).build();
        }
        return methodBuilder.build();
    }

    private CodeBlock createSchemaInitializerGetDocumentTypes() throws ProcessingException {
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("new $T(SCHEMA_NAME)", new Object[]{IntrospectionHelper.APPSEARCH_SCHEMA_CLASS.nestedClass("Builder")}).indent();
        for (TypeElement parentType : this.mModel.getParentTypes()) {
            ClassName parentDocumentFactoryClass = IntrospectionHelper.getDocumentClassFactoryForClass(ClassName.get((TypeElement)parentType));
            codeBlock.add("\n.addParentType($T.SCHEMA_NAME)", new Object[]{parentDocumentFactoryClass});
        }
        for (AnnotatedGetterOrField getterOrField : this.mModel.getAnnotatedGettersAndFields()) {
            if (!(getterOrField.getAnnotation() instanceof DataPropertyAnnotation)) continue;
            CodeBlock propertyConfigExpr = this.createPropertyConfig((DataPropertyAnnotation)getterOrField.getAnnotation(), getterOrField);
            codeBlock.add("\n.addProperty($L)", new Object[]{propertyConfigExpr});
        }
        codeBlock.add("\n.build()", new Object[0]).unindent();
        return codeBlock.build();
    }

    private CodeBlock createPropertyConfig(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        if (annotation.getDataPropertyKind() == DataPropertyAnnotation.Kind.DOCUMENT_PROPERTY) {
            ClassName documentClass = (ClassName)ClassName.get((TypeMirror)getterOrField.getComponentType());
            ClassName documentFactoryClass = IntrospectionHelper.getDocumentClassFactoryForClass(documentClass);
            codeBlock.add("new $T.Builder($S, $T.SCHEMA_NAME)", new Object[]{DocumentPropertyAnnotation.CONFIG_CLASS, annotation.getName(), documentFactoryClass});
        } else {
            codeBlock.add("new $T.Builder($S)", new Object[]{annotation.getConfigClassName(), annotation.getName()});
        }
        codeBlock.indent().add(SchemaCodeGenerator.createSetCardinalityExpr(annotation, getterOrField));
        switch (annotation.getDataPropertyKind()) {
            case STRING_PROPERTY: {
                StringPropertyAnnotation stringPropertyAnnotation = (StringPropertyAnnotation)annotation;
                codeBlock.add(SchemaCodeGenerator.createSetTokenizerTypeExpr(stringPropertyAnnotation, getterOrField)).add(SchemaCodeGenerator.createSetIndexingTypeExpr(stringPropertyAnnotation, getterOrField)).add(SchemaCodeGenerator.createSetJoinableValueTypeExpr(stringPropertyAnnotation, getterOrField));
                break;
            }
            case DOCUMENT_PROPERTY: {
                DocumentPropertyAnnotation documentPropertyAnnotation = (DocumentPropertyAnnotation)annotation;
                codeBlock.add(SchemaCodeGenerator.createSetShouldIndexNestedPropertiesExpr(documentPropertyAnnotation));
                Set<String> indexableNestedProperties = this.getAllIndexableNestedProperties(documentPropertyAnnotation);
                for (String propertyPath : indexableNestedProperties) {
                    codeBlock.add(CodeBlock.of((String)"\n.addIndexableNestedProperties($L)", (Object[])new Object[]{propertyPath}));
                }
                break;
            }
            case LONG_PROPERTY: {
                LongPropertyAnnotation longPropertyAnnotation = (LongPropertyAnnotation)annotation;
                codeBlock.add(SchemaCodeGenerator.createSetIndexingTypeExpr(longPropertyAnnotation, getterOrField));
                break;
            }
            case EMBEDDING_PROPERTY: {
                EmbeddingPropertyAnnotation embeddingPropertyAnnotation = (EmbeddingPropertyAnnotation)annotation;
                codeBlock.add(SchemaCodeGenerator.createSetIndexingTypeExpr(embeddingPropertyAnnotation, getterOrField)).add(SchemaCodeGenerator.createSetQuantizationTypeExpr(embeddingPropertyAnnotation, getterOrField));
                break;
            }
            case DOUBLE_PROPERTY: 
            case BOOLEAN_PROPERTY: 
            case BYTES_PROPERTY: 
            case BLOB_HANDLE_PROPERTY: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled annotation: " + String.valueOf(annotation));
            }
        }
        return codeBlock.add("\n.build()", new Object[0]).unindent().build();
    }

    private Set<String> getAllIndexableNestedProperties(@NonNull DocumentPropertyAnnotation documentPropertyAnnotation) throws ProcessingException {
        HashSet<String> indexableNestedProperties = new HashSet<String>(documentPropertyAnnotation.getIndexableNestedPropertiesList());
        if (documentPropertyAnnotation.getShouldInheritIndexableNestedPropertiesFromSuperClass()) {
            ArrayDeque<TypeElement> classesToExpand = new ArrayDeque<TypeElement>();
            HashSet<TypeElement> visited = new HashSet<TypeElement>();
            classesToExpand.add(this.mModel.getClassElement());
            while (!classesToExpand.isEmpty()) {
                TypeElement currentClass = (TypeElement)classesToExpand.poll();
                if (visited.contains(currentClass)) continue;
                visited.add(currentClass);
                ArrayList<? extends TypeMirror> parentTypes = new ArrayList<TypeMirror>();
                parentTypes.add(currentClass.getSuperclass());
                parentTypes.addAll(currentClass.getInterfaces());
                for (TypeMirror typeMirror : parentTypes) {
                    if (!typeMirror.getKind().equals((Object)TypeKind.DECLARED)) continue;
                    TypeElement parentElement = MoreTypes.asTypeElement((TypeMirror)typeMirror);
                    DocumentPropertyAnnotation annotation = this.mHelper.getDocumentPropertyAnnotation(parentElement, documentPropertyAnnotation.getName());
                    if (annotation == null) {
                        classesToExpand.add(parentElement);
                        continue;
                    }
                    indexableNestedProperties.addAll(annotation.getIndexableNestedPropertiesList());
                    if (!annotation.getShouldInheritIndexableNestedPropertiesFromSuperClass()) continue;
                    classesToExpand.add(parentElement);
                }
            }
        }
        return indexableNestedProperties;
    }

    private static @NonNull CodeBlock createSetCardinalityExpr(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        AnnotatedGetterOrField.ElementTypeCategory typeCategory = getterOrField.getElementTypeCategory();
        return CodeBlock.of((String)"\n.setCardinality($T.$N)", (Object[])new Object[]{IntrospectionHelper.PROPERTY_CONFIG_CLASS, switch (typeCategory) {
            case AnnotatedGetterOrField.ElementTypeCategory.COLLECTION, AnnotatedGetterOrField.ElementTypeCategory.ARRAY -> "CARDINALITY_REPEATED";
            case AnnotatedGetterOrField.ElementTypeCategory.SINGLE -> annotation.isRequired() ? "CARDINALITY_REQUIRED" : "CARDINALITY_OPTIONAL";
            default -> throw new IllegalStateException("Unhandled type category: " + String.valueOf((Object)typeCategory));
        }});
    }

    private static @NonNull CodeBlock createSetTokenizerTypeExpr(@NonNull StringPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        String enumName;
        if (annotation.getIndexingType() == 0) {
            enumName = "TOKENIZER_TYPE_NONE";
        } else {
            switch (annotation.getTokenizerType()) {
                case 0: {
                    enumName = "TOKENIZER_TYPE_NONE";
                    break;
                }
                case 1: {
                    enumName = "TOKENIZER_TYPE_PLAIN";
                    break;
                }
                case 2: {
                    enumName = "TOKENIZER_TYPE_VERBATIM";
                    break;
                }
                case 3: {
                    enumName = "TOKENIZER_TYPE_RFC822";
                    break;
                }
                default: {
                    throw new ProcessingException("Unknown tokenizer type " + annotation.getTokenizerType(), getterOrField.getElement());
                }
            }
        }
        return CodeBlock.of((String)"\n.setTokenizerType($T.$N)", (Object[])new Object[]{StringPropertyAnnotation.CONFIG_CLASS, enumName});
    }

    private static @NonNull CodeBlock createSetIndexingTypeExpr(@NonNull StringPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        return CodeBlock.of((String)"\n.setIndexingType($T.$N)", (Object[])new Object[]{StringPropertyAnnotation.CONFIG_CLASS, switch (annotation.getIndexingType()) {
            case 0 -> "INDEXING_TYPE_NONE";
            case 1 -> "INDEXING_TYPE_EXACT_TERMS";
            case 2 -> "INDEXING_TYPE_PREFIXES";
            default -> throw new ProcessingException("Unknown indexing type " + annotation.getIndexingType(), getterOrField.getElement());
        }});
    }

    private static @NonNull CodeBlock createSetShouldIndexNestedPropertiesExpr(@NonNull DocumentPropertyAnnotation annotation) {
        return CodeBlock.of((String)"\n.setShouldIndexNestedProperties($L)", (Object[])new Object[]{annotation.getShouldIndexNestedProperties()});
    }

    private static @NonNull CodeBlock createSetIndexingTypeExpr(@NonNull LongPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        return CodeBlock.of((String)"\n.setIndexingType($T.$N)", (Object[])new Object[]{LongPropertyAnnotation.CONFIG_CLASS, switch (annotation.getIndexingType()) {
            case 0 -> "INDEXING_TYPE_NONE";
            case 1 -> "INDEXING_TYPE_RANGE";
            default -> throw new ProcessingException("Unknown indexing type " + annotation.getIndexingType(), getterOrField.getElement());
        }});
    }

    private static @NonNull CodeBlock createSetIndexingTypeExpr(@NonNull EmbeddingPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        return CodeBlock.of((String)"\n.setIndexingType($T.$N)", (Object[])new Object[]{EmbeddingPropertyAnnotation.CONFIG_CLASS, switch (annotation.getIndexingType()) {
            case 0 -> "INDEXING_TYPE_NONE";
            case 1 -> "INDEXING_TYPE_SIMILARITY";
            default -> throw new ProcessingException("Unknown indexing type " + annotation.getIndexingType(), getterOrField.getElement());
        }});
    }

    private static @NonNull CodeBlock createSetQuantizationTypeExpr(@NonNull EmbeddingPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        return CodeBlock.of((String)"\n.setQuantizationType($T.$N)", (Object[])new Object[]{EmbeddingPropertyAnnotation.CONFIG_CLASS, switch (annotation.getQuantizationType()) {
            case 0 -> "QUANTIZATION_TYPE_NONE";
            case 1 -> "QUANTIZATION_TYPE_8_BIT";
            default -> throw new ProcessingException("Unknown quantization type " + annotation.getQuantizationType(), getterOrField.getElement());
        }});
    }

    private static @NonNull CodeBlock createSetJoinableValueTypeExpr(@NonNull StringPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) throws ProcessingException {
        AnnotatedGetterOrField.ElementTypeCategory typeCategory = getterOrField.getElementTypeCategory();
        return CodeBlock.of((String)"\n.setJoinableValueType($T.$N)", (Object[])new Object[]{StringPropertyAnnotation.CONFIG_CLASS, switch (annotation.getJoinableValueType()) {
            case 0 -> "JOINABLE_VALUE_TYPE_NONE";
            case 1 -> {
                switch (typeCategory) {
                    case COLLECTION: 
                    case ARRAY: {
                        throw new ProcessingException("Joinable value type 1 not allowed on repeated properties.", getterOrField.getElement());
                    }
                    case SINGLE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled cardinality: " + String.valueOf((Object)typeCategory));
                    }
                }
                yield "JOINABLE_VALUE_TYPE_QUALIFIED_ID";
            }
            default -> throw new ProcessingException("Unknown joinable value type " + annotation.getJoinableValueType(), getterOrField.getElement());
        }});
    }
}

