/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler;

import androidx.appsearch.compiler.AnnotatedGetterOrField;
import androidx.appsearch.compiler.CodegenUtils;
import androidx.appsearch.compiler.DocumentModel;
import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.PropertyAccessor;
import androidx.appsearch.compiler.annotationwrapper.DataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.DocumentPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.LongPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.MetadataPropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.PropertyAnnotation;
import androidx.appsearch.compiler.annotationwrapper.SerializerClass;
import androidx.appsearch.compiler.annotationwrapper.StringPropertyAnnotation;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.NonNull;

class ToGenericDocumentCodeGenerator {
    private final ProcessingEnvironment mEnv;
    private final IntrospectionHelper mHelper;
    private final DocumentModel mModel;

    private ToGenericDocumentCodeGenerator(@NonNull ProcessingEnvironment env, @NonNull DocumentModel model) {
        this.mEnv = env;
        this.mHelper = new IntrospectionHelper(env);
        this.mModel = model;
    }

    public static void generate(@NonNull ProcessingEnvironment env, @NonNull DocumentModel model, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull TypeSpec.Builder classBuilder) {
        new ToGenericDocumentCodeGenerator(env, model).generate(classBuilder);
    }

    private void generate(TypeSpec.Builder classBuilder) {
        classBuilder.addMethod(this.createToGenericDocumentMethod());
    }

    private MethodSpec createToGenericDocumentMethod() {
        PropertyAnnotation annotation;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"toGenericDocument").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)IntrospectionHelper.GENERIC_DOCUMENT_CLASS).addAnnotation(Override.class).addParameter((TypeName)ClassName.get((TypeElement)this.mModel.getClassElement()), "document", new Modifier[0]).addException((TypeName)IntrospectionHelper.APPSEARCH_EXCEPTION_CLASS);
        methodBuilder.addStatement("$T builder =\nnew $T<>($L, $L, SCHEMA_NAME)", new Object[]{ParameterizedTypeName.get((ClassName)IntrospectionHelper.GENERIC_DOCUMENT_CLASS.nestedClass("Builder"), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}), IntrospectionHelper.GENERIC_DOCUMENT_CLASS.nestedClass("Builder"), this.createReadExpr(this.mModel.getNamespaceAnnotatedGetterOrField()), this.createReadExpr(this.mModel.getIdAnnotatedGetterOrField())});
        for (AnnotatedGetterOrField getterOrField : this.mModel.getAnnotatedGettersAndFields()) {
            annotation = getterOrField.getAnnotation();
            if (annotation.getPropertyKind() != PropertyAnnotation.Kind.METADATA_PROPERTY || annotation == MetadataPropertyAnnotation.ID || annotation == MetadataPropertyAnnotation.NAMESPACE) continue;
            methodBuilder.addCode(this.codeToCopyIntoGenericDoc((MetadataPropertyAnnotation)annotation, getterOrField));
        }
        for (AnnotatedGetterOrField getterOrField : this.mModel.getAnnotatedGettersAndFields()) {
            annotation = getterOrField.getAnnotation();
            if (annotation.getPropertyKind() != PropertyAnnotation.Kind.DATA_PROPERTY) continue;
            methodBuilder.addCode(this.codeToCopyIntoGenericDoc((DataPropertyAnnotation)annotation, getterOrField));
        }
        methodBuilder.addStatement("return builder.build()", new Object[0]);
        return methodBuilder.build();
    }

    private CodeBlock codeToCopyIntoGenericDoc(@NonNull MetadataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        if (getterOrField.getJvmType() instanceof PrimitiveType) {
            return CodeBlock.builder().addStatement("builder.$N($L)", new Object[]{annotation.getGenericDocSetterName(), this.createReadExpr(getterOrField)}).build();
        }
        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
    }

    private CodeBlock codeToCopyIntoGenericDoc(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        AnnotatedGetterOrField.ElementTypeCategory typeCategory = getterOrField.getElementTypeCategory();
        switch (annotation.getDataPropertyKind()) {
            case STRING_PROPERTY: {
                SerializerClass stringSerializer = ((StringPropertyAnnotation)annotation).getCustomSerializer();
                switch (typeCategory) {
                    case COLLECTION: {
                        if (stringSerializer != null) {
                            return this.collectionForLoopCallSerialize(annotation, getterOrField, stringSerializer);
                        }
                        return this.collectionCallToArray(annotation, getterOrField);
                    }
                    case ARRAY: {
                        if (stringSerializer != null) {
                            return this.arrayForLoopCallToSerialize(annotation, getterOrField, stringSerializer);
                        }
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        if (stringSerializer != null) {
                            return this.fieldCallSerialize(annotation, getterOrField, stringSerializer);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case DOCUMENT_PROPERTY: {
                DocumentPropertyAnnotation docPropAnnotation = (DocumentPropertyAnnotation)annotation;
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.collectionForLoopCallToGenericDocument(docPropAnnotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayForLoopCallToGenericDocument(docPropAnnotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldCallToGenericDocument(docPropAnnotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case LONG_PROPERTY: {
                SerializerClass longSerializer = ((LongPropertyAnnotation)annotation).getCustomSerializer();
                switch (typeCategory) {
                    case COLLECTION: {
                        if (longSerializer != null) {
                            return this.collectionForLoopCallSerialize(annotation, getterOrField, longSerializer);
                        }
                        return this.collectionForLoopAssign(annotation, getterOrField, this.mHelper.longPrimitiveType);
                    }
                    case ARRAY: {
                        if (longSerializer != null) {
                            return this.arrayForLoopCallToSerialize(annotation, getterOrField, longSerializer);
                        }
                        if (this.mHelper.isPrimitiveLongArray(getterOrField.getJvmType())) {
                            return this.arrayUseDirectly(annotation, getterOrField);
                        }
                        return this.arrayForLoopAssign(annotation, getterOrField, this.mHelper.longPrimitiveType);
                    }
                    case SINGLE: {
                        if (longSerializer != null) {
                            return this.fieldCallSerialize(annotation, getterOrField, longSerializer);
                        }
                        if (getterOrField.getJvmType() instanceof PrimitiveType) {
                            return this.fieldUseDirectlyWithoutNullCheck(annotation, getterOrField);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case DOUBLE_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.collectionForLoopAssign(annotation, getterOrField, this.mHelper.doublePrimitiveType);
                    }
                    case ARRAY: {
                        if (this.mHelper.isPrimitiveDoubleArray(getterOrField.getJvmType())) {
                            return this.arrayUseDirectly(annotation, getterOrField);
                        }
                        return this.arrayForLoopAssign(annotation, getterOrField, this.mHelper.doublePrimitiveType);
                    }
                    case SINGLE: {
                        if (getterOrField.getJvmType() instanceof PrimitiveType) {
                            return this.fieldUseDirectlyWithoutNullCheck(annotation, getterOrField);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case BOOLEAN_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.collectionForLoopAssign(annotation, getterOrField, this.mHelper.booleanPrimitiveType);
                    }
                    case ARRAY: {
                        if (this.mHelper.isPrimitiveBooleanArray(getterOrField.getJvmType())) {
                            return this.arrayUseDirectly(annotation, getterOrField);
                        }
                        return this.arrayForLoopAssign(annotation, getterOrField, this.mHelper.booleanPrimitiveType);
                    }
                    case SINGLE: {
                        if (getterOrField.getJvmType() instanceof PrimitiveType) {
                            return this.fieldUseDirectlyWithoutNullCheck(annotation, getterOrField);
                        }
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case BYTES_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.collectionForLoopAssign(annotation, getterOrField, this.mHelper.bytePrimitiveArrayType);
                    }
                    case ARRAY: {
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case EMBEDDING_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.collectionCallToArray(annotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
            case BLOB_HANDLE_PROPERTY: {
                switch (typeCategory) {
                    case COLLECTION: {
                        return this.collectionCallToArray(annotation, getterOrField);
                    }
                    case ARRAY: {
                        return this.arrayUseDirectly(annotation, getterOrField);
                    }
                    case SINGLE: {
                        return this.fieldUseDirectlyWithNullCheck(annotation, getterOrField);
                    }
                }
                throw new IllegalStateException("Unhandled type-category: " + String.valueOf((Object)typeCategory));
            }
        }
        throw new IllegalStateException("Unhandled annotation: " + String.valueOf(annotation));
    }

    private @NonNull CodeBlock collectionForLoopAssign(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull TypeMirror targetArrayComponentType) {
        TypeMirror jvmType = getterOrField.getJvmType();
        TypeMirror componentType = getterOrField.getComponentType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = $L", new Object[]{targetArrayComponentType, jvmName, CodegenUtils.createNewArrayExpr(targetArrayComponentType, CodeBlock.of((String)"$NCopy.size()", (Object[])new Object[]{jvmName}), this.mEnv)}).addStatement("int i = 0", new Object[0]).beginControlFlow("for ($T item : $NCopy)", new Object[]{componentType, jvmName}).addStatement("$NConv[i++] = item", new Object[]{jvmName}).endControlFlow().addStatement("builder.$N($S, $NConv)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock collectionCallToArray(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror collectionType = getterOrField.getJvmType();
        TypeMirror componentType = getterOrField.getComponentType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{collectionType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = $NCopy.toArray(new $T[0])", new Object[]{componentType, jvmName, jvmName, componentType}).addStatement("builder.$N($S, $NConv)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock collectionForLoopCallToGenericDocument(@NonNull DocumentPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror collectionType = getterOrField.getJvmType();
        TypeMirror documentClass = getterOrField.getComponentType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{collectionType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = new $T[$NCopy.size()]", new Object[]{IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName, IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName}).addStatement("int i = 0", new Object[0]).beginControlFlow("for ($T item : $NCopy)", new Object[]{documentClass, jvmName}).addStatement("$NConv[i++] = $T.fromDocumentClass(item)", new Object[]{jvmName, IntrospectionHelper.GENERIC_DOCUMENT_CLASS}).endControlFlow().addStatement("builder.setPropertyDocument($S, $NConv)", new Object[]{annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock collectionForLoopCallSerialize(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull SerializerClass serializerClass) {
        TypeMirror jvmType = getterOrField.getJvmType();
        TypeMirror customType = getterOrField.getComponentType();
        String jvmName = getterOrField.getJvmName();
        TypeMirror propType = annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper);
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = new $T[$NCopy.size()]", new Object[]{propType, jvmName, propType, jvmName}).addStatement("$T serializer = new $T()", new Object[]{serializerClass.getElement(), serializerClass.getElement()}).addStatement("int i = 0", new Object[0]).beginControlFlow("for ($T item : $NCopy)", new Object[]{customType, jvmName}).addStatement("$NConv[i++] = serializer.serialize(item)", new Object[]{jvmName}).endControlFlow().addStatement("builder.$N($S, $NConv)", new Object[]{annotation.getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock arrayForLoopAssign(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull TypeMirror targetArrayComponentType) {
        TypeMirror jvmType = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = $L", new Object[]{targetArrayComponentType, jvmName, CodegenUtils.createNewArrayExpr(targetArrayComponentType, CodeBlock.of((String)"$NCopy.length", (Object[])new Object[]{jvmName}), this.mEnv)}).beginControlFlow("for (int i = 0; i < $NCopy.length; i++)", new Object[]{jvmName}).addStatement("$NConv[i] = $NCopy[i]", new Object[]{jvmName, jvmName}).endControlFlow().addStatement("builder.$N($S, $NConv)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock arrayUseDirectly(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror jvmType = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("builder.$N($S, $NCopy)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock arrayForLoopCallToGenericDocument(@NonNull DocumentPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror jvmType = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = new $T[$NCopy.length]", new Object[]{IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName, IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName}).beginControlFlow("for (int i = 0; i < $NConv.length; i++)", new Object[]{jvmName}).addStatement("$NConv[i] = $T.fromDocumentClass($NCopy[i])", new Object[]{jvmName, IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName}).endControlFlow().addStatement("builder.setPropertyDocument($S, $NConv)", new Object[]{annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock arrayForLoopCallToSerialize(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull SerializerClass serializerClass) {
        TypeMirror jvmType = getterOrField.getJvmType();
        TypeMirror propType = annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper);
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T[] $NConv = new $T[$NCopy.length]", new Object[]{propType, jvmName, propType, jvmName}).addStatement("$T serializer = new $T()", new Object[]{serializerClass.getElement(), serializerClass.getElement()}).beginControlFlow("for (int i = 0; i < $NConv.length; i++)", new Object[]{jvmName}).addStatement("$NConv[i] = serializer.serialize($NCopy[i])", new Object[]{jvmName, jvmName}).endControlFlow().addStatement("builder.$N($S, $NConv)", new Object[]{annotation.getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock fieldUseDirectlyWithNullCheck(@NonNull PropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror jvmType = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        CodeBlock.Builder codeBlock = CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{jvmType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName});
        switch (annotation.getPropertyKind()) {
            case METADATA_PROPERTY: {
                codeBlock.addStatement("builder.$N($NCopy)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), jvmName});
                break;
            }
            case DATA_PROPERTY: {
                codeBlock.addStatement("builder.$N($S, $NCopy)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), ((DataPropertyAnnotation)annotation).getName(), jvmName});
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled annotation: " + String.valueOf(annotation));
            }
        }
        return codeBlock.endControlFlow().build();
    }

    private @NonNull CodeBlock fieldUseDirectlyWithoutNullCheck(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        return CodeBlock.builder().addStatement("builder.$N($S, $L)", new Object[]{getterOrField.getAnnotation().getGenericDocSetterName(), annotation.getName(), this.createReadExpr(getterOrField)}).build();
    }

    private @NonNull CodeBlock fieldCallToGenericDocument(@NonNull DocumentPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField) {
        TypeMirror documentClass = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{documentClass, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T $NConv = $T.fromDocumentClass($NCopy)", new Object[]{IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName, IntrospectionHelper.GENERIC_DOCUMENT_CLASS, jvmName}).addStatement("builder.setPropertyDocument($S, $NConv)", new Object[]{annotation.getName(), jvmName}).endControlFlow().build();
    }

    private @NonNull CodeBlock fieldCallSerialize(@NonNull DataPropertyAnnotation annotation, @NonNull AnnotatedGetterOrField getterOrField, @NonNull SerializerClass serializerClass) {
        TypeMirror customType = getterOrField.getJvmType();
        String jvmName = getterOrField.getJvmName();
        return CodeBlock.builder().addStatement("$T $NCopy = $L", new Object[]{customType, jvmName, this.createReadExpr(getterOrField)}).beginControlFlow("if ($NCopy != null)", new Object[]{jvmName}).addStatement("$T serializer = new $T()", new Object[]{serializerClass.getElement(), serializerClass.getElement()}).addStatement("$T $NConv = serializer.serialize($NCopy)", new Object[]{annotation.getUnderlyingTypeWithinGenericDoc(this.mHelper), jvmName, jvmName}).addStatement("builder.$N($S, $NConv)", new Object[]{annotation.getGenericDocSetterName(), annotation.getName(), jvmName}).endControlFlow().build();
    }

    private CodeBlock createReadExpr(@NonNull AnnotatedGetterOrField annotatedGetterOrField) {
        PropertyAccessor accessor = this.mModel.getAccessor(annotatedGetterOrField);
        if (accessor.isField()) {
            return CodeBlock.of((String)"document.$N", (Object[])new Object[]{accessor.getElement().getSimpleName().toString()});
        }
        return CodeBlock.of((String)"document.$N()", (Object[])new Object[]{accessor.getElement().getSimpleName().toString()});
    }
}

