/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler.annotationwrapper;

import androidx.appsearch.compiler.IntrospectionHelper;
import androidx.appsearch.compiler.annotationwrapper.PropertyAnnotation;
import com.squareup.javapoet.ClassName;
import java.util.Arrays;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum MetadataPropertyAnnotation implements PropertyAnnotation
{
    ID("Id", "getId", "setId"),
    NAMESPACE("Namespace", "getNamespace", "setNamespace"),
    CREATION_TIMESTAMP_MILLIS("CreationTimestampMillis", "getCreationTimestampMillis", "setCreationTimestampMillis"),
    TTL_MILLIS("TtlMillis", "getTtlMillis", "setTtlMillis"),
    SCORE("Score", "getScore", "setScore");

    private final @NonNull ClassName mClassName;
    private final @NonNull String mGenericDocGetterName;
    private final @NonNull String mGenericDocSetterName;

    public static @Nullable MetadataPropertyAnnotation tryParse(@NonNull AnnotationMirror annotation) {
        String qualifiedClassName = annotation.getAnnotationType().toString();
        return Arrays.stream(MetadataPropertyAnnotation.values()).filter(val -> val.getClassName().canonicalName().equals(qualifiedClassName)).findFirst().orElse(null);
    }

    private MetadataPropertyAnnotation(@NonNull String simpleClassName, String genericDocGetterName, String genericDocSetterName) {
        this.mClassName = IntrospectionHelper.DOCUMENT_ANNOTATION_CLASS.nestedClass(simpleClassName);
        this.mGenericDocGetterName = genericDocGetterName;
        this.mGenericDocSetterName = genericDocSetterName;
    }

    @Override
    public @NonNull ClassName getClassName() {
        return this.mClassName;
    }

    @Override
    public @NonNull PropertyAnnotation.Kind getPropertyKind() {
        return PropertyAnnotation.Kind.METADATA_PROPERTY;
    }

    @Override
    public @NonNull TypeMirror getUnderlyingTypeWithinGenericDoc(@NonNull IntrospectionHelper helper) {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return helper.stringType;
            }
            case 2: 
            case 3: {
                return helper.longPrimitiveType;
            }
            case 4: {
                return helper.intPrimitiveType;
            }
        }
        throw new IllegalStateException("Unhandled metadata property annotation: " + String.valueOf(this));
    }

    @Override
    public @NonNull String getGenericDocGetterName() {
        return this.mGenericDocGetterName;
    }

    @Override
    public @NonNull String getGenericDocSetterName() {
        return this.mGenericDocSetterName;
    }
}

