/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.compiler.annotationwrapper;

import androidx.appsearch.compiler.ProcessingException;
import androidx.appsearch.compiler.annotationwrapper.SerializerClass;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0002 !B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Landroidx/appsearch/compiler/annotationwrapper/SerializerClass;", "", "kind", "Landroidx/appsearch/compiler/annotationwrapper/SerializerClass$Kind;", "element", "Ljavax/lang/model/element/TypeElement;", "defaultConstructor", "Ljavax/lang/model/element/ExecutableElement;", "customType", "Ljavax/lang/model/type/TypeMirror;", "<init>", "(Landroidx/appsearch/compiler/annotationwrapper/SerializerClass$Kind;Ljavax/lang/model/element/TypeElement;Ljavax/lang/model/element/ExecutableElement;Ljavax/lang/model/type/TypeMirror;)V", "getKind", "()Landroidx/appsearch/compiler/annotationwrapper/SerializerClass$Kind;", "getElement", "()Ljavax/lang/model/element/TypeElement;", "getDefaultConstructor", "()Ljavax/lang/model/element/ExecutableElement;", "getCustomType", "()Ljavax/lang/model/type/TypeMirror;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Kind", "Companion", "appsearch-compiler"})
public final class SerializerClass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Kind kind;
    @NotNull
    private final TypeElement element;
    @NotNull
    private final ExecutableElement defaultConstructor;
    @NotNull
    private final TypeMirror customType;

    public SerializerClass(@NotNull Kind kind, @NotNull TypeElement element, @NotNull ExecutableElement defaultConstructor, @NotNull TypeMirror customType) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)defaultConstructor, (String)"defaultConstructor");
        Intrinsics.checkNotNullParameter((Object)customType, (String)"customType");
        this.kind = kind;
        this.element = element;
        this.defaultConstructor = defaultConstructor;
        this.customType = customType;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final TypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final ExecutableElement getDefaultConstructor() {
        return this.defaultConstructor;
    }

    @NotNull
    public final TypeMirror getCustomType() {
        return this.customType;
    }

    @NotNull
    public final Kind component1() {
        return this.kind;
    }

    @NotNull
    public final TypeElement component2() {
        return this.element;
    }

    @NotNull
    public final ExecutableElement component3() {
        return this.defaultConstructor;
    }

    @NotNull
    public final TypeMirror component4() {
        return this.customType;
    }

    @NotNull
    public final SerializerClass copy(@NotNull Kind kind, @NotNull TypeElement element, @NotNull ExecutableElement defaultConstructor, @NotNull TypeMirror customType) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)defaultConstructor, (String)"defaultConstructor");
        Intrinsics.checkNotNullParameter((Object)customType, (String)"customType");
        return new SerializerClass(kind, element, defaultConstructor, customType);
    }

    public static /* synthetic */ SerializerClass copy$default(SerializerClass serializerClass, Kind kind, TypeElement typeElement, ExecutableElement executableElement, TypeMirror typeMirror, int n, Object object) {
        if ((n & 1) != 0) {
            kind = serializerClass.kind;
        }
        if ((n & 2) != 0) {
            typeElement = serializerClass.element;
        }
        if ((n & 4) != 0) {
            executableElement = serializerClass.defaultConstructor;
        }
        if ((n & 8) != 0) {
            typeMirror = serializerClass.customType;
        }
        return serializerClass.copy(kind, typeElement, executableElement, typeMirror);
    }

    @NotNull
    public String toString() {
        return "SerializerClass(kind=" + this.kind + ", element=" + this.element + ", defaultConstructor=" + this.defaultConstructor + ", customType=" + this.customType + ")";
    }

    public int hashCode() {
        int result = this.kind.hashCode();
        result = result * 31 + this.element.hashCode();
        result = result * 31 + this.defaultConstructor.hashCode();
        result = result * 31 + ((Object)this.customType).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SerializerClass)) {
            return false;
        }
        SerializerClass serializerClass = (SerializerClass)other;
        if (this.kind != serializerClass.kind) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.element, (Object)serializerClass.element)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultConstructor, (Object)serializerClass.defaultConstructor)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.customType, (Object)serializerClass.customType);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Landroidx/appsearch/compiler/annotationwrapper/SerializerClass$Companion;", "", "<init>", "()V", "create", "Landroidx/appsearch/compiler/annotationwrapper/SerializerClass;", "clazz", "Ljavax/lang/model/element/TypeElement;", "kind", "Landroidx/appsearch/compiler/annotationwrapper/SerializerClass$Kind;", "findDefaultConstructor", "Ljavax/lang/model/element/ExecutableElement;", "findDeserializeMethod", "hasSingleParamOfExactType", "", "method", "expectedType", "Lcom/squareup/javapoet/TypeName;", "appsearch-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SerializerClass create(@NotNull TypeElement clazz, @NotNull Kind kind) throws ProcessingException {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            ExecutableElement deserializeMethod = this.findDeserializeMethod(clazz, kind);
            ExecutableElement executableElement = this.findDefaultConstructor(clazz);
            TypeMirror typeMirror = deserializeMethod.getReturnType();
            Intrinsics.checkNotNullExpressionValue((Object)typeMirror, (String)"getReturnType(...)");
            return new SerializerClass(kind, clazz, executableElement, typeMirror);
        }

        private final ExecutableElement findDefaultConstructor(TypeElement clazz) throws ProcessingException {
            Object object = clazz.getEnclosedElements().stream().filter(arg_0 -> Companion.findDefaultConstructor$lambda$0(findDefaultConstructor.constructor.1.INSTANCE, arg_0)).map(arg_0 -> Companion.findDefaultConstructor$lambda$1(findDefaultConstructor.constructor.2.INSTANCE, arg_0)).filter(arg_0 -> Companion.findDefaultConstructor$lambda$3(Companion::findDefaultConstructor$lambda$2, arg_0)).findFirst().orElseThrow(() -> Companion.findDefaultConstructor$lambda$4(clazz));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"orElseThrow(...)");
            ExecutableElement constructor2 = (ExecutableElement)object;
            if (constructor2.getModifiers().contains((Object)Modifier.PRIVATE)) {
                throw new ProcessingException("The zero-param constructor of serializer " + clazz.getQualifiedName() + " must not be private", constructor2);
            }
            return constructor2;
        }

        private final ExecutableElement findDeserializeMethod(TypeElement clazz, Kind kind) {
            Object object = clazz.getEnclosedElements().stream().filter(arg_0 -> Companion.findDeserializeMethod$lambda$5(findDeserializeMethod.1.INSTANCE, arg_0)).map(arg_0 -> Companion.findDeserializeMethod$lambda$6(findDeserializeMethod.2.INSTANCE, arg_0)).filter(arg_0 -> Companion.findDeserializeMethod$lambda$8(arg_0 -> Companion.findDeserializeMethod$lambda$7(kind, arg_0), arg_0)).findFirst().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (ExecutableElement)object;
        }

        private final boolean hasSingleParamOfExactType(ExecutableElement method, TypeName expectedType) {
            if (method.getParameters().size() != 1) {
                return false;
            }
            List<? extends VariableElement> list = method.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            TypeName firstParamType = TypeName.get((TypeMirror)((VariableElement)CollectionsKt.first(list)).asType());
            return Intrinsics.areEqual((Object)firstParamType, (Object)expectedType);
        }

        private static final boolean findDefaultConstructor$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final ExecutableElement findDefaultConstructor$lambda$1(Function1 $tmp0, Object p0) {
            return (ExecutableElement)$tmp0.invoke(p0);
        }

        private static final boolean findDefaultConstructor$lambda$2(ExecutableElement it) {
            return it.getParameters().isEmpty();
        }

        private static final boolean findDefaultConstructor$lambda$3(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final ProcessingException findDefaultConstructor$lambda$4(TypeElement $clazz) {
            return new ProcessingException("Serializer " + $clazz.getQualifiedName() + " must have a zero-param constructor", $clazz);
        }

        private static final boolean findDeserializeMethod$lambda$5(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final ExecutableElement findDeserializeMethod$lambda$6(Function1 $tmp0, Object p0) {
            return (ExecutableElement)$tmp0.invoke(p0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean findDeserializeMethod$lambda$7(Kind $kind, ExecutableElement it) {
            if (!it.getSimpleName().contentEquals("deserialize")) return false;
            if (it.getModifiers().contains((Object)Modifier.STATIC)) return false;
            Intrinsics.checkNotNull((Object)it);
            if (!Companion.hasSingleParamOfExactType(it, $kind.getActualTypeInGenericDoc())) return false;
            return true;
        }

        private static final boolean findDeserializeMethod$lambda$8(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/appsearch/compiler/annotationwrapper/SerializerClass$Kind;", "", "actualTypeInGenericDoc", "Lcom/squareup/javapoet/TypeName;", "<init>", "(Ljava/lang/String;ILcom/squareup/javapoet/TypeName;)V", "getActualTypeInGenericDoc", "()Lcom/squareup/javapoet/TypeName;", "STRING_SERIALIZER", "LONG_SERIALIZER", "appsearch-compiler"})
    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        private final TypeName actualTypeInGenericDoc;
        public static final /* enum */ Kind STRING_SERIALIZER;
        public static final /* enum */ Kind LONG_SERIALIZER;
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(TypeName actualTypeInGenericDoc) {
            this.actualTypeInGenericDoc = actualTypeInGenericDoc;
        }

        @NotNull
        public final TypeName getActualTypeInGenericDoc() {
            return this.actualTypeInGenericDoc;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            ClassName className = ClassName.get(String.class);
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(...)");
            STRING_SERIALIZER = new Kind((TypeName)className);
            TypeName typeName = TypeName.LONG;
            Intrinsics.checkNotNullExpressionValue((Object)typeName, (String)"LONG");
            LONG_SERIALIZER = new Kind(typeName);
            $VALUES = kindArray = new Kind[]{Kind.STRING_SERIALIZER, Kind.LONG_SERIALIZER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

