/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.configuration;

import androidx.baselineprofile.gradle.configuration.attribute.BaselineProfilePluginAgpVersionAttr;
import androidx.baselineprofile.gradle.configuration.attribute.BaselineProfilePluginVersionAttr;
import androidx.baselineprofile.gradle.utils.AgpKt;
import androidx.baselineprofile.gradle.utils.UtilsKt;
import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\r\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000e\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000f\u001a\u00020\u0007*\u00020\b2\u0018\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u00110\u0010H\u0002J\u008c\u0001\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u001a\u0010\u000f\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0011\u0018\u00010\u00102\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nJ\f\u0010\u001a\u001a\u00020\n*\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/baselineprofile/gradle/configuration/ConfigurationManager;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "usage", "", "Lorg/gradle/api/attributes/AttributeContainer;", "value", "", "buildType", "targetJvmEnvironment", "agpVersion", "baselineProfilePluginVersion", "productFlavors", "", "Lkotlin/Pair;", "maybeCreate", "Lorg/gradle/api/artifacts/Configuration;", "nameParts", "canBeResolved", "", "canBeConsumed", "extendFromConfigurations", "bpPluginVersion", "versionString", "Lcom/android/build/api/AndroidPluginVersion;", "benchmark-baseline-profile-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nConfigurationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationManager.kt\nandroidx/baselineprofile/gradle/configuration/ConfigurationManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,119:1\n1863#2,2:120\n37#3,2:122\n*S KotlinDebug\n*F\n+ 1 ConfigurationManager.kt\nandroidx/baselineprofile/gradle/configuration/ConfigurationManager\n*L\n72#1:120,2\n92#1:122,2\n*E\n"})
public final class ConfigurationManager {
    @NotNull
    private final Project project;

    public ConfigurationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void usage(AttributeContainer $this$usage, String value) {
        $this$usage.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.project.getObjects().named(Usage.class, value));
    }

    private final void buildType(AttributeContainer $this$buildType, String value) {
        $this$buildType.attribute(BuildTypeAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BuildTypeAttr.class, value));
    }

    private final void targetJvmEnvironment(AttributeContainer $this$targetJvmEnvironment, String value) {
        $this$targetJvmEnvironment.attribute(TargetJvmEnvironment.TARGET_JVM_ENVIRONMENT_ATTRIBUTE, (Object)this.project.getObjects().named(TargetJvmEnvironment.class, value));
    }

    private final void agpVersion(AttributeContainer $this$agpVersion, String value) {
        $this$agpVersion.attribute(BaselineProfilePluginAgpVersionAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BaselineProfilePluginAgpVersionAttr.class, value));
    }

    private final void baselineProfilePluginVersion(AttributeContainer $this$baselineProfilePluginVersion, String value) {
        $this$baselineProfilePluginVersion.attribute(BaselineProfilePluginVersionAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BaselineProfilePluginVersionAttr.class, value));
    }

    private final void productFlavors(AttributeContainer $this$productFlavors, List<Pair<String, String>> productFlavors) {
        Iterable $this$forEach$iv = productFlavors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String flavorName = (String)pair.component1();
            String flavorValue = (String)pair.component2();
            $this$productFlavors.attribute(ProductFlavorAttr.Companion.of(flavorName), (Object)this.project.getObjects().named(ProductFlavorAttr.class, flavorValue));
        }
    }

    @NotNull
    public final Configuration maybeCreate(@NotNull List<String> nameParts, boolean canBeResolved, boolean canBeConsumed, @Nullable List<? extends Configuration> extendFromConfigurations, @Nullable String buildType, @Nullable List<Pair<String, String>> productFlavors, @Nullable String usage, @Nullable String targetJvmEnvironment, @Nullable String bpPluginVersion, @Nullable String agpVersion) {
        Intrinsics.checkNotNullParameter(nameParts, (String)"nameParts");
        Collection $this$toTypedArray$iv = nameParts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object = thisCollection$iv.toArray(new String[0]);
        object = this.project.getConfigurations().maybeCreate(UtilsKt.camelCase(Arrays.copyOf(object, ((String[])object).length)));
        Configuration $this$maybeCreate_u24lambda_u243 = (Configuration)object;
        boolean bl = false;
        $this$maybeCreate_u24lambda_u243.setCanBeResolved(canBeResolved);
        $this$maybeCreate_u24lambda_u243.setCanBeConsumed(canBeConsumed);
        if (extendFromConfigurations != null) {
            $this$maybeCreate_u24lambda_u243.setExtendsFrom((Iterable)extendFromConfigurations);
        }
        $this$maybeCreate_u24lambda_u243.attributes(arg_0 -> ConfigurationManager.maybeCreate$lambda$3$lambda$2(arg_0 -> ConfigurationManager.maybeCreate$lambda$3$lambda$1(buildType, this, productFlavors, usage, targetJvmEnvironment, agpVersion, bpPluginVersion, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
        return (Configuration)object;
    }

    public static /* synthetic */ Configuration maybeCreate$default(ConfigurationManager configurationManager, List list, boolean bl, boolean bl2, List list2, String string, List list3, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = null;
        }
        if ((n & 0x40) != 0) {
            string2 = "baselineProfile";
        }
        if ((n & 0x80) != 0) {
            string3 = "android";
        }
        if ((n & 0x100) != 0) {
            string4 = "alpha1";
        }
        if ((n & 0x200) != 0) {
            string5 = configurationManager.versionString(AgpKt.agpVersion(configurationManager.project));
        }
        return configurationManager.maybeCreate(list, bl, bl2, list2, string, list3, string2, string3, string4, string5);
    }

    private final String versionString(AndroidPluginVersion $this$versionString) {
        CharSequence charSequence = $this$versionString.getPreviewType();
        String preview = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? "-" + $this$versionString.getPreviewType() + $this$versionString.getPreview() : "";
        return $this$versionString.getMajor() + "." + $this$versionString.getMinor() + "." + $this$versionString.getMicro() + preview;
    }

    private static final Unit maybeCreate$lambda$3$lambda$1(String $buildType, ConfigurationManager this$0, List $productFlavors, String $usage, String $targetJvmEnvironment, String $agpVersion, String $bpPluginVersion, AttributeContainer it) {
        if ($buildType != null) {
            Intrinsics.checkNotNull((Object)it);
            this$0.buildType(it, $buildType);
        }
        if ($productFlavors != null) {
            Intrinsics.checkNotNull((Object)it);
            this$0.productFlavors(it, $productFlavors);
        }
        if ($usage != null) {
            Intrinsics.checkNotNull((Object)it);
            this$0.usage(it, $usage);
        }
        if ($targetJvmEnvironment != null) {
            Intrinsics.checkNotNull((Object)it);
            this$0.targetJvmEnvironment(it, $targetJvmEnvironment);
        }
        if ($agpVersion != null) {
            Intrinsics.checkNotNull((Object)it);
            this$0.agpVersion(it, $agpVersion);
        }
        if ($bpPluginVersion != null) {
            Intrinsics.checkNotNull((Object)it);
            this$0.baselineProfilePluginVersion(it, $bpPluginVersion);
        }
        return Unit.INSTANCE;
    }

    private static final void maybeCreate$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

