/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.consumer.task;

import androidx.baselineprofile.gradle.consumer.RuleType;
import androidx.baselineprofile.gradle.consumer.task.ProfileRule;
import androidx.baselineprofile.gradle.consumer.task.ProfileStats;
import androidx.baselineprofile.gradle.utils.BaselineProfilePluginLogger;
import androidx.baselineprofile.gradle.utils.UtilsKt;
import androidx.baselineprofile.gradle.utils.Warnings;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.buildanalyzer.common.TaskCategory;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 >2\u00020\u0001:\u0001>B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010.\u001a\u00020/H\u0007J&\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u00062\f\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u00105\u001a\u00020\u0006H\u0002J\u0018\u00106\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u0016H\u0002J \u00107\u001a\u00020\n*\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u00108\u001a\u00020\u0006H\u0002J,\u00109\u001a\b\u0012\u0004\u0012\u00020\u000603*\b\u0012\u0004\u0012\u00020;0:2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u00020\n0=H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00060\u00160\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\bR\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\bR\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'R\u001b\u0010*\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010)\u001a\u0004\b+\u0010,\u00a8\u0006?"}, d2={"Landroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "variantName", "Lorg/gradle/api/provider/Property;", "", "getVariantName", "()Lorg/gradle/api/provider/Property;", "lastTask", "", "getLastTask", "hasDependencies", "getHasDependencies", "library", "getLibrary", "baselineProfileFileCollection", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBaselineProfileFileCollection", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "filterRules", "Lorg/gradle/api/provider/ListProperty;", "Lkotlin/Pair;", "Landroidx/baselineprofile/gradle/consumer/RuleType;", "getFilterRules", "()Lorg/gradle/api/provider/ListProperty;", "baselineProfileDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBaselineProfileDir", "()Lorg/gradle/api/file/DirectoryProperty;", "printWarningNoBaselineProfileRulesGenerated", "getPrintWarningNoBaselineProfileRulesGenerated", "printWarningNoStartupProfileRulesGenerated", "getPrintWarningNoStartupProfileRulesGenerated", "printWarningVariantHasNoBaselineProfileDependency", "getPrintWarningVariantHasNoBaselineProfileDependency", "logger", "Landroidx/baselineprofile/gradle/utils/BaselineProfilePluginLogger;", "getLogger", "()Landroidx/baselineprofile/gradle/utils/BaselineProfilePluginLogger;", "logger$delegate", "Lkotlin/Lazy;", "variantHasDependencies", "getVariantHasDependencies", "()Z", "variantHasDependencies$delegate", "exec", "", "writeProfile", "filename", "rules", "", "Landroidx/baselineprofile/gradle/consumer/task/ProfileRule;", "profileType", "isInclude", "matches", "fullClassName", "readLines", "", "Ljava/io/File;", "filterBlock", "Lkotlin/Function1;", "Companion", "benchmark-baseline-profile-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nMergeBaselineProfileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,515:1\n992#2:516\n1021#2,3:517\n1024#2,3:527\n992#2:540\n1021#2,3:541\n1024#2,3:551\n381#3,7:520\n381#3,7:544\n126#4:530\n153#4,3:531\n126#4:554\n153#4,3:555\n774#5:534\n865#5:535\n1755#5,3:536\n866#5:539\n1611#5,9:558\n1863#5:567\n1864#5:569\n1620#5:570\n1368#5:571\n1454#5,5:572\n774#5:577\n865#5,2:578\n1368#5:580\n1454#5,5:581\n1#6:568\n*S KotlinDebug\n*F\n+ 1 MergeBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask\n*L\n284#1:516\n284#1:517,3\n284#1:527,3\n360#1:540\n360#1:541,3\n360#1:551,3\n284#1:520,7\n360#1:544,7\n285#1:530\n285#1:531,3\n361#1:554\n361#1:555,3\n286#1:534\n286#1:535\n300#1:536,3\n286#1:539\n378#1:558,9\n378#1:567\n378#1:569\n378#1:570\n456#1:571\n456#1:572,5\n463#1:577\n463#1:578,2\n464#1:580\n464#1:581,5\n378#1:568\n*E\n"})
public abstract class MergeBaselineProfileTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(() -> MergeBaselineProfileTask.logger_delegate$lambda$0(this));
    @NotNull
    private final Lazy variantHasDependencies$delegate = LazyKt.lazy(() -> MergeBaselineProfileTask.variantHasDependencies_delegate$lambda$1(this));
    @NotNull
    private static final String MERGE_TASK_NAME = "merge";
    @NotNull
    private static final String COPY_TASK_NAME = "copy";
    @NotNull
    private static final String FILENAME_MATCHER_BASELINE_PROFILE = "baseline-prof";
    @NotNull
    private static final String FILENAME_MATCHER_STARTUP_PROFILE = "startup-prof";
    @NotNull
    private static final String BASELINE_PROFILE_FILENAME = "baseline-prof.txt";
    @NotNull
    private static final String STARTUP_PROFILE_FILENAME = "startup-prof.txt";

    @Input
    @NotNull
    public abstract Property<String> getVariantName();

    @Input
    @NotNull
    public abstract Property<Boolean> getLastTask();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getHasDependencies();

    @Input
    @NotNull
    public abstract Property<Boolean> getLibrary();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getBaselineProfileFileCollection();

    @Input
    @NotNull
    public abstract ListProperty<Pair<RuleType, String>> getFilterRules();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getBaselineProfileDir();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintWarningNoBaselineProfileRulesGenerated();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintWarningNoStartupProfileRulesGenerated();

    @Input
    @NotNull
    public abstract Property<Boolean> getPrintWarningVariantHasNoBaselineProfileDependency();

    private final BaselineProfilePluginLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (BaselineProfilePluginLogger)lazy.getValue();
    }

    private final boolean getVariantHasDependencies() {
        Lazy lazy = this.variantHasDependencies$delegate;
        return (Boolean)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void exec() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        ProfileRule it;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Sequence $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        Object list$iv$iv2;
        ProfileRule it2;
        void $this$groupByTo$iv$iv2;
        Map $this$groupBy$iv2;
        if (((Boolean)this.getLastTask().get()).booleanValue() && !this.getVariantHasDependencies()) {
            this.getLogger().warn((Function1<? super Warnings, Boolean>)((Function1)arg_0 -> MergeBaselineProfileTask.exec$lambda$2(this, arg_0)), "variantHasNoBaselineProfileDependency", StringsKt.trimIndent((String)("\n                The baseline profile consumer plugin is applied to this module but no dependency\n                has been set for variant `" + this.getVariantName().get() + "`, so no baseline profile will be \n                generated for it.\n\n                A dependency for all the variants can be added in the dependency block using\n                `baselineProfile` configuration:\n\n                dependencies {\n                    ...\n                    baselineProfile(project(\":baselineprofile\"))\n                }\n\n                Or for a specific variant in the baseline profile block:\n\n                baselineProfile {\n                    variants {\n                        freeRelease {\n                            from(project(\":baselineprofile\"))\n                        }\n                    }\n                }\n                ")));
        }
        Object object2 = this.getFilterRules().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Iterable iterable = (Iterable)object2;
        Comparator<Object> comparator = ((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair r = (Pair)a;
                boolean bl = false;
                String[] stringArray = new String[]{"."};
                Comparable comparable = Integer.valueOf(StringsKt.split$default((CharSequence)((CharSequence)r.getSecond()), (String[])stringArray, (boolean)false, (int)0, (int)6, null).size());
                r = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                stringArray = new String[]{"."};
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(StringsKt.split$default((CharSequence)((CharSequence)r.getSecond()), (String[])stringArray, (boolean)false, (int)0, (int)6, null).size()));
            }
        }).thenComparing(arg_0 -> MergeBaselineProfileTask.exec$lambda$5(MergeBaselineProfileTask::exec$lambda$4, arg_0)).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        List rules = CollectionsKt.sortedWith((Iterable)iterable, comparator);
        Set set = this.getBaselineProfileFileCollection().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
        List<String> baselineProfileRules = this.readLines(set, (Function1<? super File, Boolean>)((Function1)MergeBaselineProfileTask::exec$lambda$6));
        if (((Boolean)this.getLastTask().get()).booleanValue() && this.getVariantHasDependencies() && baselineProfileRules.isEmpty()) {
            this.getLogger().warn((Function1<? super Warnings, Boolean>)((Function1)arg_0 -> MergeBaselineProfileTask.exec$lambda$7(this, arg_0)), "noBaselineProfileRulesGenerated", StringsKt.trimIndent((String)("\n                No baseline profile rules were generated for the variant `" + this.getVariantName().get() + "`.\n                This is most likely because there are no instrumentation test for it. If this\n                is not intentional check that tests for this variant exist in the `baselineProfile`\n                dependency module.\n            ")));
        }
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.sorted((Iterable)baselineProfileRules)), MergeBaselineProfileTask::exec$lambda$8);
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv2;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object3;
            it2 = (ProfileRule)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it2.getClassDescriptor() + it2.getMethodDescriptor();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv2 = (List)object3;
            list$iv$iv2.add(element$iv$iv);
        }
        $this$groupBy$iv2 = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv2.entrySet()) {
            list$iv$iv2 = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add((ProfileRule)((List)it2.getValue()).get(0));
        }
        $this$map$iv2 = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block20: {
                it2 = (ProfileRule)element$iv$iv;
                boolean bl3 = false;
                if (rules.isEmpty()) {
                    bl = true;
                } else {
                    boolean bl4;
                    block21: {
                        for (Pair r : rules) {
                            Intrinsics.checkNotNull((Object)r);
                            if (!this.matches((Pair<? extends RuleType, String>)r, it2.getFullClassName())) continue;
                            bl = this.isInclude((Pair<? extends RuleType, String>)r);
                            break block20;
                        }
                        Iterable $this$any$iv = rules;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Pair r = (Pair)element$iv;
                                boolean bl5 = false;
                                Intrinsics.checkNotNull((Object)r);
                                if (!this.isInclude((Pair<? extends RuleType, String>)r)) continue;
                                bl4 = true;
                                break block21;
                            }
                            bl4 = false;
                        }
                    }
                    bl = !bl4;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredBaselineProfileRules = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), ProfileRule.Companion.getComparator$benchmark_baseline_profile_gradle_plugin());
        if (!((Collection)baselineProfileRules).isEmpty() && filteredBaselineProfileRules.isEmpty() && !((Collection)rules).isEmpty()) {
            throw new GradleException("The baseline profile consumer plugin is configured with filters that exclude all\nthe profile rules. Please review your build.gradle configuration and make sure your\nfilters don't exclude all the baseline profile rules.");
        }
        this.writeProfile(BASELINE_PROFILE_FILENAME, filteredBaselineProfileRules, "baseline");
        if (((Boolean)this.getLibrary().get()).booleanValue()) {
            return;
        }
        Set set2 = this.getBaselineProfileFileCollection().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getFiles(...)");
        List<String> startupRules = this.readLines(set2, (Function1<? super File, Boolean>)((Function1)MergeBaselineProfileTask::exec$lambda$13));
        if (((Boolean)this.getLastTask().get()).booleanValue() && this.getVariantHasDependencies() && startupRules.isEmpty()) {
            this.getLogger().warn((Function1<? super Warnings, Boolean>)((Function1)arg_0 -> MergeBaselineProfileTask.exec$lambda$14(this, arg_0)), "noBaselineProfileRulesGenerated", StringsKt.trimIndent((String)("\n                No startup profile rules were generated for the variant `" + this.getVariantName().get() + "`.\n                This is most likely because there are no instrumentation test with baseline profile\n                rule, which specify `includeInStartupProfile = true`. If this is not intentional\n                check that tests for this variant exist in the `baselineProfile` dependency module.\n            ")));
        }
        $this$filterTo$iv$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)startupRules)), MergeBaselineProfileTask::exec$lambda$15);
        boolean $i$f$groupBy2 = false;
        void $i$f$filterTo22 = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object4;
            it = (ProfileRule)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getClassDescriptor() + it.getMethodDescriptor();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo2 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add((ProfileRule)((List)it.getValue()).get(0));
        }
        List sortedStartupProfileRules = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), ProfileRule.Companion.getComparator$benchmark_baseline_profile_gradle_plugin());
        this.writeProfile(STARTUP_PROFILE_FILENAME, sortedStartupProfileRules, "startup");
    }

    /*
     * WARNING - void declaration
     */
    private final void writeProfile(String filename, List<ProfileRule> rules, String profileType) {
        block5: {
            ProfileStats profileStats;
            Object object;
            File file;
            File $this$writeProfile_u24lambda_u2423 = file = ((RegularFile)this.getBaselineProfileDir().file(filename).get()).getAsFile();
            boolean bl = false;
            if ($this$writeProfile_u24lambda_u2423.exists()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNull((Object)$this$writeProfile_u24lambda_u2423);
                object = FilesKt.readLines$default((File)$this$writeProfile_u24lambda_u2423, null, (int)1, null);
                ProfileStats.Companion companion = ProfileStats.Companion;
                boolean $i$f$mapNotNull = false;
                void var10_11 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ProfileRule it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    String it = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (ProfileRule.Companion.parse(it) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                profileStats = companion.from((List)destination$iv$iv, rules);
            } else {
                profileStats = null;
            }
            ProfileStats stats = profileStats;
            $this$writeProfile_u24lambda_u2423.delete();
            if (rules.isEmpty()) {
                return;
            }
            Intrinsics.checkNotNull((Object)$this$writeProfile_u24lambda_u2423);
            Iterable iterable = rules;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
            FilesKt.writeText$default((File)$this$writeProfile_u24lambda_u2423, (String)CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, MergeBaselineProfileTask::writeProfile$lambda$23$lambda$19, (int)30, null), null, (int)2, null);
            if (!((Boolean)this.getLastTask().get()).booleanValue()) {
                return;
            }
            BaselineProfilePluginLogger baselineProfilePluginLogger = this.getLogger();
            Function1 function1 = MergeBaselineProfileTask::writeProfile$lambda$23$lambda$20;
            Object object2 = this.getVariantName().get();
            String string2 = $this$writeProfile_u24lambda_u2423.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            Path path = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            baselineProfilePluginLogger.warn((Function1<? super Warnings, Boolean>)function1, null, StringsKt.trimIndent((String)("\n\n                    A " + profileType + " profile was generated for the variant `" + object2 + "`:\n                    " + path.toUri() + "\n                        ")));
            ProfileStats profileStats2 = stats;
            if (profileStats2 == null) break block5;
            Object $this$writeProfile_u24lambda_u2423_u24lambda_u2422 = object = profileStats2;
            boolean bl5 = false;
            BaselineProfilePluginLogger baselineProfilePluginLogger2 = this.getLogger();
            Function1 function12 = MergeBaselineProfileTask::writeProfile$lambda$23$lambda$22$lambda$21;
            int n = ((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getExisting();
            int n2 = ((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getNew();
            int n3 = ((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getAdded();
            String string3 = "%.2f";
            Object[] objectArray = new Object[]{Float.valueOf(((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getAddedRatio() * (float)100)};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            int n4 = ((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getRemoved();
            string3 = "%.2f";
            objectArray = new Object[]{Float.valueOf(((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getRemovedRatio() * (float)100)};
            String string5 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            int n5 = ((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getUnmodified();
            string3 = "%.2f";
            objectArray = new Object[]{Float.valueOf(((ProfileStats)$this$writeProfile_u24lambda_u2423_u24lambda_u2422).getUnmodifiedRatio() * (float)100)};
            String string6 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            baselineProfilePluginLogger2.warn((Function1<? super Warnings, Boolean>)function12, null, StringsKt.trimIndent((String)("\n\n                    Comparison with previous " + profileType + " profile:\n                      " + n + " Old rules\n                      " + n2 + " New rules\n                      " + n3 + " Added rules (" + string4 + "%)\n                      " + n4 + " Removed rules (" + string5 + "%)\n                      " + n5 + " Unmodified rules (" + string6 + "%)\n\n                      ")));
        }
    }

    private final boolean isInclude(Pair<? extends RuleType, String> $this$isInclude) {
        return $this$isInclude.getFirst() == RuleType.INCLUDE;
    }

    private final boolean matches(Pair<? extends RuleType, String> $this$matches, String fullClassName) {
        boolean bl;
        String rule = (String)$this$matches.getSecond();
        if (StringsKt.endsWith$default((String)rule, (String)".**", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"."};
            String pkg = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)fullClassName, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            String rulePkg = StringsKt.dropLast((String)rule, (int)3);
            bl = StringsKt.startsWith$default((String)pkg, (String)rulePkg, (boolean)false, (int)2, null);
        } else if (StringsKt.endsWith$default((String)rule, (String)".*", (boolean)false, (int)2, null)) {
            String[] rulePkg = new String[]{"."};
            List pkgParts = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)fullClassName, (String[])rulePkg, (boolean)false, (int)0, (int)6, null), (int)1);
            String pkg = CollectionsKt.joinToString$default((Iterable)pkgParts, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            String rulePkg2 = StringsKt.dropLast((String)rule, (int)2);
            String[] stringArray = new String[]{"."};
            List ruleParts = StringsKt.split$default((CharSequence)rulePkg2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            bl = StringsKt.startsWith$default((String)pkg, (String)rulePkg2, (boolean)false, (int)2, null) && ruleParts.size() == pkgParts.size();
        } else {
            bl = Intrinsics.areEqual((Object)fullClassName, (Object)rule);
        }
        return bl;
    }

    private final List<String> readLines(Iterable<? extends File> $this$readLines, Function1<? super File, Boolean> filterBlock) {
        Iterable $this$filterTo$iv$iv;
        Iterable list$iv$iv;
        File it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$readLines;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (File)element$iv$iv;
            boolean bl = false;
            if (it.isFile()) {
                list = CollectionsKt.listOf((Object)it);
            } else {
                File[] fileArray = it.listFiles();
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
                File[] fileArray2 = fileArray;
                list = CollectionsKt.listOf((Object[])Arrays.copyOf(fileArray2, fileArray2.length));
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filterBlock.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            list$iv$iv = FilesKt.readLines$default((File)it, null, (int)1, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final BaselineProfilePluginLogger logger_delegate$lambda$0(MergeBaselineProfileTask this$0) {
        Logger logger = this$0.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return new BaselineProfilePluginLogger(logger);
    }

    private static final boolean variantHasDependencies_delegate$lambda$1(MergeBaselineProfileTask this$0) {
        return this$0.getHasDependencies().isPresent() && (Boolean)this$0.getHasDependencies().get() != false;
    }

    private static final boolean exec$lambda$2(MergeBaselineProfileTask this$0, Warnings $this$warn) {
        Intrinsics.checkNotNullParameter((Object)$this$warn, (String)"$this$warn");
        Object object = this$0.getPrintWarningVariantHasNoBaselineProfileDependency().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private static final Integer exec$lambda$4(Pair r) {
        return r.getFirst() == RuleType.INCLUDE ? 0 : 1;
    }

    private static final Integer exec$lambda$5(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean exec$lambda$6(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)FILENAME_MATCHER_BASELINE_PROFILE, (boolean)false, (int)2, null)) return true;
        String string2 = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)FILENAME_MATCHER_STARTUP_PROFILE, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final boolean exec$lambda$7(MergeBaselineProfileTask this$0, Warnings $this$warn) {
        Intrinsics.checkNotNullParameter((Object)$this$warn, (String)"$this$warn");
        Object object = this$0.getPrintWarningNoBaselineProfileRulesGenerated().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private static final ProfileRule exec$lambda$8(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProfileRule.Companion.parse(it);
    }

    private static final boolean exec$lambda$13(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)FILENAME_MATCHER_STARTUP_PROFILE, (boolean)false, (int)2, null);
    }

    private static final boolean exec$lambda$14(MergeBaselineProfileTask this$0, Warnings $this$warn) {
        Intrinsics.checkNotNullParameter((Object)$this$warn, (String)"$this$warn");
        Object object = this$0.getPrintWarningNoStartupProfileRulesGenerated().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    private static final ProfileRule exec$lambda$15(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProfileRule.Companion.parse(it);
    }

    private static final CharSequence writeProfile$lambda$23$lambda$19(ProfileRule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUnderlying();
    }

    private static final boolean writeProfile$lambda$23$lambda$20(Warnings $this$warn) {
        Intrinsics.checkNotNullParameter((Object)$this$warn, (String)"$this$warn");
        return true;
    }

    private static final boolean writeProfile$lambda$23$lambda$22$lambda$21(Warnings $this$warn) {
        Intrinsics.checkNotNullParameter((Object)$this$warn, (String)"$this$warn");
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J}\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u001a\b\u0002\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00050\u001c0\u001b2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!Jg\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask$Companion;", "", "<init>", "()V", "MERGE_TASK_NAME", "", "COPY_TASK_NAME", "FILENAME_MATCHER_BASELINE_PROFILE", "FILENAME_MATCHER_STARTUP_PROFILE", "BASELINE_PROFILE_FILENAME", "STARTUP_PROFILE_FILENAME", "maybeRegisterForMerge", "Lorg/gradle/api/tasks/TaskProvider;", "Landroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask;", "project", "Lorg/gradle/api/Project;", "variantName", "mergeAwareTaskName", "hasDependencies", "", "library", "sourceProfilesFileCollection", "Lorg/gradle/api/file/FileCollection;", "outputDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "filterRules", "", "Lkotlin/Pair;", "Landroidx/baselineprofile/gradle/consumer/RuleType;", "isLastTask", "warnings", "Landroidx/baselineprofile/gradle/utils/Warnings;", "maybeRegisterForMerge$benchmark_baseline_profile_gradle_plugin", "maybeRegisterForCopy", "sourceDir", "maybeRegisterForCopy$benchmark_baseline_profile_gradle_plugin", "benchmark-baseline-profile-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nMergeBaselineProfileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask$Companion\n+ 2 Tasks.kt\nandroidx/baselineprofile/gradle/utils/TasksKt\n*L\n1#1,515:1\n28#2,7:516\n28#2,7:523\n*S KotlinDebug\n*F\n+ 1 MergeBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/consumer/task/MergeBaselineProfileTask$Companion\n*L\n87#1:516,7\n147#1:523,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<MergeBaselineProfileTask> maybeRegisterForMerge$benchmark_baseline_profile_gradle_plugin(@NotNull Project project, @NotNull String variantName, @NotNull String mergeAwareTaskName, boolean hasDependencies, boolean library, @NotNull FileCollection sourceProfilesFileCollection, @NotNull Provider<Directory> outputDir, @NotNull List<? extends Pair<? extends RuleType, String>> filterRules, boolean isLastTask, @NotNull Warnings warnings) {
            TaskProvider taskProvider;
            void $this$maybeRegister$iv;
            void nameParts$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)mergeAwareTaskName, (String)"mergeAwareTaskName");
            Intrinsics.checkNotNullParameter((Object)sourceProfilesFileCollection, (String)"sourceProfilesFileCollection");
            Intrinsics.checkNotNullParameter(outputDir, (String)"outputDir");
            Intrinsics.checkNotNullParameter(filterRules, (String)"filterRules");
            Intrinsics.checkNotNullParameter((Object)warnings, (String)"warnings");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            TaskContainer taskContainer2 = taskContainer;
            String[] stringArray = new String[]{MergeBaselineProfileTask.MERGE_TASK_NAME, mergeAwareTaskName, "baselineProfile"};
            Function1 configureBlock$iv = arg_0 -> Companion.maybeRegisterForMerge$lambda$0(hasDependencies, variantName, sourceProfilesFileCollection, outputDir, filterRules, library, isLastTask, warnings, arg_0);
            boolean $i$f$maybeRegister = false;
            String name$iv = UtilsKt.camelCase((String[])Arrays.copyOf(nameParts$iv, ((void)nameParts$iv).length));
            try {
                TaskProvider task$iv = $this$maybeRegister$iv.named(name$iv, MergeBaselineProfileTask.class);
                if (configureBlock$iv != null) {
                    Function1 function1 = configureBlock$iv;
                    task$iv.configure(new Action(function1){
                        private final /* synthetic */ Function1 function;
                        {
                            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                            this.function = function;
                        }

                        public final /* synthetic */ void execute(Object p0) {
                            this.function.invoke(p0);
                        }
                    });
                }
                taskProvider = task$iv;
                Intrinsics.checkNotNull((Object)taskProvider);
            }
            catch (UnknownTaskException e$iv) {
                Function1 function1 = configureBlock$iv;
                Intrinsics.checkNotNull((Object)function1);
                Function1 function12 = function1;
                TaskProvider taskProvider2 = $this$maybeRegister$iv.register(name$iv, MergeBaselineProfileTask.class, new /* invalid duplicate definition of identical inner class */);
                Intrinsics.checkNotNull((Object)taskProvider2);
                taskProvider = taskProvider2;
            }
            return taskProvider;
        }

        public static /* synthetic */ TaskProvider maybeRegisterForMerge$benchmark_baseline_profile_gradle_plugin$default(Companion companion, Project project, String string, String string2, boolean bl, boolean bl2, FileCollection fileCollection, Provider provider, List list, boolean bl3, Warnings warnings, int n, Object object) {
            if ((n & 0x80) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.maybeRegisterForMerge$benchmark_baseline_profile_gradle_plugin(project, string, string2, bl, bl2, fileCollection, (Provider<Directory>)provider, list, bl3, warnings);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TaskProvider<MergeBaselineProfileTask> maybeRegisterForCopy$benchmark_baseline_profile_gradle_plugin(@NotNull Project project, @NotNull String variantName, @NotNull String mergeAwareTaskName, boolean library, @NotNull Provider<Directory> sourceDir, @NotNull Provider<Directory> outputDir, boolean isLastTask, boolean hasDependencies, @NotNull Warnings warnings) {
            TaskProvider taskProvider;
            void $this$maybeRegister$iv;
            void nameParts$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)mergeAwareTaskName, (String)"mergeAwareTaskName");
            Intrinsics.checkNotNullParameter(sourceDir, (String)"sourceDir");
            Intrinsics.checkNotNullParameter(outputDir, (String)"outputDir");
            Intrinsics.checkNotNullParameter((Object)warnings, (String)"warnings");
            TaskContainer taskContainer = project.getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
            TaskContainer taskContainer2 = taskContainer;
            String[] stringArray = new String[]{MergeBaselineProfileTask.COPY_TASK_NAME, mergeAwareTaskName, "baselineProfileIntoSrc"};
            Function1 configureBlock$iv = arg_0 -> Companion.maybeRegisterForCopy$lambda$1(sourceDir, outputDir, library, variantName, isLastTask, hasDependencies, warnings, arg_0);
            boolean $i$f$maybeRegister = false;
            String name$iv = UtilsKt.camelCase((String[])Arrays.copyOf(nameParts$iv, ((void)nameParts$iv).length));
            try {
                TaskProvider task$iv = $this$maybeRegister$iv.named(name$iv, MergeBaselineProfileTask.class);
                if (configureBlock$iv != null) {
                    Function1 function1 = configureBlock$iv;
                    task$iv.configure(new /* invalid duplicate definition of identical inner class */);
                }
                taskProvider = task$iv;
                Intrinsics.checkNotNull((Object)taskProvider);
            }
            catch (UnknownTaskException e$iv) {
                Function1 function1 = configureBlock$iv;
                Intrinsics.checkNotNull((Object)function1);
                Function1 function12 = function1;
                TaskProvider taskProvider2 = $this$maybeRegister$iv.register(name$iv, MergeBaselineProfileTask.class, new /* invalid duplicate definition of identical inner class */);
                Intrinsics.checkNotNull((Object)taskProvider2);
                taskProvider = taskProvider2;
            }
            return taskProvider;
        }

        private static final Unit maybeRegisterForMerge$lambda$0(boolean $hasDependencies, String $variantName, FileCollection $sourceProfilesFileCollection, Provider $outputDir, List $filterRules, boolean $library, boolean $isLastTask, Warnings $warnings, MergeBaselineProfileTask task) {
            Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
            task.getHasDependencies().set((Object)$hasDependencies);
            task.getVariantName().set((Object)$variantName);
            task.getBaselineProfileFileCollection().getFrom().add($sourceProfilesFileCollection);
            task.getBaselineProfileDir().set($outputDir);
            task.getFilterRules().addAll((Iterable)$filterRules);
            task.getLibrary().set((Object)$library);
            task.getLastTask().set((Object)$isLastTask);
            task.getPrintWarningNoBaselineProfileRulesGenerated().set((Object)$warnings.getNoBaselineProfileRulesGenerated());
            task.getPrintWarningNoStartupProfileRulesGenerated().set((Object)$warnings.getNoStartupProfileRulesGenerated());
            task.getPrintWarningVariantHasNoBaselineProfileDependency().set((Object)$warnings.getVariantHasNoBaselineProfileDependency());
            return Unit.INSTANCE;
        }

        private static final Unit maybeRegisterForCopy$lambda$1(Provider $sourceDir, Provider $outputDir, boolean $library, String $variantName, boolean $isLastTask, boolean $hasDependencies, Warnings $warnings, MergeBaselineProfileTask task) {
            Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
            task.getBaselineProfileFileCollection().getFrom().add($sourceDir);
            task.getBaselineProfileDir().set($outputDir);
            task.getLibrary().set((Object)$library);
            task.getVariantName().set((Object)$variantName);
            task.getLastTask().set((Object)$isLastTask);
            task.getHasDependencies().set((Object)$hasDependencies);
            task.getPrintWarningNoBaselineProfileRulesGenerated().set((Object)$warnings.getNoBaselineProfileRulesGenerated());
            task.getPrintWarningNoStartupProfileRulesGenerated().set((Object)$warnings.getNoStartupProfileRulesGenerated());
            task.getPrintWarningVariantHasNoBaselineProfileDependency().set((Object)$warnings.getVariantHasNoBaselineProfileDependency());
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

