/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.consumer.task;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Landroidx/baselineprofile/gradle/consumer/task/ProfileRule;", "", "underlying", "", "flags", "classDescriptor", "methodDescriptor", "fullClassName", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getUnderlying", "()Ljava/lang/String;", "getFlags", "getClassDescriptor", "getMethodDescriptor", "getFullClassName", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "benchmark-baseline-profile-gradle-plugin"})
public final class ProfileRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String underlying;
    @NotNull
    private final String flags;
    @NotNull
    private final String classDescriptor;
    @Nullable
    private final String methodDescriptor;
    @NotNull
    private final String fullClassName;
    @NotNull
    private static final Regex PROFILE_RULE_REGEX = new Regex("(H?S?P?)L([^;]*);(->)?(.*)");
    @NotNull
    private static final Comparator<ProfileRule> comparator;

    public ProfileRule(@NotNull String underlying, @NotNull String flags, @NotNull String classDescriptor, @Nullable String methodDescriptor, @NotNull String fullClassName) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        this.underlying = underlying;
        this.flags = flags;
        this.classDescriptor = classDescriptor;
        this.methodDescriptor = methodDescriptor;
        this.fullClassName = fullClassName;
    }

    @NotNull
    public final String getUnderlying() {
        return this.underlying;
    }

    @NotNull
    public final String getFlags() {
        return this.flags;
    }

    @NotNull
    public final String getClassDescriptor() {
        return this.classDescriptor;
    }

    @Nullable
    public final String getMethodDescriptor() {
        return this.methodDescriptor;
    }

    @NotNull
    public final String getFullClassName() {
        return this.fullClassName;
    }

    @NotNull
    public final String component1() {
        return this.underlying;
    }

    @NotNull
    public final String component2() {
        return this.flags;
    }

    @NotNull
    public final String component3() {
        return this.classDescriptor;
    }

    @Nullable
    public final String component4() {
        return this.methodDescriptor;
    }

    @NotNull
    public final String component5() {
        return this.fullClassName;
    }

    @NotNull
    public final ProfileRule copy(@NotNull String underlying, @NotNull String flags, @NotNull String classDescriptor, @Nullable String methodDescriptor, @NotNull String fullClassName) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        Intrinsics.checkNotNullParameter((Object)fullClassName, (String)"fullClassName");
        return new ProfileRule(underlying, flags, classDescriptor, methodDescriptor, fullClassName);
    }

    public static /* synthetic */ ProfileRule copy$default(ProfileRule profileRule, String string, String string2, String string3, String string4, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = profileRule.underlying;
        }
        if ((n & 2) != 0) {
            string2 = profileRule.flags;
        }
        if ((n & 4) != 0) {
            string3 = profileRule.classDescriptor;
        }
        if ((n & 8) != 0) {
            string4 = profileRule.methodDescriptor;
        }
        if ((n & 0x10) != 0) {
            string5 = profileRule.fullClassName;
        }
        return profileRule.copy(string, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        return "ProfileRule(underlying=" + this.underlying + ", flags=" + this.flags + ", classDescriptor=" + this.classDescriptor + ", methodDescriptor=" + this.methodDescriptor + ", fullClassName=" + this.fullClassName + ")";
    }

    public int hashCode() {
        int result = this.underlying.hashCode();
        result = result * 31 + this.flags.hashCode();
        result = result * 31 + this.classDescriptor.hashCode();
        result = result * 31 + (this.methodDescriptor == null ? 0 : this.methodDescriptor.hashCode());
        result = result * 31 + this.fullClassName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileRule)) {
            return false;
        }
        ProfileRule profileRule = (ProfileRule)other;
        if (!Intrinsics.areEqual((Object)this.underlying, (Object)profileRule.underlying)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.flags, (Object)profileRule.flags)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.classDescriptor, (Object)profileRule.classDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.methodDescriptor, (Object)profileRule.methodDescriptor)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fullClassName, (Object)profileRule.fullClassName);
    }

    private static final Comparable comparator$lambda$0(ProfileRule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Comparable)((Object)it.classDescriptor);
    }

    private static final Comparable comparator$lambda$1(ProfileRule it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.methodDescriptor;
        return string != null ? (Comparable)((Object)string) : (Comparable)((Object)"");
    }

    static {
        Function1[] function1Array = new Function1[]{ProfileRule::comparator$lambda$0, ProfileRule::comparator$lambda$1};
        comparator = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Landroidx/baselineprofile/gradle/consumer/task/ProfileRule$Companion;", "", "<init>", "()V", "PROFILE_RULE_REGEX", "Lkotlin/text/Regex;", "parse", "Landroidx/baselineprofile/gradle/consumer/task/ProfileRule;", "rule", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator$benchmark_baseline_profile_gradle_plugin", "()Ljava/util/Comparator;", "benchmark-baseline-profile-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ProfileRule parse(@NotNull String rule) {
            ProfileRule profileRule;
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            MatchResult result = Regex.find$default((Regex)PROFILE_RULE_REGEX, (CharSequence)rule, (int)0, (int)2, null);
            if (result != null) {
                MatchResult.Destructured destructured = result.getDestructured();
                String flags = (String)destructured.getMatch().getGroupValues().get(1);
                String classDescriptor = (String)destructured.getMatch().getGroupValues().get(2);
                String methodDescriptor = (String)destructured.getMatch().getGroupValues().get(4);
                String[] stringArray = new String[]{"/"};
                String fullClassName = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)classDescriptor, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                profileRule = new ProfileRule(rule, flags, classDescriptor, methodDescriptor, fullClassName);
            } else {
                profileRule = null;
            }
            return profileRule;
        }

        @NotNull
        public final Comparator<ProfileRule> getComparator$benchmark_baseline_profile_gradle_plugin() {
            return comparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

