/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.producer.tasks;

import androidx.baselineprofile.gradle.producer.tasks.InstrumentationTestTaskWrapper;
import androidx.baselineprofile.gradle.utils.UtilsKt;
import com.android.build.api.variant.TestVariant;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.buildanalyzer.common.TaskCategory;
import com.google.testing.platform.proto.api.core.TestArtifactProto;
import com.google.testing.platform.proto.api.core.TestResultProto;
import com.google.testing.platform.proto.api.core.TestSuiteResultProto;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Mostly I/O bound task")
@BuildAnalyzer(primaryTaskCategory=TaskCategory.OPTIMIZATION)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Landroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "testResultDirs", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getTestResultDirs", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "testInstrumentationRunnerArguments", "Lorg/gradle/api/provider/MapProperty;", "", "", "getTestInstrumentationRunnerArguments", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "exec", "", "Companion", "benchmark-baseline-profile-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nCollectBaselineProfileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1557#2:194\n1628#2,3:195\n2632#2,3:198\n1863#2,2:201\n1368#2:203\n1454#2,5:204\n1755#2,3:209\n*S KotlinDebug\n*F\n+ 1 CollectBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask\n*L\n133#1:194\n133#1:195,3\n139#1:198,3\n190#1:201,2\n160#1:203\n160#1:204,5\n175#1:209,3\n*E\n"})
public abstract class CollectBaselineProfileTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String COLLECT_TASK_NAME = "collect";
    @NotNull
    private static final String PROP_KEY_PREFIX_INSTRUMENTATION_RUNNER_ARG = "android.testInstrumentationRunnerArguments.";
    @NotNull
    private static final String PROP_KEY_INSTRUMENTATION_RUNNER_ARG_CLASS = "android.testInstrumentationRunnerArguments.class";
    @NotNull
    private static final String GOOGLE_STORAGE_SCHEMA = "gs:";
    @NotNull
    private static final List<String> PROFILE_NAMES;
    @NotNull
    private static final List<String> PROFILE_LABELS;

    public CollectBaselineProfileTask() {
        this.setGroup("Baseline Profile");
        this.setDescription("Collects a baseline profile previously generated through integration tests.");
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract ConfigurableFileCollection getTestResultDirs();

    @Input
    @NotNull
    public abstract MapProperty<String, Object> getTestInstrumentationRunnerArguments();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void exec() {
        boolean bl;
        List testResultProtoFiles;
        boolean isPartialResult;
        block7: {
            Iterator $this$mapTo$iv$iv;
            isPartialResult = ((Map)this.getTestInstrumentationRunnerArguments().get()).containsKey(PROP_KEY_INSTRUMENTATION_RUNNER_ARG_CLASS);
            Set set = this.getTestResultDirs().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getFiles(...)");
            Iterable $this$map$iv = set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new File((File)it, "test-result.pb"));
            }
            testResultProtoFiles = (List)destination$iv$iv;
            Iterable $this$none$iv = testResultProtoFiles;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    if (!it.exists()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new GradleException("Expected test results were not found. This is most likely because there are no\ntests to run. Please check that there are ui tests to execute. You can find more\ninformation at https://d.android.com/studio/test/advanced-test-setup. To create a\nbaseline profile test instead, please check the documentation at\nhttps://d.android.com/baselineprofiles.");
        }
        Set profileFiles = SequencesKt.toSet((Sequence)SequencesKt.onEach((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)testResultProtoFiles), arg_0 -> CollectBaselineProfileTask.exec$lambda$2(this, arg_0)), CollectBaselineProfileTask::exec$lambda$3), CollectBaselineProfileTask::exec$lambda$5), CollectBaselineProfileTask::exec$lambda$6), CollectBaselineProfileTask::exec$lambda$7), CollectBaselineProfileTask::exec$lambda$9), arg_0 -> CollectBaselineProfileTask.exec$lambda$10(this, arg_0)));
        if (!isPartialResult) {
            File $i$f$none;
            File $this$exec_u24lambda_u2411 = $i$f$none = ((Directory)this.getOutputDir().get()).getAsFile();
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)$this$exec_u24lambda_u2411);
            FilesKt.deleteRecursively((File)$this$exec_u24lambda_u2411);
            $this$exec_u24lambda_u2411.mkdirs();
        }
        Iterable $this$forEach$iv = profileFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl5 = false;
            File file = ((RegularFile)this.getOutputDir().file(it.getName()).get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
            FilesKt.copyTo$default((File)it, (File)file, (boolean)true, (int)0, (int)4, null);
        }
    }

    private static final Unit exec$lambda$2(CollectBaselineProfileTask this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getLogger().info("Parsing test-result.pb in `" + it.getAbsolutePath() + "`.");
        return Unit.INSTANCE;
    }

    private static final TestSuiteResultProto.TestSuiteResult exec$lambda$3(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TestSuiteResultProto.TestSuiteResult.parseFrom((byte[])FilesKt.readBytes((File)it));
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable exec$lambda$5(TestSuiteResultProto.TestSuiteResult it) {
        void $this$flatMapTo$iv$iv;
        List list = it.getTestResultList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTestResultList(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TestResultProto.TestResult r = (TestResultProto.TestResult)element$iv$iv;
            boolean bl = false;
            List list2 = r.getOutputArtifactList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOutputArtifactList(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        List list3 = it.getOutputArtifactList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getOutputArtifactList(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean exec$lambda$6(TestArtifactProto.Artifact it) {
        if (!PROFILE_LABELS.contains(it.getLabel().getLabel())) return false;
        String string = it.getSourcePath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.startsWith$default((String)string, (String)GOOGLE_STORAGE_SCHEMA, (boolean)false, (int)2, null)) return false;
        return true;
    }

    private static final File exec$lambda$7(TestArtifactProto.Artifact it) {
        return new File(it.getSourcePath().getPath());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean exec$lambda$9(File it) {
        String n;
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"txt")) return false;
        Iterable $this$any$iv = PROFILE_NAMES;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            n = (String)element$iv;
            boolean bl = false;
            string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        } while (!StringsKt.contains$default((CharSequence)string, (CharSequence)n, (boolean)false, (int)2, null));
        return true;
    }

    private static final Unit exec$lambda$10(CollectBaselineProfileTask this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getLogger().info("Found profile file `" + it + "`.");
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"-baseline-prof-", "-startup-prof-"};
        PROFILE_NAMES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"additionaltestoutput.benchmark.trace", "firebase.toolOutput"};
        PROFILE_LABELS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask$Companion;", "", "<init>", "()V", "COLLECT_TASK_NAME", "", "PROP_KEY_PREFIX_INSTRUMENTATION_RUNNER_ARG", "PROP_KEY_INSTRUMENTATION_RUNNER_ARG_CLASS", "GOOGLE_STORAGE_SCHEMA", "PROFILE_NAMES", "", "PROFILE_LABELS", "registerForVariant", "Lorg/gradle/api/tasks/TaskProvider;", "Landroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask;", "project", "Lorg/gradle/api/Project;", "variant", "Lcom/android/build/api/variant/TestVariant;", "testTaskDependencies", "Landroidx/baselineprofile/gradle/producer/tasks/InstrumentationTestTaskWrapper;", "shouldSkipGeneration", "", "registerForVariant$benchmark_baseline_profile_gradle_plugin", "benchmark-baseline-profile-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nCollectBaselineProfileTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n1557#2:194\n1628#2,3:195\n*S KotlinDebug\n*F\n+ 1 CollectBaselineProfileTask.kt\nandroidx/baselineprofile/gradle/producer/tasks/CollectBaselineProfileTask$Companion\n*L\n93#1:194\n93#1:195,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TaskProvider<CollectBaselineProfileTask> registerForVariant$benchmark_baseline_profile_gradle_plugin(@NotNull Project project, @NotNull TestVariant variant, @NotNull List<InstrumentationTestTaskWrapper> testTaskDependencies, boolean shouldSkipGeneration) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Intrinsics.checkNotNullParameter(testTaskDependencies, (String)"testTaskDependencies");
            String flavorName = variant.getFlavorName();
            String buildType = variant.getBuildType();
            String[] stringArray = new String[]{CollectBaselineProfileTask.COLLECT_TASK_NAME, variant.getName(), "baselineProfile"};
            TaskProvider taskProvider = project.getTasks().register(UtilsKt.camelCase(stringArray), CollectBaselineProfileTask.class, arg_0 -> Companion.registerForVariant$lambda$6(arg_0 -> Companion.registerForVariant$lambda$5(project, flavorName, buildType, testTaskDependencies, shouldSkipGeneration, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(...)");
            return taskProvider;
        }

        private static final Directory registerForVariant$lambda$5$lambda$0(String $flavorName, Directory d) {
            return d.dir($flavorName);
        }

        private static final Directory registerForVariant$lambda$5$lambda$1(Function1 $tmp0, Object in) {
            return (Directory)$tmp0.invoke(in);
        }

        private static final Directory registerForVariant$lambda$5$lambda$2(String $buildType, Directory d) {
            return d.dir($buildType);
        }

        private static final Directory registerForVariant$lambda$5$lambda$3(Function1 $tmp0, Object in) {
            return (Directory)$tmp0.invoke(in);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit registerForVariant$lambda$5(Project $project, String $flavorName, String $buildType, List $testTaskDependencies, boolean $shouldSkipGeneration, CollectBaselineProfileTask it) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Provider outputDir = $project.getLayout().getBuildDirectory().dir("intermediates/baselineprofiles/");
            Object object = $flavorName;
            if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                outputDir = outputDir.map(arg_0 -> Companion.registerForVariant$lambda$5$lambda$1(arg_0 -> Companion.registerForVariant$lambda$5$lambda$0($flavorName, arg_0), arg_0));
            }
            if (!((object = (CharSequence)$buildType) == null || StringsKt.isBlank((CharSequence)object))) {
                outputDir = outputDir.map(arg_0 -> Companion.registerForVariant$lambda$5$lambda$3(arg_0 -> Companion.registerForVariant$lambda$5$lambda$2($buildType, arg_0), arg_0));
            }
            it.getOutputDir().set(outputDir);
            object = $testTaskDependencies;
            ConfigurableFileCollection configurableFileCollection = it.getTestResultDirs();
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void t;
                InstrumentationTestTaskWrapper instrumentationTestTaskWrapper = (InstrumentationTestTaskWrapper)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(t.getResultsDir());
            }
            configurableFileCollection.setFrom((Iterable)((List)destination$iv$iv));
            it.getTestInstrumentationRunnerArguments().set($project.getProviders().gradlePropertiesPrefixedBy(CollectBaselineProfileTask.PROP_KEY_PREFIX_INSTRUMENTATION_RUNNER_ARG));
            if ($shouldSkipGeneration) {
                it.setEnabled(false);
            }
            return Unit.INSTANCE;
        }

        private static final void registerForVariant$lambda$6(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

