/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.utils;

import androidx.baselineprofile.gradle.utils.Warnings;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ1\u0010\u0010\u001a\u00020\u000b2\u0017\u0010\u0011\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\u0002\b\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/baselineprofile/gradle/utils/BaselineProfilePluginLogger;", "", "logger", "Lorg/gradle/api/logging/Logger;", "<init>", "(Lorg/gradle/api/logging/Logger;)V", "warnings", "Landroidx/baselineprofile/gradle/utils/Warnings;", "suppressAllWarnings", "", "setWarnings", "", "debug", "message", "", "info", "warn", "property", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "propertyName", "error", "benchmark-baseline-profile-gradle-plugin"})
public final class BaselineProfilePluginLogger {
    @NotNull
    private final Logger logger;
    @NotNull
    private Warnings warnings;
    private boolean suppressAllWarnings;

    /*
     * WARNING - void declaration
     */
    public BaselineProfilePluginLogger(@NotNull Logger logger) {
        void $this$warnings_u24lambda_u240;
        Warnings warnings;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        Warnings warnings2 = warnings = new Warnings();
        BaselineProfilePluginLogger baselineProfilePluginLogger = this;
        boolean bl = false;
        $this$warnings_u24lambda_u240.setMaxAgpVersion(false);
        baselineProfilePluginLogger.warnings = warnings;
    }

    public final void setWarnings(@NotNull Warnings warnings) {
        Intrinsics.checkNotNullParameter((Object)warnings, (String)"warnings");
        this.warnings = warnings;
    }

    public final void suppressAllWarnings() {
        this.suppressAllWarnings = true;
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.debug(message);
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.info(message);
    }

    public final void warn(@NotNull Function1<? super Warnings, Boolean> property, @Nullable String propertyName, @NotNull String message) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.suppressAllWarnings) {
            return;
        }
        if (((Boolean)property.invoke((Object)this.warnings)).booleanValue()) {
            this.logger.warn(message);
            if (propertyName != null) {
                this.logger.warn(StringsKt.trimIndent((String)("\n\n                This warning can be disabled setting the following property:\n                baselineProfile {\n                    warnings {\n                        " + propertyName + " = false\n                    }\n                }\n            ")));
            }
        }
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.error(message);
    }
}

