/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.utils;

import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.Variant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00052\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005J\u0013\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR/\u0010\f\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u000e0\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0019"}, d2={"Landroidx/baselineprofile/gradle/utils/OnVariantBlockScheduler;", "T", "Lcom/android/build/api/variant/Variant;", "", "variantTypeName", "", "<init>", "(Ljava/lang/String;)V", "publishedVariants", "", "getPublishedVariants", "()Ljava/util/Map;", "onVariantBlocks", "", "Lkotlin/Function1;", "", "getOnVariantBlocks", "executeOrScheduleOnVariantBlock", "variantName", "block", "removeOnVariantCallback", "onVariant", "variant", "(Lcom/android/build/api/variant/Variant;)V", "assertBlockMapEmpty", "benchmark-baseline-profile-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAgpPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AgpPlugin.kt\nandroidx/baselineprofile/gradle/utils/OnVariantBlockScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,465:1\n1#2:466\n1863#3,2:467\n*S KotlinDebug\n*F\n+ 1 AgpPlugin.kt\nandroidx/baselineprofile/gradle/utils/OnVariantBlockScheduler\n*L\n452#1:467,2\n*E\n"})
final class OnVariantBlockScheduler<T extends Variant> {
    @NotNull
    private final String variantTypeName;
    @NotNull
    private final Map<String, T> publishedVariants;
    @NotNull
    private final Map<String, List<Function1<T, Unit>>> onVariantBlocks;

    public OnVariantBlockScheduler(@NotNull String variantTypeName) {
        Intrinsics.checkNotNullParameter((Object)variantTypeName, (String)"variantTypeName");
        this.variantTypeName = variantTypeName;
        this.publishedVariants = new LinkedHashMap();
        this.onVariantBlocks = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, T> getPublishedVariants() {
        return this.publishedVariants;
    }

    @NotNull
    public final Map<String, List<Function1<T, Unit>>> getOnVariantBlocks() {
        return this.onVariantBlocks;
    }

    public final void executeOrScheduleOnVariantBlock(@NotNull String variantName, @NotNull Function1<? super T, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.publishedVariants.containsKey(variantName)) {
            Variant variant = (Variant)this.publishedVariants.get(variantName);
            if (variant != null) {
                Variant it = variant;
                boolean bl = false;
                block.invoke((Object)it);
            }
        } else {
            List list = this.onVariantBlocks.computeIfAbsent(variantName, arg_0 -> OnVariantBlockScheduler.executeOrScheduleOnVariantBlock$lambda$2(OnVariantBlockScheduler::executeOrScheduleOnVariantBlock$lambda$1, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"computeIfAbsent(...)");
            ((Collection)list).add(block);
        }
    }

    public final void removeOnVariantCallback(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        this.onVariantBlocks.remove(variantName);
    }

    public final void onVariant(@NotNull T variant) {
        block2: {
            List<Function1<T, Unit>> list;
            Intrinsics.checkNotNullParameter(variant, (String)"variant");
            if (this.publishedVariants.containsKey(((ComponentIdentity)variant).getName())) {
                throw new IllegalStateException("A variant was published more than once. This can only happen if the AgpPlugin base\nclass is used and an additional onVariants callback is directly registered with the\nbase components.");
            }
            this.publishedVariants.put(((ComponentIdentity)variant).getName(), variant);
            List<Function1<T, Unit>> list2 = this.onVariantBlocks.remove(((ComponentIdentity)variant).getName());
            if (list2 == null) break block2;
            List<Function1<T, Unit>> $this$onVariant_u24lambda_u244 = list = list2;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$onVariant_u24lambda_u244;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function1 b = (Function1)element$iv;
                boolean bl2 = false;
                b.invoke(variant);
            }
            $this$onVariant_u24lambda_u244.clear();
        }
    }

    public final void assertBlockMapEmpty() {
        if (this.onVariantBlocks.isEmpty()) {
            return;
        }
        String variantNames = "[`" + CollectionsKt.joinToString$default((Iterable)MapsKt.toList(this.onVariantBlocks), (CharSequence)"`, `", null, null, (int)0, null, OnVariantBlockScheduler::assertBlockMapEmpty$lambda$5, (int)30, null) + "`]";
        throw new IllegalStateException("Callbacks for " + this.variantTypeName + " variants " + variantNames + " were not executed.");
    }

    private static final List executeOrScheduleOnVariantBlock$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List executeOrScheduleOnVariantBlock$lambda$2(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CharSequence assertBlockMapEmpty$lambda$5(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getFirst();
    }
}

