/*
 * Decompiled with CFR 0.152.
 */
package androidx.baselineprofile.gradle.utils;

import androidx.baselineprofile.gradle.utils.AgpKt;
import androidx.baselineprofile.gradle.utils.AgpPluginKt;
import androidx.baselineprofile.gradle.utils.GenerateDummyBaselineProfileTask;
import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.Variant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/baselineprofile/gradle/utils/R8Utils;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "setRulesRewriteForVariantEnabled", "", "variant", "Lcom/android/build/api/variant/Variant;", "value", "", "setDexLayoutOptimizationEnabled", "Companion", "benchmark-baseline-profile-gradle-plugin"})
public final class R8Utils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String PROPERTY_R8_REWRITE_BASELINE_PROFILE_RULES = "android.experimental.art-profile-r8-rewriting";
    @NotNull
    private static final String PROPERTY_R8_DEX_LAYOUT_OPTIMIZATION = "android.experimental.r8.dex-startup-optimization";

    public R8Utils(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void setRulesRewriteForVariantEnabled(@NotNull Variant variant, boolean value) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (AgpKt.agpVersion(this.project).compareTo(new AndroidPluginVersion(8, 1, 0).alpha(8)) < 0) {
            if (!AgpPluginKt.isGradleSyncRunning(this.project)) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n                Unable to set baseline profile rules rewrite property in module `" + this.project.getPath() + "`\n                due to minimum AGP version requirement not met. This functionality requires at\n                least AGP version 8.1.0. Please check your module build.gradle file and ensure\n                the property `baselineProfileRulesRewrite` is not set.\n                ")));
            }
            return;
        }
        if (value) {
            GenerateDummyBaselineProfileTask.Companion.setupForVariant$benchmark_baseline_profile_gradle_plugin(this.project, variant);
        }
        variant.getExperimentalProperties().put((Object)PROPERTY_R8_REWRITE_BASELINE_PROFILE_RULES, (Object)value);
    }

    public final void setDexLayoutOptimizationEnabled(@NotNull Variant variant, boolean value) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        if (AgpKt.agpVersion(this.project).compareTo(new AndroidPluginVersion(8, 1, 0).alpha(11)) < 0 && !AgpPluginKt.isGradleSyncRunning(this.project)) {
            throw new IllegalStateException(StringsKt.trimIndent((String)("\n                Unable to set dex layout optimization property in module `" + this.project.getPath() + "` due to\n                minimum AGP version requirement not met. This functionality requires at least AGP\n                version 8.1.0. Please check your module build.gradle file and ensure the property\n                `dexLayoutOptimization` is not set.\n                ")));
        }
        variant.getExperimentalProperties().put((Object)PROPERTY_R8_DEX_LAYOUT_OPTIMIZATION, (Object)value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/baselineprofile/gradle/utils/R8Utils$Companion;", "", "<init>", "()V", "PROPERTY_R8_REWRITE_BASELINE_PROFILE_RULES", "", "PROPERTY_R8_DEX_LAYOUT_OPTIMIZATION", "benchmark-baseline-profile-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

