/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_AudioSpec;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AutoValue
public abstract class AudioSpec {
    public static final int SOURCE_FORMAT_AUTO = -1;
    public static final int SOURCE_FORMAT_PCM_16BIT = 2;
    public static final int CHANNEL_COUNT_AUTO = -1;
    public static final int CHANNEL_COUNT_NONE = 0;
    public static final int CHANNEL_COUNT_MONO = 1;
    public static final int CHANNEL_COUNT_STEREO = 2;
    public static final int SOURCE_AUTO = -1;
    public static final int SOURCE_CAMCORDER = 5;
    public static final @NonNull Range<Integer> BITRATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    public static final @NonNull Range<Integer> SAMPLE_RATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    public static final AudioSpec NO_AUDIO = AudioSpec.builder().setChannelCount(0).build();

    AudioSpec() {
    }

    public static @NonNull Builder builder() {
        return new AutoValue_AudioSpec.Builder().setSourceFormat(-1).setSource(-1).setChannelCount(-1).setBitrate(BITRATE_RANGE_AUTO).setSampleRate(SAMPLE_RATE_RANGE_AUTO);
    }

    public abstract @NonNull Range<Integer> getBitrate();

    public abstract int getSourceFormat();

    public abstract int getSource();

    public abstract @NonNull Range<Integer> getSampleRate();

    public abstract int getChannelCount();

    public abstract @NonNull Builder toBuilder();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract @NonNull Builder setBitrate(@NonNull Range<Integer> var1);

        public abstract @NonNull Builder setSourceFormat(int var1);

        public abstract @NonNull Builder setSource(int var1);

        public abstract @NonNull Builder setSampleRate(@NonNull Range<Integer> var1);

        public abstract @NonNull Builder setChannelCount(int var1);

        public abstract @NonNull AudioSpec build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Source {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ChannelCount {
    }
}

