/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.VideoSpec;
import org.jspecify.annotations.NonNull;

final class AutoValue_VideoSpec
extends VideoSpec {
    private final @NonNull QualitySelector qualitySelector;
    private final int encodeFrameRate;
    private final @NonNull Range<Integer> bitrate;
    private final int aspectRatio;

    private AutoValue_VideoSpec(@NonNull QualitySelector qualitySelector, int encodeFrameRate, @NonNull Range<Integer> bitrate, int aspectRatio) {
        this.qualitySelector = qualitySelector;
        this.encodeFrameRate = encodeFrameRate;
        this.bitrate = bitrate;
        this.aspectRatio = aspectRatio;
    }

    @Override
    public @NonNull QualitySelector getQualitySelector() {
        return this.qualitySelector;
    }

    @Override
    public int getEncodeFrameRate() {
        return this.encodeFrameRate;
    }

    @Override
    public @NonNull Range<Integer> getBitrate() {
        return this.bitrate;
    }

    @Override
    int getAspectRatio() {
        return this.aspectRatio;
    }

    public String toString() {
        return "VideoSpec{qualitySelector=" + this.qualitySelector + ", encodeFrameRate=" + this.encodeFrameRate + ", bitrate=" + this.bitrate + ", aspectRatio=" + this.aspectRatio + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof VideoSpec) {
            VideoSpec that = (VideoSpec)o;
            return this.qualitySelector.equals(that.getQualitySelector()) && this.encodeFrameRate == that.getEncodeFrameRate() && this.bitrate.equals(that.getBitrate()) && this.aspectRatio == that.getAspectRatio();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.qualitySelector.hashCode();
        h$ *= 1000003;
        h$ ^= this.encodeFrameRate;
        h$ *= 1000003;
        h$ ^= this.bitrate.hashCode();
        h$ *= 1000003;
        return h$ ^= this.aspectRatio;
    }

    @Override
    public VideoSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends VideoSpec.Builder {
        private @NonNull QualitySelector qualitySelector;
        private Integer encodeFrameRate;
        private @NonNull Range<Integer> bitrate;
        private Integer aspectRatio;

        Builder() {
        }

        private Builder(VideoSpec source) {
            this.qualitySelector = source.getQualitySelector();
            this.encodeFrameRate = source.getEncodeFrameRate();
            this.bitrate = source.getBitrate();
            this.aspectRatio = source.getAspectRatio();
        }

        @Override
        public VideoSpec.Builder setQualitySelector(@NonNull QualitySelector qualitySelector) {
            if (qualitySelector == null) {
                throw new NullPointerException("Null qualitySelector");
            }
            this.qualitySelector = qualitySelector;
            return this;
        }

        @Override
        public VideoSpec.Builder setEncodeFrameRate(int encodeFrameRate) {
            this.encodeFrameRate = encodeFrameRate;
            return this;
        }

        @Override
        public VideoSpec.Builder setBitrate(@NonNull Range<Integer> bitrate) {
            if (bitrate == null) {
                throw new NullPointerException("Null bitrate");
            }
            this.bitrate = bitrate;
            return this;
        }

        @Override
        VideoSpec.Builder setAspectRatio(int aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        @Override
        public VideoSpec build() {
            String missing = "";
            if (this.qualitySelector == null) {
                missing = missing + " qualitySelector";
            }
            if (this.encodeFrameRate == null) {
                missing = missing + " encodeFrameRate";
            }
            if (this.bitrate == null) {
                missing = missing + " bitrate";
            }
            if (this.aspectRatio == null) {
                missing = missing + " aspectRatio";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_VideoSpec(this.qualitySelector, this.encodeFrameRate, this.bitrate, this.aspectRatio);
        }
    }
}

