/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.RestrictTo;
import androidx.camera.core.Preview;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.video.ExperimentalHighSpeedVideo;
import androidx.camera.video.Recorder;
import androidx.camera.video.VideoCapture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B;\b\u0007\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\u0015\u001a\u00020\u00162\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\b8WX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Landroidx/camera/video/HighSpeedVideoSessionConfig;", "Landroidx/camera/core/SessionConfig;", "videoCapture", "Landroidx/camera/video/VideoCapture;", "preview", "Landroidx/camera/core/Preview;", "frameRateRange", "Landroid/util/Range;", "", "isSlowMotionEnabled", "", "<init>", "(Landroidx/camera/video/VideoCapture;Landroidx/camera/core/Preview;Landroid/util/Range;Z)V", "getVideoCapture", "()Landroidx/camera/video/VideoCapture;", "getPreview", "()Landroidx/camera/core/Preview;", "()Z", "sessionType", "getSessionType", "()I", "validateSettingsOrThrow", "", "Builder", "Companion", "camera-video_release"})
@ExperimentalHighSpeedVideo
public final class HighSpeedVideoSessionConfig
extends SessionConfig {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final VideoCapture<?> videoCapture;
    @Nullable
    private final Preview preview;
    private final boolean isSlowMotionEnabled;
    private final int sessionType;
    private static final int SLOW_MOTION_ENCODE_FRAME_RATE = 30;

    @JvmOverloads
    public HighSpeedVideoSessionConfig(@NotNull VideoCapture<?> videoCapture, @Nullable Preview preview, @NotNull Range<Integer> frameRateRange, boolean isSlowMotionEnabled) {
        Intrinsics.checkNotNullParameter(videoCapture, (String)"videoCapture");
        Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
        Object[] objectArray = new UseCase[]{videoCapture, preview};
        super(CollectionsKt.listOfNotNull((Object[])objectArray), null, null, frameRateRange, null, null, 54, null);
        this.videoCapture = videoCapture;
        this.preview = preview;
        this.isSlowMotionEnabled = isSlowMotionEnabled;
        this.sessionType = 1;
        this.validateSettingsOrThrow(this.videoCapture, this.preview);
        if (this.isSlowMotionEnabled) {
            Object obj = this.videoCapture.getOutput();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type androidx.camera.video.Recorder");
            ((Recorder)obj).setVideoEncodingFrameRate(30);
        }
    }

    public /* synthetic */ HighSpeedVideoSessionConfig(VideoCapture videoCapture, Preview preview, Range range, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            preview = null;
        }
        if ((n & 4) != 0) {
            range = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(videoCapture, preview, (Range<Integer>)range, bl);
    }

    @NotNull
    public final VideoCapture<?> getVideoCapture() {
        return this.videoCapture;
    }

    @Nullable
    public final Preview getPreview() {
        return this.preview;
    }

    public final boolean isSlowMotionEnabled() {
        return this.isSlowMotionEnabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getSessionType() {
        return this.sessionType;
    }

    private final void validateSettingsOrThrow(VideoCapture<?> videoCapture, Preview preview) {
        if (!(videoCapture.getMirrorMode() == 0)) {
            boolean $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$42 = false;
            String $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$42 = "VideoCapture.Builder.setMirrorMode() is not allowed for high-speed video.";
            throw new IllegalArgumentException($i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$42.toString());
        }
        if (!Intrinsics.areEqual(videoCapture.getTargetFrameRate(), (Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
            boolean $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$52 = false;
            String $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$52 = "VideoCapture.Builder.setTargetFrameRate() is not allowed for high-speed video.";
            throw new IllegalArgumentException($i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$52.toString());
        }
        if (preview != null) {
            if (!Intrinsics.areEqual((Object)preview.getTargetFrameRate(), (Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                boolean $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$62 = false;
                String $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$62 = "Preview.Builder.setTargetFrameRate() is not allowed for high-speed video.";
                throw new IllegalArgumentException($i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$62.toString());
            }
            UseCaseConfig useCaseConfig = preview.getCurrentConfig();
            Intrinsics.checkNotNull((Object)useCaseConfig, (String)"null cannot be cast to non-null type androidx.camera.core.impl.ImageOutputConfig");
            ImageOutputConfig previewOutputConfig = (ImageOutputConfig)useCaseConfig;
            boolean bl = false;
            if (!(previewOutputConfig.getResolutionSelector(null) == null)) {
                boolean $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$4$42 = false;
                String $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$4$42 = "Preview.Builder.setResolutionSelector() is not allowed for high-speed video.";
                throw new IllegalArgumentException($i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$4$42.toString());
            }
            if (!(previewOutputConfig.getTargetResolution(null) == null)) {
                boolean $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$4$52 = false;
                String $i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$4$52 = "Preview.Builder.setTargetResolution() is not allowed for high-speed video.";
                throw new IllegalArgumentException($i$a$-require-HighSpeedVideoSessionConfig$validateSettingsOrThrow$4$52.toString());
            }
            if (!(!previewOutputConfig.hasTargetAspectRatio())) {
                boolean bl2 = false;
                String string = "Preview.Builder.setTargetAspectRatio() is not allowed for high-speed video.";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @JvmOverloads
    public HighSpeedVideoSessionConfig(@NotNull VideoCapture<?> videoCapture, @Nullable Preview preview, @NotNull Range<Integer> frameRateRange) {
        Intrinsics.checkNotNullParameter(videoCapture, (String)"videoCapture");
        Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
        this(videoCapture, preview, frameRateRange, false, 8, null);
    }

    @JvmOverloads
    public HighSpeedVideoSessionConfig(@NotNull VideoCapture<?> videoCapture, @Nullable Preview preview) {
        Intrinsics.checkNotNullParameter(videoCapture, (String)"videoCapture");
        this(videoCapture, preview, null, false, 12, null);
    }

    @JvmOverloads
    public HighSpeedVideoSessionConfig(@NotNull VideoCapture<?> videoCapture) {
        Intrinsics.checkNotNullParameter(videoCapture, (String)"videoCapture");
        this(videoCapture, null, null, false, 14, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\fJ\u0014\u0010\u0010\u001a\u00020\u00002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010\u0011\u001a\u00020\u0012R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/camera/video/HighSpeedVideoSessionConfig$Builder;", "", "videoCapture", "Landroidx/camera/video/VideoCapture;", "<init>", "(Landroidx/camera/video/VideoCapture;)V", "preview", "Landroidx/camera/core/Preview;", "frameRateRange", "Landroid/util/Range;", "", "isSlowMotionEnabled", "", "setPreview", "setSlowMotionEnabled", "enabled", "setFrameRateRange", "build", "Landroidx/camera/video/HighSpeedVideoSessionConfig;", "camera-video_release"})
    public static final class Builder {
        @NotNull
        private final VideoCapture<?> videoCapture;
        @Nullable
        private Preview preview;
        @NotNull
        private Range<Integer> frameRateRange;
        private boolean isSlowMotionEnabled;

        public Builder(@NotNull VideoCapture<?> videoCapture) {
            Intrinsics.checkNotNullParameter(videoCapture, (String)"videoCapture");
            this.videoCapture = videoCapture;
            Range range = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"FRAME_RATE_RANGE_UNSPECIFIED");
            this.frameRateRange = range;
        }

        @NotNull
        public final Builder setPreview(@Nullable Preview preview) {
            this.preview = preview;
            return this;
        }

        @NotNull
        public final Builder setSlowMotionEnabled(boolean enabled) {
            this.isSlowMotionEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setFrameRateRange(@NotNull Range<Integer> frameRateRange) {
            Intrinsics.checkNotNullParameter(frameRateRange, (String)"frameRateRange");
            this.frameRateRange = frameRateRange;
            return this;
        }

        @NotNull
        public final HighSpeedVideoSessionConfig build() {
            return new HighSpeedVideoSessionConfig(this.videoCapture, this.preview, this.frameRateRange, this.isSlowMotionEnabled);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/camera/video/HighSpeedVideoSessionConfig$Companion;", "", "<init>", "()V", "SLOW_MOTION_ENCODE_FRAME_RATE", "", "camera-video_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

