/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.annotation.SuppressLint;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.AutoValue_MediaSpec;
import androidx.camera.video.VideoSpec;
import androidx.core.util.Consumer;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AutoValue
public abstract class MediaSpec {
    private static final String AUDIO_ENCODER_MIME_MPEG4_DEFAULT = "audio/mp4a-latm";
    private static final String AUDIO_ENCODER_MIME_WEBM_DEFAULT = "audio/vorbis";
    private static final String VIDEO_ENCODER_MIME_MPEG4_DEFAULT = "video/avc";
    private static final String VIDEO_ENCODER_MIME_WEBM_DEFAULT = "video/x-vnd.on2.vp8";
    private static final int AAC_DEFAULT_PROFILE = 2;
    public static final int OUTPUT_FORMAT_AUTO = -1;
    public static final int OUTPUT_FORMAT_MPEG_4 = 0;
    public static final int OUTPUT_FORMAT_WEBM = 1;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @NonNull String outputFormatToAudioMime(int outputFormat) {
        switch (outputFormat) {
            case 1: {
                return AUDIO_ENCODER_MIME_WEBM_DEFAULT;
            }
        }
        return AUDIO_ENCODER_MIME_MPEG4_DEFAULT;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static int outputFormatToAudioProfile(int outputFormat) {
        String audioMime = MediaSpec.outputFormatToAudioMime(outputFormat);
        if (Objects.equals(audioMime, AUDIO_ENCODER_MIME_MPEG4_DEFAULT)) {
            return 2;
        }
        return -1;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @NonNull String outputFormatToVideoMime(int outputFormat) {
        switch (outputFormat) {
            case 1: {
                return VIDEO_ENCODER_MIME_WEBM_DEFAULT;
            }
        }
        return VIDEO_ENCODER_MIME_MPEG4_DEFAULT;
    }

    static int outputFormatToMuxerFormat(int outputFormat) {
        switch (outputFormat) {
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    MediaSpec() {
    }

    public abstract @NonNull VideoSpec getVideoSpec();

    public abstract @NonNull AudioSpec getAudioSpec();

    public abstract int getOutputFormat();

    public static @NonNull Builder builder() {
        return new AutoValue_MediaSpec.Builder().setOutputFormat(-1).setAudioSpec(AudioSpec.builder().build()).setVideoSpec(VideoSpec.builder().build());
    }

    public abstract @NonNull Builder toBuilder();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract @NonNull Builder setAudioSpec(@NonNull AudioSpec var1);

        public @NonNull Builder configureAudio(@NonNull Consumer<AudioSpec.Builder> configBlock) {
            AudioSpec.Builder audioSpecBuilder = this.getAudioSpec().toBuilder();
            configBlock.accept((Object)audioSpecBuilder);
            this.setAudioSpec(audioSpecBuilder.build());
            return this;
        }

        @SuppressLint(value={"KotlinPropertyAccess"})
        abstract AudioSpec getAudioSpec();

        public abstract @NonNull Builder setVideoSpec(@NonNull VideoSpec var1);

        public @NonNull Builder configureVideo(@NonNull Consumer<VideoSpec.Builder> configBlock) {
            VideoSpec.Builder videoSpecBuilder = this.getVideoSpec().toBuilder();
            configBlock.accept((Object)videoSpecBuilder);
            this.setVideoSpec(videoSpecBuilder.build());
            return this;
        }

        @SuppressLint(value={"KotlinPropertyAccess"})
        abstract VideoSpec getVideoSpec();

        public abstract @NonNull Builder setOutputFormat(int var1);

        public abstract @NonNull MediaSpec build();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface OutputFormat {
    }
}

