/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import androidx.camera.video.AutoValue_MediaStoreOutputOptions_MediaStoreOutputOptionsInternal;
import androidx.camera.video.OutputOptions;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MediaStoreOutputOptions
extends OutputOptions {
    public static final @NonNull ContentValues EMPTY_CONTENT_VALUES = new ContentValues();
    private final MediaStoreOutputOptionsInternal mMediaStoreOutputOptionsInternal;

    MediaStoreOutputOptions(@NonNull MediaStoreOutputOptionsInternal mediaStoreOutputOptionsInternal) {
        super(mediaStoreOutputOptionsInternal);
        this.mMediaStoreOutputOptionsInternal = mediaStoreOutputOptionsInternal;
    }

    public @NonNull ContentResolver getContentResolver() {
        return this.mMediaStoreOutputOptionsInternal.getContentResolver();
    }

    public @NonNull Uri getCollectionUri() {
        return this.mMediaStoreOutputOptionsInternal.getCollectionUri();
    }

    public @NonNull ContentValues getContentValues() {
        return this.mMediaStoreOutputOptionsInternal.getContentValues();
    }

    public @NonNull String toString() {
        return this.mMediaStoreOutputOptionsInternal.toString().replaceFirst("MediaStoreOutputOptionsInternal", "MediaStoreOutputOptions");
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaStoreOutputOptions)) {
            return false;
        }
        return this.mMediaStoreOutputOptionsInternal.equals(((MediaStoreOutputOptions)o).mMediaStoreOutputOptionsInternal);
    }

    public int hashCode() {
        return this.mMediaStoreOutputOptionsInternal.hashCode();
    }

    @AutoValue
    static abstract class MediaStoreOutputOptionsInternal
    extends OutputOptions.OutputOptionsInternal {
        MediaStoreOutputOptionsInternal() {
        }

        abstract @NonNull ContentResolver getContentResolver();

        abstract @NonNull Uri getCollectionUri();

        abstract @NonNull ContentValues getContentValues();

        @AutoValue.Builder
        static abstract class Builder
        extends OutputOptions.OutputOptionsInternal.Builder<Builder> {
            Builder() {
            }

            abstract @NonNull Builder setContentResolver(@NonNull ContentResolver var1);

            abstract @NonNull Builder setCollectionUri(@NonNull Uri var1);

            abstract @NonNull Builder setContentValues(@NonNull ContentValues var1);

            @Override
            abstract @NonNull MediaStoreOutputOptionsInternal build();
        }
    }

    public static final class Builder
    extends OutputOptions.Builder<MediaStoreOutputOptions, Builder> {
        private final MediaStoreOutputOptionsInternal.Builder mInternalBuilder;

        public Builder(@NonNull ContentResolver contentResolver, @NonNull Uri collectionUri) {
            super(new AutoValue_MediaStoreOutputOptions_MediaStoreOutputOptionsInternal.Builder());
            Preconditions.checkNotNull((Object)contentResolver, (Object)"Content resolver can't be null.");
            Preconditions.checkNotNull((Object)collectionUri, (Object)"Collection Uri can't be null.");
            this.mInternalBuilder = (MediaStoreOutputOptionsInternal.Builder)this.mRootInternalBuilder;
            this.mInternalBuilder.setContentResolver(contentResolver).setCollectionUri(collectionUri).setContentValues(EMPTY_CONTENT_VALUES);
        }

        public @NonNull Builder setContentValues(@NonNull ContentValues contentValues) {
            Preconditions.checkNotNull((Object)contentValues, (Object)"Content values can't be null.");
            this.mInternalBuilder.setContentValues(contentValues);
            return this;
        }

        @Override
        public @NonNull MediaStoreOutputOptions build() {
            return new MediaStoreOutputOptions(this.mInternalBuilder.build());
        }
    }
}

