/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.content.Context;
import androidx.annotation.CheckResult;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.utils.ContextUtil;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.video.ExperimentalPersistentRecording;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.Recorder;
import androidx.camera.video.Recording;
import androidx.camera.video.VideoRecordEvent;
import androidx.core.content.PermissionChecker;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0003H\u0001J\b\u0010\u0015\u001a\u00020\u0005H\u0001J\b\u0010\u0016\u001a\u00020\u0007H\u0001J\n\u0010\u0017\u001a\u0004\u0018\u00010\u000fH\u0001J\u0010\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0001J\b\u0010\u0012\u001a\u00020\u0011H\u0001J\b\u0010\u0013\u001a\u00020\u0011H\u0001J\u0012\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u001a\u001a\u00020\u0011H\u0007J\b\u0010\u001b\u001a\u00020\u0000H\u0007J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u001c\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0087@\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/camera/video/PendingRecording;", "", "context", "Landroid/content/Context;", "recorder", "Landroidx/camera/video/Recorder;", "outputOptions", "Landroidx/camera/video/OutputOptions;", "<init>", "(Landroid/content/Context;Landroidx/camera/video/Recorder;Landroidx/camera/video/OutputOptions;)V", "applicationContext", "eventListener", "Landroidx/core/util/Consumer;", "Landroidx/camera/video/VideoRecordEvent;", "listenerExecutor", "Ljava/util/concurrent/Executor;", "isAudioEnabled", "", "isAudioInitialMuted", "isPersistent", "getApplicationContext", "getRecorder", "getOutputOptions", "getListenerExecutor", "getEventListener", "withAudioEnabled", "initialMuted", "asPersistentRecording", "start", "Landroidx/camera/video/Recording;", "listener", "(Landroidx/core/util/Consumer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "camera-video_release"})
@SourceDebugExtension(value={"SMAP\nPendingRecording.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PendingRecording.kt\nandroidx/camera/video/PendingRecording\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n*L\n1#1,253:1\n326#2:254\n*S KotlinDebug\n*F\n+ 1 PendingRecording.kt\nandroidx/camera/video/PendingRecording\n*L\n248#1:254\n*E\n"})
public final class PendingRecording {
    @NotNull
    private final Recorder recorder;
    @NotNull
    private final OutputOptions outputOptions;
    @NotNull
    private final Context applicationContext;
    @Nullable
    private Consumer<VideoRecordEvent> eventListener;
    @Nullable
    private Executor listenerExecutor;
    private boolean isAudioEnabled;
    private boolean isAudioInitialMuted;
    private boolean isPersistent;

    public PendingRecording(@NotNull Context context, @NotNull Recorder recorder, @NotNull OutputOptions outputOptions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        Intrinsics.checkNotNullParameter((Object)outputOptions, (String)"outputOptions");
        this.recorder = recorder;
        this.outputOptions = outputOptions;
        Context context2 = ContextUtil.getApplicationContext((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getApplicationContext(...)");
        this.applicationContext = context2;
    }

    @JvmName(name="getApplicationContext")
    @NotNull
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    @JvmName(name="getRecorder")
    @NotNull
    public final Recorder getRecorder() {
        return this.recorder;
    }

    @JvmName(name="getOutputOptions")
    @NotNull
    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    @JvmName(name="getListenerExecutor")
    @Nullable
    public final Executor getListenerExecutor() {
        return this.listenerExecutor;
    }

    @JvmName(name="getEventListener")
    @Nullable
    public final Consumer<VideoRecordEvent> getEventListener() {
        return this.eventListener;
    }

    @JvmName(name="isAudioEnabled")
    public final boolean isAudioEnabled() {
        return this.isAudioEnabled;
    }

    @JvmName(name="isAudioInitialMuted")
    public final boolean isAudioInitialMuted() {
        return this.isAudioInitialMuted;
    }

    @JvmName(name="isPersistent")
    public final boolean isPersistent() {
        return this.isPersistent;
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @JvmOverloads
    @NotNull
    public final PendingRecording withAudioEnabled(boolean initialMuted) {
        if (PermissionChecker.checkSelfPermission((Context)this.applicationContext, (String)"android.permission.RECORD_AUDIO") == -1) {
            throw new SecurityException("Attempted to enable audio for recording but application does not have RECORD_AUDIO permission granted.");
        }
        Preconditions.checkState((boolean)this.recorder.isAudioSupported(), (String)"The Recorder this recording is associated to doesn't support audio.");
        this.isAudioEnabled = true;
        this.isAudioInitialMuted = initialMuted;
        return this;
    }

    public static /* synthetic */ PendingRecording withAudioEnabled$default(PendingRecording pendingRecording, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return pendingRecording.withAudioEnabled(bl);
    }

    @ExperimentalPersistentRecording
    @NotNull
    public final PendingRecording asPersistentRecording() {
        this.isPersistent = true;
        return this;
    }

    @CheckResult
    @NotNull
    public final Recording start(@NotNull Executor listenerExecutor, @NotNull Consumer<VideoRecordEvent> listener) {
        Intrinsics.checkNotNullParameter((Object)listenerExecutor, (String)"listenerExecutor");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Preconditions.checkNotNull((Object)listenerExecutor, (Object)"Listener Executor can't be null.");
        Preconditions.checkNotNull(listener, (Object)"Event listener can't be null");
        this.listenerExecutor = listenerExecutor;
        this.eventListener = listener;
        Recording recording = this.recorder.start(this);
        Intrinsics.checkNotNullExpressionValue((Object)recording, (String)"start(...)");
        return recording;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final Object start(@NotNull Consumer<VideoRecordEvent> listener, @NotNull Continuation<? super Recording> $completion) {
        Executor executor;
        CoroutineDispatcher coroutineDispatcher;
        boolean $i$f$currentCoroutineContext = false;
        Object object = $completion.getContext().get((CoroutineContext.Key)ContinuationInterceptor.Key);
        CoroutineDispatcher coroutineDispatcher2 = coroutineDispatcher = object instanceof CoroutineDispatcher ? (CoroutineDispatcher)object : null;
        if (coroutineDispatcher != null && (object = ExecutorsKt.asExecutor((CoroutineDispatcher)coroutineDispatcher)) != null) {
            executor = object;
        } else {
            Executor executor2 = CameraXExecutors.directExecutor();
            executor = executor2;
            Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"directExecutor(...)");
        }
        Executor callbackExecutor = executor;
        return this.start(callbackExecutor, listener);
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    @JvmOverloads
    @NotNull
    public final PendingRecording withAudioEnabled() {
        return PendingRecording.withAudioEnabled$default(this, false, 1, null);
    }
}

