/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_Quality_ConstantQuality;
import com.google.auto.value.AutoValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public class Quality {
    public static final @NonNull Quality SD = ConstantQuality.of(4, 2002, "SD", Collections.unmodifiableList(Arrays.asList(new Size(720, 480), new Size(640, 480))));
    public static final @NonNull Quality HD = ConstantQuality.of(5, 2003, "HD", Collections.singletonList(new Size(1280, 720)));
    public static final @NonNull Quality FHD = ConstantQuality.of(6, 2004, "FHD", Collections.singletonList(new Size(1920, 1080)));
    public static final @NonNull Quality UHD = ConstantQuality.of(8, 2005, "UHD", Collections.singletonList(new Size(3840, 2160)));
    public static final @NonNull Quality LOWEST = ConstantQuality.of(0, 2000, "LOWEST", Collections.emptyList());
    public static final @NonNull Quality HIGHEST = ConstantQuality.of(1, 2001, "HIGHEST", Collections.emptyList());
    static final Quality NONE = ConstantQuality.of(-1, -1, "NONE", Collections.emptyList());
    private static final Set<Quality> QUALITIES = new HashSet<Quality>(Arrays.asList(LOWEST, HIGHEST, SD, HD, FHD, UHD));
    private static final List<Quality> QUALITIES_ORDER_BY_SIZE = Arrays.asList(UHD, FHD, HD, SD);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int QUALITY_SOURCE_REGULAR = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final int QUALITY_SOURCE_HIGH_SPEED = 2;

    private Quality() {
    }

    static boolean containsQuality(@NonNull Quality quality) {
        return QUALITIES.contains(quality);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @NonNull List<Quality> getSortedQualities() {
        return new ArrayList<Quality>(QUALITIES_ORDER_BY_SIZE);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue
    public static abstract class ConstantQuality
    extends Quality {
        static ConstantQuality of(int value, int highSpeedValue, @NonNull String name, @NonNull List<Size> typicalSizes) {
            return new AutoValue_Quality_ConstantQuality(value, highSpeedValue, name, typicalSizes);
        }

        abstract int getValue();

        abstract int getHighSpeedValue();

        public abstract @NonNull String getName();

        public abstract @NonNull List<Size> getTypicalSizes();

        public int getQualityValue(int qualitySource) {
            switch (qualitySource) {
                case 1: {
                    return this.getValue();
                }
                case 2: {
                    return this.getHighSpeedValue();
                }
            }
            throw new AssertionError((Object)("Unknown quality source: " + qualitySource));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface QualitySource {
    }
}

