/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.RestrictTo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.DynamicRanges;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.Quirks;
import androidx.camera.video.CapabilitiesByQuality;
import androidx.camera.video.Quality;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.internal.BackupHdrProfileEncoderProfilesProvider;
import androidx.camera.video.internal.DynamicRangeMatchedEncoderProfilesProvider;
import androidx.camera.video.internal.QualityExploredEncoderProfilesProvider;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.workaround.DefaultEncoderProfilesProvider;
import androidx.camera.video.internal.workaround.QualityAddedEncoderProfilesProvider;
import androidx.camera.video.internal.workaround.QualityResolutionModifiedEncoderProfilesProvider;
import androidx.camera.video.internal.workaround.QualityValidatedEncoderProfilesProvider;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class RecorderVideoCapabilities
implements VideoCapabilities {
    private static final String TAG = "RecorderVideoCapabilities";
    private final EncoderProfilesProvider mProfilesProvider;
    private final boolean mIsStabilizationSupported;
    private final int mQualitySource;
    private final Map<DynamicRange, CapabilitiesByQuality> mCapabilitiesMapForFullySpecifiedDynamicRange = new HashMap<DynamicRange, CapabilitiesByQuality>();
    private final Map<DynamicRange, CapabilitiesByQuality> mCapabilitiesMapForNonFullySpecifiedDynamicRange = new HashMap<DynamicRange, CapabilitiesByQuality>();

    RecorderVideoCapabilities(int videoCapabilitiesSource, @NonNull CameraInfoInternal cameraInfo, int videoCaptureType,  @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        Preconditions.checkArgument((videoCapabilitiesSource == 0 || videoCapabilitiesSource == 1 ? 1 : 0) != 0, (Object)("Not a supported video capabilities source: " + videoCapabilitiesSource));
        this.mQualitySource = videoCaptureType == 2 ? 2 : 1;
        this.mProfilesProvider = RecorderVideoCapabilities.getEncoderProfilesProvider(videoCapabilitiesSource, cameraInfo, videoEncoderInfoFinder, this.mQualitySource);
        for (DynamicRange dynamicRange : cameraInfo.getSupportedDynamicRanges()) {
            DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mProfilesProvider, dynamicRange);
            CapabilitiesByQuality capabilities = new CapabilitiesByQuality(constrainedProvider, this.mQualitySource);
            if (capabilities.getSupportedQualities().isEmpty()) continue;
            this.mCapabilitiesMapForFullySpecifiedDynamicRange.put(dynamicRange, capabilities);
        }
        this.mIsStabilizationSupported = cameraInfo.isVideoStabilizationSupported();
    }

    @Override
    public @NonNull Set<DynamicRange> getSupportedDynamicRanges() {
        return this.mCapabilitiesMapForFullySpecifiedDynamicRange.keySet();
    }

    @Override
    public @NonNull List<Quality> getSupportedQualities(@NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? new ArrayList() : capabilities.getSupportedQualities();
    }

    @Override
    public boolean isQualitySupported(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities != null && capabilities.isQualitySupported(quality);
    }

    @Override
    public boolean isStabilizationSupported() {
        return this.mIsStabilizationSupported;
    }

    @Override
    public @Nullable VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? null : capabilities.getProfiles(quality);
    }

    @Override
    public @Nullable VideoValidatedEncoderProfilesProxy findNearestHigherSupportedEncoderProfilesFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? null : capabilities.findNearestHigherSupportedEncoderProfilesFor(size);
    }

    @Override
    public @NonNull Quality findNearestHigherSupportedQualityFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        CapabilitiesByQuality capabilities = this.getCapabilities(dynamicRange);
        return capabilities == null ? Quality.NONE : capabilities.findNearestHigherSupportedQualityFor(size);
    }

    private static @NonNull EncoderProfilesProvider getEncoderProfilesProvider(int videoCapabilitiesSource, @NonNull CameraInfoInternal cameraInfo,  @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder, int qualitySource) {
        EncoderProfilesProvider encoderProfilesProvider = cameraInfo.getEncoderProfilesProvider();
        if (qualitySource == 2) {
            if (!cameraInfo.isHighSpeedSupported()) {
                return EncoderProfilesProvider.EMPTY;
            }
            return encoderProfilesProvider;
        }
        if (!CapabilitiesByQuality.containsSupportedQuality(encoderProfilesProvider, qualitySource)) {
            Logger.w((String)TAG, (String)"Camera EncoderProfilesProvider doesn't contain any supported Quality.");
            List<Quality> targetQualities = Arrays.asList(Quality.FHD, Quality.HD, Quality.SD);
            encoderProfilesProvider = new DefaultEncoderProfilesProvider(cameraInfo, targetQualities, videoEncoderInfoFinder);
        }
        Quirks deviceQuirks = DeviceQuirks.getAll();
        encoderProfilesProvider = new QualityAddedEncoderProfilesProvider(encoderProfilesProvider, deviceQuirks, cameraInfo, videoEncoderInfoFinder);
        if (videoCapabilitiesSource == 1) {
            encoderProfilesProvider = new QualityExploredEncoderProfilesProvider(encoderProfilesProvider, Quality.getSortedQualities(), Collections.singleton(DynamicRange.SDR), cameraInfo.getSupportedResolutions(34), videoEncoderInfoFinder);
        }
        encoderProfilesProvider = new QualityResolutionModifiedEncoderProfilesProvider(encoderProfilesProvider, deviceQuirks);
        if (RecorderVideoCapabilities.isHlg10SupportedByCamera(cameraInfo)) {
            encoderProfilesProvider = new BackupHdrProfileEncoderProfilesProvider(encoderProfilesProvider, videoEncoderInfoFinder);
        }
        encoderProfilesProvider = new QualityValidatedEncoderProfilesProvider(encoderProfilesProvider, cameraInfo, deviceQuirks);
        return encoderProfilesProvider;
    }

    private @Nullable CapabilitiesByQuality getCapabilities(@NonNull DynamicRange dynamicRange) {
        if (dynamicRange.isFullySpecified()) {
            return this.mCapabilitiesMapForFullySpecifiedDynamicRange.get(dynamicRange);
        }
        if (this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.containsKey(dynamicRange)) {
            return this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.get(dynamicRange);
        }
        CapabilitiesByQuality capabilities = this.generateCapabilitiesForNonFullySpecifiedDynamicRange(dynamicRange);
        this.mCapabilitiesMapForNonFullySpecifiedDynamicRange.put(dynamicRange, capabilities);
        return capabilities;
    }

    private static boolean isHlg10SupportedByCamera(@NonNull CameraInfoInternal cameraInfoInternal) {
        Set dynamicRanges = cameraInfoInternal.getSupportedDynamicRanges();
        for (DynamicRange dynamicRange : dynamicRanges) {
            Integer encoding = dynamicRange.getEncoding();
            int bitDepth = dynamicRange.getBitDepth();
            if (!encoding.equals(3) || bitDepth != 10) continue;
            return true;
        }
        return false;
    }

    private @Nullable CapabilitiesByQuality generateCapabilitiesForNonFullySpecifiedDynamicRange(@NonNull DynamicRange dynamicRange) {
        if (!DynamicRanges.canResolve((DynamicRange)dynamicRange, this.getSupportedDynamicRanges())) {
            return null;
        }
        DynamicRangeMatchedEncoderProfilesProvider constrainedProvider = new DynamicRangeMatchedEncoderProfilesProvider(this.mProfilesProvider, dynamicRange);
        return new CapabilitiesByQuality(constrainedProvider, this.mQualitySource);
    }
}

