/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import androidx.annotation.RestrictTo;
import androidx.camera.core.impl.ConstantObservable;
import androidx.camera.core.impl.Observable;
import androidx.camera.video.AutoValue_StreamInfo;
import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AutoValue
public abstract class StreamInfo {
    static final int STREAM_ID_ANY = 0;
    static final int STREAM_ID_ERROR = -1;
    static final StreamInfo STREAM_INFO_ANY_INACTIVE = StreamInfo.of(0, StreamState.INACTIVE);
    static final Set<Integer> NON_SURFACE_STREAM_ID = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(0, -1)));
    static final Observable<StreamInfo> ALWAYS_ACTIVE_OBSERVABLE = ConstantObservable.withValue((Object)StreamInfo.of(0, StreamState.ACTIVE));

    StreamInfo() {
    }

    static @NonNull StreamInfo of(int id, @NonNull StreamState streamState) {
        return new AutoValue_StreamInfo(id, streamState, null);
    }

    static @NonNull StreamInfo of(int id, @NonNull StreamState streamState, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SurfaceRequest.TransformationInfo inProgressTransformationInfo) {
        return new AutoValue_StreamInfo(id, streamState, inProgressTransformationInfo);
    }

    public abstract int getId();

    public abstract @NonNull StreamState getStreamState();

    public abstract // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SurfaceRequest.TransformationInfo getInProgressTransformationInfo();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static enum StreamState {
        ACTIVE,
        INACTIVE;

    }
}

