/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Size;
import androidx.annotation.RestrictTo;
import androidx.camera.core.DynamicRange;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface VideoCapabilities {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final @NonNull VideoCapabilities EMPTY = new VideoCapabilities(){

        @Override
        public @NonNull Set<DynamicRange> getSupportedDynamicRanges() {
            return new HashSet<DynamicRange>();
        }

        @Override
        public @NonNull List<Quality> getSupportedQualities(@NonNull DynamicRange dynamicRange) {
            return new ArrayList<Quality>();
        }

        @Override
        public boolean isQualitySupported(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
            return false;
        }
    };

    public @NonNull Set<DynamicRange> getSupportedDynamicRanges();

    public @NonNull List<Quality> getSupportedQualities(@NonNull DynamicRange var1);

    public boolean isQualitySupported(@NonNull Quality var1, @NonNull DynamicRange var2);

    default public boolean isStabilizationSupported() {
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    default public @Nullable VideoValidatedEncoderProfilesProxy getProfiles(@NonNull Quality quality, @NonNull DynamicRange dynamicRange) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    default public @Nullable VideoValidatedEncoderProfilesProxy findNearestHigherSupportedEncoderProfilesFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    default public @NonNull Quality findNearestHigherSupportedQualityFor(@NonNull Size size, @NonNull DynamicRange dynamicRange) {
        return Quality.NONE;
    }
}

