/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.media.MediaCodec;
import android.os.SystemClock;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.ResolutionInfo;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ConfigProvider;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.Timebase;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.core.internal.compat.quirk.SurfaceProcessingQuirk;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.core.processing.DefaultSurfaceProcessor;
import androidx.camera.core.processing.SurfaceEdge;
import androidx.camera.core.processing.SurfaceProcessorNode;
import androidx.camera.core.processing.util.OutConfig;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import androidx.camera.video.MediaSpec;
import androidx.camera.video.Quality;
import androidx.camera.video.QualityRatioToResolutionsTable;
import androidx.camera.video.QualitySelector;
import androidx.camera.video.StreamInfo;
import androidx.camera.video.VideoCapabilities;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.impl.VideoCaptureConfig;
import androidx.camera.video.internal.VideoValidatedEncoderProfilesProxy;
import androidx.camera.video.internal.compat.quirk.DeviceQuirks;
import androidx.camera.video.internal.compat.quirk.HdrRepeatingRequestFailureQuirk;
import androidx.camera.video.internal.compat.quirk.SizeCannotEncodeVideoQuirk;
import androidx.camera.video.internal.config.VideoConfigUtil;
import androidx.camera.video.internal.config.VideoMimeInfo;
import androidx.camera.video.internal.encoder.SwappedVideoEncoderInfo;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.encoder.VideoEncoderInfoImpl;
import androidx.camera.video.internal.utils.DynamicRangeUtil;
import androidx.camera.video.internal.workaround.VideoEncoderInfoWrapper;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class VideoCapture<T extends VideoOutput>
extends UseCase {
    private static final String TAG = "VideoCapture";
    private static final String SURFACE_UPDATE_KEY = "androidx.camera.video.VideoCapture.streamUpdate";
    private static final Defaults DEFAULT_CONFIG = new Defaults();
    DeferrableSurface mDeferrableSurface;
    private @Nullable SurfaceEdge mCameraEdge;
    StreamInfo mStreamInfo = StreamInfo.STREAM_INFO_ANY_INACTIVE;
    // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SessionConfig.Builder mSessionConfigBuilder = new SessionConfig.Builder();
    ListenableFuture<Void> mSurfaceUpdateFuture = null;
    private SurfaceRequest mSurfaceRequest;
    VideoOutput.SourceState mSourceState = VideoOutput.SourceState.INACTIVE;
    private @Nullable SurfaceProcessorNode mNode;
    private @Nullable Rect mCropRect;
    private int mRotationDegrees;
    private boolean mHasCompensatingTransformation = false;
    private @Nullable SourceStreamRequirementObserver mSourceStreamRequirementObserver;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable SessionConfig.CloseableErrorListener mCloseableErrorListener;
    private Map<Quality, List<Size>> mQualityToCustomSizesMap = Collections.emptyMap();
    private final Observable.Observer<StreamInfo> mStreamInfoObserver = new Observable.Observer<StreamInfo>(){

        public void onNewData(@Nullable StreamInfo streamInfo) {
            if (streamInfo == null) {
                throw new IllegalArgumentException("StreamInfo can't be null");
            }
            if (VideoCapture.this.mSourceState == VideoOutput.SourceState.INACTIVE) {
                return;
            }
            Logger.d((String)VideoCapture.TAG, (String)("Stream info update: old: " + VideoCapture.this.mStreamInfo + " new: " + streamInfo));
            StreamInfo currentStreamInfo = VideoCapture.this.mStreamInfo;
            VideoCapture.this.mStreamInfo = streamInfo;
            StreamSpec attachedStreamSpec = (StreamSpec)Preconditions.checkNotNull((Object)VideoCapture.this.getAttachedStreamSpec());
            if (VideoCapture.this.isStreamIdChanged(currentStreamInfo.getId(), streamInfo.getId()) || VideoCapture.this.shouldResetCompensatingTransformation(currentStreamInfo, streamInfo)) {
                VideoCapture.this.resetPipeline();
            } else if (currentStreamInfo.getId() != -1 && streamInfo.getId() == -1 || currentStreamInfo.getId() == -1 && streamInfo.getId() != -1) {
                VideoCapture.this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(VideoCapture.this.mSessionConfigBuilder, streamInfo, attachedStreamSpec);
                VideoCapture.this.updateSessionConfig(List.of(VideoCapture.this.mSessionConfigBuilder.build()));
                VideoCapture.this.notifyReset();
            } else if (currentStreamInfo.getStreamState() != streamInfo.getStreamState()) {
                VideoCapture.this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(VideoCapture.this.mSessionConfigBuilder, streamInfo, attachedStreamSpec);
                VideoCapture.this.updateSessionConfig(List.of(VideoCapture.this.mSessionConfigBuilder.build()));
                VideoCapture.this.notifyUpdated();
            }
        }

        public void onError(@NonNull Throwable t) {
            Logger.w((String)VideoCapture.TAG, (String)"Receive onError from StreamState observer", (Throwable)t);
        }
    };

    public static <T extends VideoOutput> @NonNull VideoCapture<T> withOutput(@NonNull T videoOutput) {
        return new Builder<VideoOutput>((VideoOutput)Preconditions.checkNotNull(videoOutput)).build();
    }

    VideoCapture(@NonNull VideoCaptureConfig<T> config) {
        super(config);
    }

    public @NonNull T getOutput() {
        return ((VideoCaptureConfig)this.getCurrentConfig()).getVideoOutput();
    }

    public int getTargetRotation() {
        return this.getTargetRotationInternal();
    }

    public @NonNull Range<Integer> getTargetFrameRate() {
        return this.getTargetFrameRateInternal();
    }

    public boolean isVideoStabilizationEnabled() {
        return this.getCurrentConfig().getVideoStabilizationMode() == 2;
    }

    public void setTargetRotation(int rotation) {
        if (this.setTargetRotationInternal(rotation)) {
            this.sendTransformationInfoIfReady();
        }
    }

    public @Nullable ResolutionInfo getResolutionInfo() {
        return this.getResolutionInfoInternal();
    }

    public @Nullable Quality getSelectedQuality() {
        StreamSpec streamSpec = this.getAttachedStreamSpec();
        if (streamSpec == null) {
            return null;
        }
        Size configuredResolution = streamSpec.getOriginalConfiguredResolution();
        for (Map.Entry<Quality, List<Size>> entry : this.mQualityToCustomSizesMap.entrySet()) {
            if (!entry.getValue().contains(configuredResolution)) continue;
            return entry.getKey();
        }
        Logger.w((String)TAG, (String)("Can't find matched Quality for " + configuredResolution));
        return VideoCapture.findNearestSizeFor(this.mQualityToCustomSizesMap, configuredResolution);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @Nullable ResolutionInfo getResolutionInfoInternal() {
        CameraInternal camera = this.getCamera();
        Size resolution = this.getAttachedSurfaceResolution();
        Rect cropRect = this.mCropRect;
        int rotationDegrees = this.mRotationDegrees;
        if (camera == null || resolution == null || cropRect == null) {
            return null;
        }
        return new ResolutionInfo(resolution, cropRect, rotationDegrees);
    }

    public int getMirrorMode() {
        int mirrorMode = this.getMirrorModeInternal();
        if (mirrorMode == -1) {
            return 0;
        }
        return mirrorMode;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull StreamSpec onSuggestedStreamSpecUpdated(@NonNull StreamSpec primaryStreamSpec, @Nullable StreamSpec secondaryStreamSpec) {
        Logger.d((String)TAG, (String)("onSuggestedStreamSpecUpdated: primaryStreamSpec = " + primaryStreamSpec + ", secondaryStreamSpec " + secondaryStreamSpec));
        VideoCaptureConfig config = (VideoCaptureConfig)this.getCurrentConfig();
        List customOrderedResolutions = config.getCustomOrderedResolutions(null);
        if (customOrderedResolutions != null && !customOrderedResolutions.contains(primaryStreamSpec.getResolution())) {
            Logger.w((String)TAG, (String)("suggested resolution " + primaryStreamSpec.getResolution() + " is not in custom ordered resolutions " + customOrderedResolutions));
        }
        return primaryStreamSpec;
    }

    public @NonNull DynamicRange getDynamicRange() {
        return this.getCurrentConfig().hasDynamicRange() ? this.getCurrentConfig().getDynamicRange() : Defaults.DEFAULT_DYNAMIC_RANGE;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateAttached() {
        super.onStateAttached();
        Logger.d((String)TAG, (String)("VideoCapture#onStateAttached: cameraID = " + this.getCameraId()));
        if (this.getAttachedStreamSpec() == null || this.mSurfaceRequest != null) {
            return;
        }
        StreamSpec attachedStreamSpec = (StreamSpec)Preconditions.checkNotNull((Object)this.getAttachedStreamSpec());
        this.mStreamInfo = VideoCapture.fetchObservableValue(this.getOutput().getStreamInfo(), StreamInfo.STREAM_INFO_ANY_INACTIVE);
        this.mSessionConfigBuilder = this.createPipeline((VideoCaptureConfig)this.getCurrentConfig(), attachedStreamSpec);
        this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(this.mSessionConfigBuilder, this.mStreamInfo, attachedStreamSpec);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        this.notifyActive();
        this.getOutput().getStreamInfo().addObserver((Executor)CameraXExecutors.mainThreadExecutor(), this.mStreamInfoObserver);
        if (this.mSourceStreamRequirementObserver != null) {
            this.mSourceStreamRequirementObserver.close();
        }
        this.mSourceStreamRequirementObserver = new SourceStreamRequirementObserver(this.getCameraControl());
        this.getOutput().isSourceStreamRequired().addObserver((Executor)CameraXExecutors.mainThreadExecutor(), (Observable.Observer)this.mSourceStreamRequirementObserver);
        this.setSourceState(VideoOutput.SourceState.ACTIVE_NON_STREAMING);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setViewPortCropRect(@NonNull Rect viewPortCropRect) {
        super.setViewPortCropRect(viewPortCropRect);
        this.sendTransformationInfoIfReady();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onStateDetached() {
        Logger.d((String)TAG, (String)"VideoCapture#onStateDetached");
        Preconditions.checkState((boolean)Threads.isMainThread(), (String)"VideoCapture can only be detached on the main thread.");
        if (this.mSourceStreamRequirementObserver != null) {
            this.getOutput().isSourceStreamRequired().removeObserver((Observable.Observer)this.mSourceStreamRequirementObserver);
            this.mSourceStreamRequirementObserver.close();
            this.mSourceStreamRequirementObserver = null;
        }
        this.setSourceState(VideoOutput.SourceState.INACTIVE);
        this.getOutput().getStreamInfo().removeObserver(this.mStreamInfoObserver);
        if (this.mSurfaceUpdateFuture != null && this.mSurfaceUpdateFuture.cancel(false)) {
            Logger.d((String)TAG, (String)"VideoCapture is detached from the camera. Surface update cancelled.");
        }
        this.clearPipeline();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull StreamSpec onSuggestedStreamSpecImplementationOptionsUpdated(@NonNull Config config) {
        this.mSessionConfigBuilder.addImplementationOptions(config);
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        return Objects.requireNonNull(this.getAttachedStreamSpec()).toBuilder().setImplementationOptions(config).build();
    }

    public @NonNull String toString() {
        return "VideoCapture:" + this.getName();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable UseCaseConfig<?> getDefaultConfig(boolean applyDefaultConfig, @NonNull UseCaseConfigFactory factory) {
        Config captureConfig = factory.getConfig(DEFAULT_CONFIG.getConfig().getCaptureType(), 1);
        if (applyDefaultConfig) {
            captureConfig = Config.mergeConfigs((Config)captureConfig, DEFAULT_CONFIG.getConfig());
        }
        return captureConfig == null ? null : this.getUseCaseConfigBuilder(captureConfig).getUseCaseConfig();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected @NonNull UseCaseConfig<?> onMergeConfig(@NonNull CameraInfoInternal cameraInfo, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UseCaseConfig.Builder<?, ?, ?> builder) {
        this.updateCustomOrderedResolutionsByQuality(cameraInfo, builder);
        return builder.getUseCaseConfig();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UseCaseConfig.Builder<?, ?, ?> getUseCaseConfigBuilder(@NonNull Config config) {
        return Builder.fromConfig(config);
    }

    private void sendTransformationInfoIfReady() {
        CameraInternal cameraInternal = this.getCamera();
        SurfaceEdge cameraEdge = this.mCameraEdge;
        if (cameraInternal != null && cameraEdge != null) {
            this.mRotationDegrees = this.getCompensatedRotation(cameraInternal);
            cameraEdge.updateTransformation(this.mRotationDegrees, this.getAppTargetRotation());
        }
    }

    private @NonNull Rect adjustCropRectWithInProgressTransformation(@NonNull Rect cropRect, int rotationDegrees) {
        Rect adjustedCropRect = cropRect;
        if (this.shouldCompensateTransformation()) {
            adjustedCropRect = TransformUtils.sizeToRect((Size)TransformUtils.getRotatedSize((Rect)((SurfaceRequest.TransformationInfo)Preconditions.checkNotNull((Object)this.mStreamInfo.getInProgressTransformationInfo())).getCropRect(), (int)rotationDegrees));
        }
        return adjustedCropRect;
    }

    private int getCompensatedRotation(@NonNull CameraInternal cameraInternal) {
        boolean isMirroringRequired = this.isMirroringRequired(cameraInternal);
        int rotationDegrees = this.getRelativeRotation(cameraInternal, isMirroringRequired);
        if (this.shouldCompensateTransformation()) {
            SurfaceRequest.TransformationInfo transformationInfo = Objects.requireNonNull(this.mStreamInfo.getInProgressTransformationInfo());
            int inProgressDegrees = transformationInfo.getRotationDegrees();
            if (isMirroringRequired != transformationInfo.isMirroring()) {
                inProgressDegrees = -inProgressDegrees;
            }
            rotationDegrees = TransformUtils.within360((int)(rotationDegrees - inProgressDegrees));
        }
        return rotationDegrees;
    }

    private @NonNull Size adjustResolutionWithInProgressTransformation(@NonNull Size resolution, @NonNull Rect originalCropRect, @NonNull Rect targetCropRect) {
        Size nodeResolution = resolution;
        if (this.shouldCompensateTransformation() && !targetCropRect.equals((Object)originalCropRect)) {
            float targetRatio = (float)targetCropRect.height() / (float)originalCropRect.height();
            nodeResolution = new Size((int)Math.ceil((float)resolution.getWidth() * targetRatio), (int)Math.ceil((float)resolution.getHeight() * targetRatio));
        }
        return nodeResolution;
    }

    @VisibleForTesting
    @Nullable Rect getCropRect() {
        return this.mCropRect;
    }

    @VisibleForTesting
    int getRotationDegrees() {
        return this.mRotationDegrees;
    }

    private @NonNull Rect calculateCropRect(@NonNull Size surfaceResolution, @Nullable VideoEncoderInfo videoEncoderInfo) {
        Rect cropRect = this.getViewPortCropRect() != null ? this.getViewPortCropRect() : new Rect(0, 0, surfaceResolution.getWidth(), surfaceResolution.getHeight());
        if (videoEncoderInfo == null || videoEncoderInfo.isSizeSupportedAllowSwapping(cropRect.width(), cropRect.height())) {
            return cropRect;
        }
        return VideoCapture.adjustCropRectToValidSize(cropRect, surfaceResolution, videoEncoderInfo);
    }

    @SuppressLint(value={"WrongConstant"})
    @MainThread
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SessionConfig.Builder createPipeline(@NonNull VideoCaptureConfig<T> config, @NonNull StreamSpec streamSpec) {
        Threads.checkMainThread();
        CameraInternal camera = (CameraInternal)Preconditions.checkNotNull((Object)this.getCamera());
        Size resolution = streamSpec.getResolution();
        Runnable onSurfaceInvalidated = () -> this.notifyReset();
        Range<Integer> expectedFrameRate = VideoCapture.resolveFrameRate(streamSpec);
        MediaSpec mediaSpec = Objects.requireNonNull(this.getMediaSpec());
        VideoCapabilities videoCapabilities = this.getVideoCapabilities(camera.getCameraInfo(), streamSpec.getSessionType());
        DynamicRange dynamicRange = streamSpec.getDynamicRange();
        VideoValidatedEncoderProfilesProxy encoderProfiles = videoCapabilities.findNearestHigherSupportedEncoderProfilesFor(resolution, dynamicRange);
        VideoEncoderInfo videoEncoderInfo = VideoCapture.resolveVideoEncoderInfo(config.getVideoEncoderInfoFinder(), encoderProfiles, mediaSpec, dynamicRange);
        this.mRotationDegrees = this.getCompensatedRotation(camera);
        Rect originalCropRect = this.calculateCropRect(resolution, videoEncoderInfo);
        this.mCropRect = this.adjustCropRectWithInProgressTransformation(originalCropRect, this.mRotationDegrees);
        Size nodeResolution = this.adjustResolutionWithInProgressTransformation(resolution, originalCropRect, this.mCropRect);
        if (this.shouldCompensateTransformation()) {
            this.mHasCompensatingTransformation = true;
        }
        this.mCropRect = VideoCapture.adjustCropRectByQuirk(this.mCropRect, this.mRotationDegrees, this.isCreateNodeNeeded(camera, config, this.mCropRect, resolution, dynamicRange), videoEncoderInfo);
        this.mNode = this.createNodeIfNeeded(camera, config, this.mCropRect, resolution, dynamicRange);
        boolean hasGlProcessing = !camera.getHasTransform() || this.mNode != null;
        Timebase timebase = VideoCapture.resolveTimebase(camera, this.mNode);
        Logger.d((String)TAG, (String)("camera timebase = " + camera.getCameraInfoInternal().getTimebase() + ", processing timebase = " + timebase));
        StreamSpec updatedStreamSpec = streamSpec.toBuilder().setResolution(nodeResolution).setExpectedFrameRateRange(expectedFrameRate).build();
        Preconditions.checkState((this.mCameraEdge == null ? 1 : 0) != 0);
        this.mCameraEdge = new SurfaceEdge(2, 34, updatedStreamSpec, this.getSensorToBufferTransformMatrix(), camera.getHasTransform(), this.mCropRect, this.mRotationDegrees, this.getAppTargetRotation(), this.shouldMirror(camera));
        this.mCameraEdge.addOnInvalidatedListener(onSurfaceInvalidated);
        if (this.mNode != null) {
            OutConfig outConfig = OutConfig.of((SurfaceEdge)this.mCameraEdge);
            SurfaceProcessorNode.In nodeInput = SurfaceProcessorNode.In.of((SurfaceEdge)this.mCameraEdge, Collections.singletonList(outConfig));
            SurfaceProcessorNode.Out nodeOutput = this.mNode.transform(nodeInput);
            SurfaceEdge appEdge = Objects.requireNonNull((SurfaceEdge)nodeOutput.get((Object)outConfig));
            appEdge.addOnInvalidatedListener(() -> this.onAppEdgeInvalidated(appEdge, camera, config, timebase, hasGlProcessing));
            this.mSurfaceRequest = appEdge.createSurfaceRequest(camera);
            DeferrableSurface latestDeferrableSurface = this.mDeferrableSurface = this.mCameraEdge.getDeferrableSurface();
            this.mDeferrableSurface.getTerminationFuture().addListener(() -> {
                if (latestDeferrableSurface == this.mDeferrableSurface) {
                    this.clearPipeline();
                }
            }, (Executor)CameraXExecutors.mainThreadExecutor());
        } else {
            this.mSurfaceRequest = this.mCameraEdge.createSurfaceRequest(camera);
            this.mDeferrableSurface = this.mSurfaceRequest.getDeferrableSurface();
        }
        config.getVideoOutput().onSurfaceRequested(this.mSurfaceRequest, timebase, hasGlProcessing);
        this.sendTransformationInfoIfReady();
        this.mDeferrableSurface.setContainerClass(MediaCodec.class);
        SessionConfig.Builder sessionConfigBuilder = SessionConfig.Builder.createFrom(config, (Size)streamSpec.getResolution());
        sessionConfigBuilder.setSessionType(streamSpec.getSessionType());
        this.applyExpectedFrameRateRange(sessionConfigBuilder, streamSpec);
        sessionConfigBuilder.setVideoStabilization(config.getVideoStabilizationMode());
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
        }
        this.mCloseableErrorListener = new SessionConfig.CloseableErrorListener((sessionConfig, error) -> this.resetPipeline());
        sessionConfigBuilder.setErrorListener((SessionConfig.ErrorListener)this.mCloseableErrorListener);
        if (streamSpec.getImplementationOptions() != null) {
            sessionConfigBuilder.addImplementationOptions(streamSpec.getImplementationOptions());
        }
        return sessionConfigBuilder;
    }

    private void onAppEdgeInvalidated(@NonNull SurfaceEdge appEdge, @NonNull CameraInternal camera, @NonNull VideoCaptureConfig<T> config, @NonNull Timebase timebase, boolean hasGlProcessing) {
        if (camera == this.getCamera()) {
            this.mSurfaceRequest = appEdge.createSurfaceRequest(camera);
            config.getVideoOutput().onSurfaceRequested(this.mSurfaceRequest, timebase, hasGlProcessing);
            this.sendTransformationInfoIfReady();
        }
    }

    @MainThread
    private void clearPipeline() {
        Threads.checkMainThread();
        if (this.mCloseableErrorListener != null) {
            this.mCloseableErrorListener.close();
            this.mCloseableErrorListener = null;
        }
        if (this.mDeferrableSurface != null) {
            this.mDeferrableSurface.close();
            this.mDeferrableSurface = null;
        }
        if (this.mNode != null) {
            this.mNode.release();
            this.mNode = null;
        }
        if (this.mCameraEdge != null) {
            this.mCameraEdge.close();
            this.mCameraEdge = null;
        }
        this.mCropRect = null;
        this.mSurfaceRequest = null;
        this.mStreamInfo = StreamInfo.STREAM_INFO_ANY_INACTIVE;
        this.mRotationDegrees = 0;
        this.mHasCompensatingTransformation = false;
    }

    @MainThread
    void resetPipeline() {
        if (this.getCamera() == null) {
            return;
        }
        this.clearPipeline();
        this.mSessionConfigBuilder = this.createPipeline((VideoCaptureConfig)this.getCurrentConfig(), (StreamSpec)Preconditions.checkNotNull((Object)this.getAttachedStreamSpec()));
        this.applyStreamInfoAndStreamSpecToSessionConfigBuilder(this.mSessionConfigBuilder, this.mStreamInfo, this.getAttachedStreamSpec());
        this.updateSessionConfig(List.of(this.mSessionConfigBuilder.build()));
        this.notifyReset();
    }

    @VisibleForTesting
    @Nullable SurfaceEdge getCameraEdge() {
        return this.mCameraEdge;
    }

    private @Nullable MediaSpec getMediaSpec() {
        return VideoCapture.fetchObservableValue(this.getOutput().getMediaSpec(), null);
    }

    private @NonNull MediaSpec getMediaSpecOrThrow() throws IllegalArgumentException {
        MediaSpec mediaSpec = this.getMediaSpec();
        if (mediaSpec == null) {
            throw new IllegalArgumentException("MediaSpec can't be null");
        }
        return mediaSpec;
    }

    private @NonNull VideoCapabilities getVideoCapabilities(@NonNull CameraInfo cameraInfo, int sessionType) {
        return this.getOutput().getMediaCapabilities(cameraInfo, sessionType);
    }

    @MainThread
    void applyStreamInfoAndStreamSpecToSessionConfigBuilder(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SessionConfig.Builder sessionConfigBuilder, @NonNull StreamInfo streamInfo, @NonNull StreamSpec streamSpec) {
        boolean isStreamActive;
        boolean isStreamError = streamInfo.getId() == -1;
        boolean bl = isStreamActive = streamInfo.getStreamState() == StreamInfo.StreamState.ACTIVE;
        if (isStreamError && isStreamActive) {
            throw new IllegalStateException("Unexpected stream state, stream is error but active");
        }
        sessionConfigBuilder.clearSurfaces();
        DynamicRange dynamicRange = streamSpec.getDynamicRange();
        if (!isStreamError && this.mDeferrableSurface != null) {
            if (isStreamActive) {
                sessionConfigBuilder.addSurface(this.mDeferrableSurface, dynamicRange, null, -1);
            } else {
                sessionConfigBuilder.addNonRepeatingSurface(this.mDeferrableSurface, dynamicRange);
            }
        }
        this.setupSurfaceUpdateNotifier(sessionConfigBuilder, isStreamActive);
    }

    private boolean isCreateNodeNeeded(@NonNull CameraInternal camera, @NonNull VideoCaptureConfig<?> config, @NonNull Rect cropRect, @NonNull Size resolution, @NonNull DynamicRange dynamicRange) {
        return this.getEffect() != null || VideoCapture.shouldEnableSurfaceProcessingByConfig(camera, config) || VideoCapture.shouldEnableSurfaceProcessingByQuirk(camera) || VideoCapture.shouldEnableSurfaceProcessingBasedOnDynamicRangeByQuirk(camera, dynamicRange) || VideoCapture.shouldCrop(cropRect, resolution) || this.shouldMirror(camera) || this.shouldCompensateTransformation();
    }

    private @Nullable SurfaceProcessorNode createNodeIfNeeded(@NonNull CameraInternal camera, @NonNull VideoCaptureConfig<T> config, @NonNull Rect cropRect, @NonNull Size resolution, @NonNull DynamicRange dynamicRange) {
        if (this.isCreateNodeNeeded(camera, config, cropRect, resolution, dynamicRange)) {
            Logger.d((String)TAG, (String)"Surface processing is enabled.");
            return new SurfaceProcessorNode(Objects.requireNonNull(this.getCamera()), this.getEffect() != null ? this.getEffect().createSurfaceProcessorInternal() : DefaultSurfaceProcessor.Factory.newInstance((DynamicRange)dynamicRange));
        }
        return null;
    }

    @VisibleForTesting
    @Nullable SurfaceProcessorNode getNode() {
        return this.mNode;
    }

    private static @NonNull Rect adjustCropRectByQuirk(@NonNull Rect cropRect, int rotationDegrees, boolean isSurfaceProcessingEnabled, @Nullable VideoEncoderInfo videoEncoderInfo) {
        SizeCannotEncodeVideoQuirk quirk = DeviceQuirks.get(SizeCannotEncodeVideoQuirk.class);
        if (quirk != null) {
            return quirk.adjustCropRectForProblematicEncodeSize(cropRect, isSurfaceProcessingEnabled ? rotationDegrees : 0, videoEncoderInfo);
        }
        return cropRect;
    }

    private static @NonNull Rect adjustCropRectToValidSize(@NonNull Rect cropRect, @NonNull Size resolution, @NonNull VideoEncoderInfo videoEncoderInfo) {
        Logger.d((String)TAG, (String)String.format("Adjust cropRect %s by width/height alignment %d/%d and supported widths %s / supported heights %s", TransformUtils.rectToString((Rect)cropRect), videoEncoderInfo.getWidthAlignment(), videoEncoderInfo.getHeightAlignment(), videoEncoderInfo.getSupportedWidths(), videoEncoderInfo.getSupportedHeights()));
        boolean swapWidthHeightConstraints = videoEncoderInfo.getSupportedWidths().contains((Comparable)Integer.valueOf(cropRect.width())) && videoEncoderInfo.getSupportedHeights().contains((Comparable)Integer.valueOf(cropRect.height())) ? false : videoEncoderInfo.canSwapWidthHeight() && videoEncoderInfo.getSupportedHeights().contains((Comparable)Integer.valueOf(cropRect.width())) && videoEncoderInfo.getSupportedWidths().contains((Comparable)Integer.valueOf(cropRect.height()));
        if (swapWidthHeightConstraints) {
            videoEncoderInfo = new SwappedVideoEncoderInfo(videoEncoderInfo);
        }
        int widthAlignment = videoEncoderInfo.getWidthAlignment();
        int heightAlignment = videoEncoderInfo.getHeightAlignment();
        Range<Integer> supportedWidths = videoEncoderInfo.getSupportedWidths();
        Range<Integer> supportedHeights = videoEncoderInfo.getSupportedHeights();
        int widthAlignedDown = VideoCapture.alignDown(cropRect.width(), widthAlignment, supportedWidths);
        int widthAlignedUp = VideoCapture.alignUp(cropRect.width(), widthAlignment, supportedWidths);
        int heightAlignedDown = VideoCapture.alignDown(cropRect.height(), heightAlignment, supportedHeights);
        int heightAlignedUp = VideoCapture.alignUp(cropRect.height(), heightAlignment, supportedHeights);
        HashSet<Size> candidateSet = new HashSet<Size>();
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedDown, heightAlignedDown, resolution, videoEncoderInfo);
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedDown, heightAlignedUp, resolution, videoEncoderInfo);
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedUp, heightAlignedDown, resolution, videoEncoderInfo);
        VideoCapture.addBySupportedSize(candidateSet, widthAlignedUp, heightAlignedUp, resolution, videoEncoderInfo);
        if (candidateSet.isEmpty()) {
            Logger.w((String)TAG, (String)"Can't find valid cropped size");
            return cropRect;
        }
        ArrayList<Size> candidatesList = new ArrayList<Size>(candidateSet);
        Logger.d((String)TAG, (String)("candidatesList = " + candidatesList));
        Collections.sort(candidatesList, (s1, s2) -> Math.abs(s1.getWidth() - cropRect.width()) + Math.abs(s1.getHeight() - cropRect.height()) - (Math.abs(s2.getWidth() - cropRect.width()) + Math.abs(s2.getHeight() - cropRect.height())));
        Logger.d((String)TAG, (String)("sorted candidatesList = " + candidatesList));
        Size newSize = (Size)candidatesList.get(0);
        int newWidth = newSize.getWidth();
        int newHeight = newSize.getHeight();
        if (newWidth == cropRect.width() && newHeight == cropRect.height()) {
            Logger.d((String)TAG, (String)"No need to adjust cropRect because crop size is valid.");
            return cropRect;
        }
        Preconditions.checkState((newWidth % 2 == 0 && newHeight % 2 == 0 && newWidth <= resolution.getWidth() && newHeight <= resolution.getHeight() ? 1 : 0) != 0);
        Rect newCropRect = new Rect(cropRect);
        if (newWidth != cropRect.width()) {
            newCropRect.left = Math.max(0, cropRect.centerX() - newWidth / 2);
            newCropRect.right = newCropRect.left + newWidth;
            if (newCropRect.right > resolution.getWidth()) {
                newCropRect.right = resolution.getWidth();
                newCropRect.left = newCropRect.right - newWidth;
            }
        }
        if (newHeight != cropRect.height()) {
            newCropRect.top = Math.max(0, cropRect.centerY() - newHeight / 2);
            newCropRect.bottom = newCropRect.top + newHeight;
            if (newCropRect.bottom > resolution.getHeight()) {
                newCropRect.bottom = resolution.getHeight();
                newCropRect.top = newCropRect.bottom - newHeight;
            }
        }
        Logger.d((String)TAG, (String)String.format("Adjust cropRect from %s to %s", TransformUtils.rectToString((Rect)cropRect), TransformUtils.rectToString((Rect)newCropRect)));
        return newCropRect;
    }

    private static void addBySupportedSize(@NonNull Set<Size> candidates, int width, int height, @NonNull Size resolution, @NonNull VideoEncoderInfo videoEncoderInfo) {
        if (width > resolution.getWidth() || height > resolution.getHeight()) {
            return;
        }
        try {
            Range<Integer> supportedHeights = videoEncoderInfo.getSupportedHeightsFor(width);
            candidates.add(new Size(width, ((Integer)supportedHeights.clamp((Comparable)Integer.valueOf(height))).intValue()));
        }
        catch (IllegalArgumentException e) {
            Logger.w((String)TAG, (String)("No supportedHeights for width: " + width), (Throwable)e);
        }
        try {
            Range<Integer> supportedWidths = videoEncoderInfo.getSupportedWidthsFor(height);
            candidates.add(new Size(((Integer)supportedWidths.clamp((Comparable)Integer.valueOf(width))).intValue(), height));
        }
        catch (IllegalArgumentException e) {
            Logger.w((String)TAG, (String)("No supportedWidths for height: " + height), (Throwable)e);
        }
    }

    boolean isStreamIdChanged(int currentId, int newId) {
        return !StreamInfo.NON_SURFACE_STREAM_ID.contains(currentId) && !StreamInfo.NON_SURFACE_STREAM_ID.contains(newId) && currentId != newId;
    }

    boolean shouldResetCompensatingTransformation(@NonNull StreamInfo currentStreamInfo, @NonNull StreamInfo streamInfo) {
        return this.mHasCompensatingTransformation && currentStreamInfo.getInProgressTransformationInfo() != null && streamInfo.getInProgressTransformationInfo() == null;
    }

    private boolean shouldMirror(@NonNull CameraInternal camera) {
        return camera.getHasTransform() && this.isMirroringRequired(camera);
    }

    private boolean shouldCompensateTransformation() {
        return this.mStreamInfo.getInProgressTransformationInfo() != null;
    }

    private static boolean shouldCrop(@NonNull Rect cropRect, @NonNull Size resolution) {
        return resolution.getWidth() != cropRect.width() || resolution.getHeight() != cropRect.height();
    }

    private static <T extends VideoOutput> boolean shouldEnableSurfaceProcessingByConfig(@NonNull CameraInternal camera, @NonNull VideoCaptureConfig<T> config) {
        return camera.getHasTransform() && config.isSurfaceProcessingForceEnabled();
    }

    private static boolean shouldEnableSurfaceProcessingByQuirk(@NonNull CameraInternal camera) {
        return camera.getHasTransform() && (SurfaceProcessingQuirk.workaroundBySurfaceProcessing((Quirks)DeviceQuirks.getAll()) || SurfaceProcessingQuirk.workaroundBySurfaceProcessing((Quirks)camera.getCameraInfoInternal().getCameraQuirks()));
    }

    private static boolean shouldEnableSurfaceProcessingBasedOnDynamicRangeByQuirk(@NonNull CameraInternal camera, @NonNull DynamicRange dynamicRange) {
        HdrRepeatingRequestFailureQuirk quirk = DeviceQuirks.get(HdrRepeatingRequestFailureQuirk.class);
        return camera.getHasTransform() && quirk != null && quirk.workaroundBySurfaceProcessing(dynamicRange);
    }

    private static int alignDown(int length, int alignment, @NonNull Range<Integer> supportedLength) {
        return VideoCapture.align(true, length, alignment, supportedLength);
    }

    private static int alignUp(int length, int alignment, @NonNull Range<Integer> supportedRange) {
        return VideoCapture.align(false, length, alignment, supportedRange);
    }

    private static int align(boolean alignDown, int length, int alignment, @NonNull Range<Integer> supportedRange) {
        int remainder = length % alignment;
        int newLength = remainder == 0 ? length : (alignDown ? length - remainder : length + (alignment - remainder));
        return (Integer)supportedRange.clamp((Comparable)Integer.valueOf(newLength));
    }

    private static @NonNull Timebase resolveTimebase(@NonNull CameraInternal camera, @Nullable SurfaceProcessorNode node) {
        Timebase timebase = node != null || !camera.getHasTransform() ? camera.getCameraInfoInternal().getTimebase() : Timebase.UPTIME;
        return timebase;
    }

    private static @NonNull Range<Integer> resolveFrameRate(@NonNull StreamSpec streamSpec) {
        Range<Integer> frameRate = streamSpec.getExpectedFrameRateRange();
        if (Objects.equals(frameRate, StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
            frameRate = streamSpec.getSessionType() == 1 ? Defaults.DEFAULT_HIGH_SPEED_FPS_RANGE : Defaults.DEFAULT_FPS_RANGE;
        }
        return frameRate;
    }

    private static @Nullable VideoEncoderInfo resolveVideoEncoderInfo(@NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder, @Nullable VideoValidatedEncoderProfilesProxy encoderProfiles, @NonNull MediaSpec mediaSpec, @NonNull DynamicRange dynamicRange) {
        VideoMimeInfo videoMimeInfo = VideoConfigUtil.resolveVideoMimeInfo(mediaSpec, dynamicRange, encoderProfiles);
        VideoEncoderInfo videoEncoderInfo = videoEncoderInfoFinder.find(videoMimeInfo.getMimeType());
        if (videoEncoderInfo == null) {
            Logger.w((String)TAG, (String)"Can't find videoEncoderInfo");
            return null;
        }
        Size profileSize = encoderProfiles != null ? encoderProfiles.getDefaultVideoProfile().getResolution() : null;
        return VideoEncoderInfoWrapper.from(videoEncoderInfo, profileSize);
    }

    @MainThread
    private void setupSurfaceUpdateNotifier(final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SessionConfig.Builder sessionConfigBuilder, final boolean isStreamActive) {
        if (this.mSurfaceUpdateFuture != null && this.mSurfaceUpdateFuture.cancel(false)) {
            Logger.d((String)TAG, (String)"A newer surface update is requested. Previous surface update cancelled.");
        }
        final ListenableFuture surfaceUpdateFuture = this.mSurfaceUpdateFuture = CallbackToFutureAdapter.getFuture(completer -> {
            sessionConfigBuilder.addTag(SURFACE_UPDATE_KEY, (Object)completer.hashCode());
            final AtomicBoolean surfaceUpdateComplete = new AtomicBoolean(false);
            CameraCaptureCallback cameraCaptureCallback = new CameraCaptureCallback(){
                private boolean mIsFirstCaptureResult = true;

                public void onCaptureCompleted(int captureConfigId, @NonNull CameraCaptureResult cameraCaptureResult) {
                    Object tag;
                    super.onCaptureCompleted(captureConfigId, cameraCaptureResult);
                    if (this.mIsFirstCaptureResult) {
                        this.mIsFirstCaptureResult = false;
                        Logger.d((String)VideoCapture.TAG, (String)("cameraCaptureResult timestampNs = " + cameraCaptureResult.getTimestamp() + ", current system uptimeMs = " + SystemClock.uptimeMillis() + ", current system realtimeMs = " + SystemClock.elapsedRealtime()));
                    }
                    if (!surfaceUpdateComplete.get() && (tag = cameraCaptureResult.getTagBundle().getTag(VideoCapture.SURFACE_UPDATE_KEY)) != null && ((Integer)tag).intValue() == completer.hashCode() && completer.set(null) && !surfaceUpdateComplete.getAndSet(true)) {
                        CameraXExecutors.mainThreadExecutor().execute(() -> sessionConfigBuilder.removeCameraCaptureCallback((CameraCaptureCallback)this));
                    }
                }
            };
            completer.addCancellationListener(() -> {
                Preconditions.checkState((boolean)Threads.isMainThread(), (String)"Surface update cancellation should only occur on main thread.");
                surfaceUpdateComplete.set(true);
                sessionConfigBuilder.removeCameraCaptureCallback(cameraCaptureCallback);
            }, CameraXExecutors.directExecutor());
            sessionConfigBuilder.addRepeatingCameraCaptureCallback(cameraCaptureCallback);
            return String.format("%s[0x%x]", SURFACE_UPDATE_KEY, completer.hashCode());
        });
        Futures.addCallback((ListenableFuture)surfaceUpdateFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(@Nullable Void result) {
                if (surfaceUpdateFuture == VideoCapture.this.mSurfaceUpdateFuture && VideoCapture.this.mSourceState != VideoOutput.SourceState.INACTIVE) {
                    VideoCapture.this.setSourceState(isStreamActive ? VideoOutput.SourceState.ACTIVE_STREAMING : VideoOutput.SourceState.ACTIVE_NON_STREAMING);
                }
            }

            public void onFailure(@NonNull Throwable t) {
                if (!(t instanceof CancellationException)) {
                    Logger.e((String)VideoCapture.TAG, (String)"Surface update completed with unexpected exception", (Throwable)t);
                }
            }
        }, (Executor)CameraXExecutors.mainThreadExecutor());
    }

    private void updateCustomOrderedResolutionsByQuality(@NonNull CameraInfoInternal cameraInfo, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UseCaseConfig.Builder<?, ?, ?> builder) throws IllegalArgumentException {
        MediaSpec mediaSpec = this.getMediaSpecOrThrow();
        QualitySelector qualitySelector = mediaSpec.getVideoSpec().getQualitySelector();
        VideoCaptureConfig config = (VideoCaptureConfig)builder.getUseCaseConfig();
        if (config.containsOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS)) {
            Preconditions.checkArgument((qualitySelector == VideoSpec.QUALITY_SELECTOR_AUTO ? 1 : 0) != 0, (Object)"Custom ordered resolutions and QualitySelector can't both be set");
            return;
        }
        DynamicRange requestedDynamicRange = config.getDynamicRange();
        int sessionType = this.getSessionType(config);
        Range<Integer> targetFrameRate = this.getTargetFrameRate(config);
        VideoCapabilities videoCapabilities = this.getVideoCapabilities((CameraInfo)cameraInfo, sessionType);
        Logger.d((String)TAG, (String)("Update custom order resolutions: requestedDynamicRange = " + requestedDynamicRange + ", sessionType = " + sessionType + ", targetFrameRate = " + targetFrameRate));
        List<Quality> supportedQualities = this.getSupportedQualitiesOrThrow(requestedDynamicRange, videoCapabilities, sessionType);
        if (supportedQualities.isEmpty()) {
            Logger.w((String)TAG, (String)"Can't find any supported quality on the device.");
            return;
        }
        List<Quality> selectedQualities = this.getSelectedQualityOrThrow(supportedQualities, qualitySelector);
        LinkedHashMap<Quality, List<Size>> supportedQualityToSizeMap = this.createOrderedQualityToSizesMap(cameraInfo, mediaSpec, requestedDynamicRange, videoCapabilities, sessionType, targetFrameRate, config.getVideoEncoderInfoFinder(), selectedQualities);
        this.setCustomOrderedResolutions(builder, supportedQualityToSizeMap);
    }

    private @NonNull List<Quality> getSupportedQualitiesOrThrow(@NonNull DynamicRange requestedDynamicRange, @NonNull VideoCapabilities videoCapabilities, int sessionType) throws IllegalArgumentException {
        List<Quality> supportedQualities = videoCapabilities.getSupportedQualities(requestedDynamicRange);
        Logger.d((String)TAG, (String)("supportedQualities = " + supportedQualities));
        if (supportedQualities.isEmpty() && sessionType == 1) {
            throw new IllegalArgumentException("No supported quality on the device for high-speed capture.");
        }
        return supportedQualities;
    }

    private @NonNull List<Quality> getSelectedQualityOrThrow(@NonNull List<Quality> supportedQualities, @NonNull QualitySelector qualitySelector) throws IllegalArgumentException {
        List<Quality> selectedQualities = qualitySelector.getPrioritizedQualities(supportedQualities);
        Logger.d((String)TAG, (String)("Found selectedQualities " + selectedQualities + " by " + qualitySelector));
        if (selectedQualities.isEmpty()) {
            throw new IllegalArgumentException("Unable to find selected quality");
        }
        return selectedQualities;
    }

    private @NonNull LinkedHashMap<Quality, List<Size>> createOrderedQualityToSizesMap(@NonNull CameraInfoInternal cameraInfo, @NonNull MediaSpec mediaSpec, @NonNull DynamicRange requestedDynamicRange, @NonNull VideoCapabilities videoCapabilities, int sessionType, @NonNull Range<Integer> targetFrameRate, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder, @NonNull List<Quality> selectedQualities) {
        int aspectRatio = mediaSpec.getVideoSpec().getAspectRatio();
        Map<Quality, Size> supportedQualityToSizeMap = QualitySelector.getQualityToResolutionMap(videoCapabilities, requestedDynamicRange);
        List<Size> supportedResolutions = this.getSupportedResolutions(cameraInfo, sessionType, targetFrameRate);
        QualityRatioToResolutionsTable qualityRatioTable = new QualityRatioToResolutionsTable(supportedResolutions, supportedQualityToSizeMap);
        LinkedHashMap<Quality, List<Size>> orderedQualityToSizesMap = new LinkedHashMap<Quality, List<Size>>();
        for (Quality selectedQuality : selectedQualities) {
            orderedQualityToSizesMap.put(selectedQuality, qualityRatioTable.getResolutions(selectedQuality, aspectRatio));
        }
        return VideoCapture.filterOutEncoderUnsupportedResolutions(videoEncoderInfoFinder, mediaSpec, requestedDynamicRange, videoCapabilities, orderedQualityToSizesMap, supportedQualityToSizeMap);
    }

    private void setCustomOrderedResolutions(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UseCaseConfig.Builder<?, ?, ?> configBuilder, @NonNull LinkedHashMap<Quality, List<Size>> qualityToSizesMap) {
        ArrayList<Size> filteredCustomOrderedResolutions = new ArrayList<Size>();
        for (List<Size> resolutions : qualityToSizesMap.values()) {
            filteredCustomOrderedResolutions.addAll(resolutions);
        }
        Logger.d((String)TAG, (String)("Set custom ordered resolutions = " + filteredCustomOrderedResolutions));
        configBuilder.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, filteredCustomOrderedResolutions);
        this.mQualityToCustomSizesMap = qualityToSizesMap;
    }

    private int getSessionType(@NonNull VideoCaptureConfig<T> useCaseConfig) {
        return useCaseConfig.getSessionType(0);
    }

    private @NonNull Range<Integer> getTargetFrameRate(@NonNull VideoCaptureConfig<T> useCaseConfig) {
        return Objects.requireNonNull(useCaseConfig.getTargetFrameRate(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED));
    }

    private @NonNull List<Size> getSupportedResolutions(@NonNull CameraInfoInternal cameraInfo, int sessionType, @NonNull Range<Integer> targetFrameRate) {
        List supportedResolutions = sessionType == 1 ? (StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED.equals(targetFrameRate) ? cameraInfo.getSupportedHighSpeedResolutions() : cameraInfo.getSupportedHighSpeedResolutionsFor(targetFrameRate)) : cameraInfo.getSupportedResolutions(this.getImageFormat());
        return supportedResolutions;
    }

    private static @NonNull LinkedHashMap<Quality, List<Size>> filterOutEncoderUnsupportedResolutions(@NonNull VideoEncoderInfo.Finder videoEncoderFinder, @NonNull MediaSpec mediaSpec, @NonNull DynamicRange dynamicRange, @NonNull VideoCapabilities videoCapabilities, @NonNull LinkedHashMap<Quality, List<Size>> qualityToSizesOrderedMap, @NonNull Map<Quality, Size> supportedQualityToSizeMap) {
        if (qualityToSizesOrderedMap.isEmpty()) {
            return new LinkedHashMap<Quality, List<Size>>();
        }
        LinkedHashMap<Quality, List<Size>> filteredQualityToSizesOrderedMap = new LinkedHashMap<Quality, List<Size>>();
        for (Map.Entry<Quality, List<Size>> entry : qualityToSizesOrderedMap.entrySet()) {
            ArrayList filteredSizeList = new ArrayList(entry.getValue());
            Iterator sizeIterator = filteredSizeList.iterator();
            while (sizeIterator.hasNext()) {
                VideoEncoderInfo videoEncoderInfo;
                VideoValidatedEncoderProfilesProxy encoderProfiles;
                Size resolution = (Size)sizeIterator.next();
                if (supportedQualityToSizeMap.containsValue(resolution) || (encoderProfiles = videoCapabilities.findNearestHigherSupportedEncoderProfilesFor(resolution, dynamicRange)) == null || (videoEncoderInfo = VideoCapture.findLargestSupportedSizeVideoEncoderInfo(videoEncoderFinder, encoderProfiles, dynamicRange, mediaSpec)) == null || videoEncoderInfo.isSizeSupportedAllowSwapping(resolution.getWidth(), resolution.getHeight())) continue;
                sizeIterator.remove();
            }
            if (filteredSizeList.isEmpty()) continue;
            filteredQualityToSizesOrderedMap.put(entry.getKey(), filteredSizeList);
        }
        return filteredQualityToSizesOrderedMap;
    }

    private static @Nullable VideoEncoderInfo findLargestSupportedSizeVideoEncoderInfo(@NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder, @NonNull VideoValidatedEncoderProfilesProxy encoderProfiles, @NonNull DynamicRange dynamicRange, @NonNull MediaSpec mediaSpec) {
        if (dynamicRange.isFullySpecified()) {
            return VideoCapture.resolveVideoEncoderInfo(videoEncoderInfoFinder, encoderProfiles, mediaSpec, dynamicRange);
        }
        VideoEncoderInfo sizeLargestVideoEncoderInfo = null;
        int largestArea = Integer.MIN_VALUE;
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : encoderProfiles.getVideoProfiles()) {
            int area;
            DynamicRange profileDynamicRange;
            VideoEncoderInfo videoEncoderInfo;
            if (!DynamicRangeUtil.isHdrSettingsMatched(videoProfile, dynamicRange) || (videoEncoderInfo = VideoCapture.resolveVideoEncoderInfo(videoEncoderInfoFinder, encoderProfiles, mediaSpec, profileDynamicRange = new DynamicRange(DynamicRangeUtil.videoProfileHdrFormatsToDynamicRangeEncoding(videoProfile.getHdrFormat()), DynamicRangeUtil.videoProfileBitDepthToDynamicRangeBitDepth(videoProfile.getBitDepth())))) == null || (area = SizeUtil.getArea((int)((Integer)videoEncoderInfo.getSupportedWidths().getUpper()), (int)((Integer)videoEncoderInfo.getSupportedHeights().getUpper()))) <= largestArea) continue;
            largestArea = area;
            sizeLargestVideoEncoderInfo = videoEncoderInfo;
        }
        return sizeLargestVideoEncoderInfo;
    }

    private static @Nullable Quality findNearestSizeFor(@NonNull Map<Quality, List<Size>> sizeMap, @NonNull Size targetSize) {
        int targetArea = SizeUtil.getArea((Size)targetSize);
        Quality nearestQuality = null;
        int minAreaDiff = Integer.MAX_VALUE;
        for (Map.Entry<Quality, List<Size>> entry : sizeMap.entrySet()) {
            for (Size size : entry.getValue()) {
                int areaDiff = Math.abs(SizeUtil.getArea((Size)size) - targetArea);
                if (areaDiff >= minAreaDiff) continue;
                minAreaDiff = areaDiff;
                nearestQuality = entry.getKey();
            }
        }
        return nearestQuality;
    }

    private static <T> @Nullable T fetchObservableValue(@NonNull Observable<T> observable, @Nullable T valueIfMissing) {
        ListenableFuture future = observable.fetchData();
        if (!future.isDone()) {
            return valueIfMissing;
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    @MainThread
    void setSourceState(@NonNull VideoOutput.SourceState newState) {
        VideoOutput.SourceState oldState = this.mSourceState;
        if (newState != oldState) {
            this.mSourceState = newState;
            this.getOutput().onSourceStateChanged(newState);
        }
    }

    @VisibleForTesting
    @NonNull SurfaceRequest getSurfaceRequest() {
        return Objects.requireNonNull(this.mSurfaceRequest);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull Set<Integer> getSupportedEffectTargets() {
        HashSet<Integer> targets = new HashSet<Integer>();
        targets.add(2);
        return targets;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @NonNull Set<@NonNull DynamicRange> getSupportedDynamicRanges(@NonNull CameraInfoInternal cameraInfo) {
        VideoCapabilities videoCapabilities = this.getVideoCapabilities((CameraInfo)cameraInfo, 0);
        return videoCapabilities.getSupportedDynamicRanges();
    }

    public static final class Builder<T extends VideoOutput>
    implements UseCaseConfig.Builder<VideoCapture<T>, VideoCaptureConfig<T>, Builder<T>>,
    ImageOutputConfig.Builder<Builder<T>>,
    ImageInputConfig.Builder<Builder<T>>,
    ThreadConfig.Builder<Builder<T>> {
        private final MutableOptionsBundle mMutableConfig;

        public Builder(@NonNull T videoOutput) {
            this(Builder.createInitialBundle(videoOutput));
        }

        private Builder(@NonNull MutableOptionsBundle mutableConfig) {
            this.mMutableConfig = mutableConfig;
            if (!this.mMutableConfig.containsOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT)) {
                throw new IllegalArgumentException("VideoOutput is required");
            }
            Class oldConfigClass = (Class)mutableConfig.retrieveOption(TargetConfig.OPTION_TARGET_CLASS, null);
            if (oldConfigClass != null && !oldConfigClass.equals(VideoCapture.class)) {
                throw new IllegalArgumentException("Invalid target class configuration for " + this + ": " + oldConfigClass);
            }
            this.setCaptureType(UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE);
            this.setTargetClass(VideoCapture.class);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        static @NonNull Builder<? extends VideoOutput> fromConfig(@NonNull Config configuration) {
            return new Builder(MutableOptionsBundle.from((Config)configuration));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static <T extends VideoOutput> @NonNull Builder<T> fromConfig(@NonNull VideoCaptureConfig<T> configuration) {
            return new Builder<T>(MutableOptionsBundle.from(configuration));
        }

        private static <T extends VideoOutput> @NonNull MutableOptionsBundle createInitialBundle(@NonNull T videoOutput) {
            MutableOptionsBundle bundle = MutableOptionsBundle.create();
            bundle.insertOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT, videoOutput);
            return bundle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull MutableConfig getMutableConfig() {
            return this.mMutableConfig;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull VideoCaptureConfig<T> getUseCaseConfig() {
            return new VideoCaptureConfig(OptionsBundle.from((Config)this.mMutableConfig));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setVideoOutput(@NonNull VideoOutput videoOutput) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_VIDEO_OUTPUT, (Object)videoOutput);
            return this;
        }

        @NonNull Builder<T> setVideoEncoderInfoFinder(@NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_VIDEO_ENCODER_INFO_FINDER, (Object)videoEncoderInfoFinder);
            return this;
        }

        public @NonNull VideoCapture<T> build() {
            return new VideoCapture(this.getUseCaseConfig());
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setTargetClass(@NonNull Class<VideoCapture<T>> targetClass) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_CLASS, targetClass);
            if (null == this.getMutableConfig().retrieveOption(TargetConfig.OPTION_TARGET_NAME, null)) {
                String targetName = targetClass.getCanonicalName() + "-" + UUID.randomUUID();
                this.setTargetName(targetName);
            }
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setTargetName(@NonNull String targetName) {
            this.getMutableConfig().insertOption(TargetConfig.OPTION_TARGET_NAME, (Object)targetName);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setTargetAspectRatio(int aspectRatio) {
            throw new UnsupportedOperationException("setTargetAspectRatio is not supported.");
        }

        public @NonNull Builder<T> setTargetRotation(int rotation) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_TARGET_ROTATION, (Object)rotation);
            return this;
        }

        public @NonNull Builder<T> setMirrorMode(int mirrorMode) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MIRROR_MODE, (Object)mirrorMode);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setTargetResolution(@NonNull Size resolution) {
            throw new UnsupportedOperationException("setTargetResolution is not supported.");
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setDefaultResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_DEFAULT_RESOLUTION, (Object)resolution);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setMaxResolution(@NonNull Size resolution) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_MAX_RESOLUTION, (Object)resolution);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_SUPPORTED_RESOLUTIONS, resolutions);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setCustomOrderedResolutions(@NonNull List<Size> resolutions) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_CUSTOM_ORDERED_RESOLUTIONS, resolutions);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setResolutionSelector(@NonNull ResolutionSelector resolutionSelector) {
            this.getMutableConfig().insertOption(ImageOutputConfig.OPTION_RESOLUTION_SELECTOR, (Object)resolutionSelector);
            return this;
        }

        public @NonNull Builder<T> setDynamicRange(@NonNull DynamicRange dynamicRange) {
            this.getMutableConfig().insertOption(ImageInputConfig.OPTION_INPUT_DYNAMIC_RANGE, (Object)dynamicRange);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setBackgroundExecutor(@NonNull Executor executor) {
            this.getMutableConfig().insertOption(ThreadConfig.OPTION_BACKGROUND_EXECUTOR, (Object)executor);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setDefaultSessionConfig(@NonNull SessionConfig sessionConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_SESSION_CONFIG, (Object)sessionConfig);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setDefaultCaptureConfig(@NonNull CaptureConfig captureConfig) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_DEFAULT_CAPTURE_CONFIG, (Object)captureConfig);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setSessionOptionUnpacker(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull SessionConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SESSION_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setCaptureOptionUnpacker(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull CaptureConfig.OptionUnpacker optionUnpacker) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_CONFIG_UNPACKER, (Object)optionUnpacker);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setSurfaceOccupancyPriority(int priority) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_SURFACE_OCCUPANCY_PRIORITY, (Object)priority);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setZslDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_ZSL_DISABLED, (Object)disabled);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setHighResolutionDisabled(boolean disabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_HIGH_RESOLUTION_DISABLED, (Object)disabled);
            return this;
        }

        public @NonNull Builder<T> setTargetFrameRate(@NonNull Range<Integer> targetFrameRate) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_TARGET_FRAME_RATE, targetFrameRate);
            return this;
        }

        public @NonNull Builder<T> setVideoStabilizationEnabled(boolean enabled) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_VIDEO_STABILIZATION_MODE, (Object)(enabled ? 2 : 1));
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setCaptureType(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull UseCaseConfigFactory.CaptureType captureType) {
            this.getMutableConfig().insertOption(UseCaseConfig.OPTION_CAPTURE_TYPE, (Object)captureType);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public @NonNull Builder<T> setSurfaceProcessingForceEnabled() {
            this.getMutableConfig().insertOption(VideoCaptureConfig.OPTION_FORCE_ENABLE_SURFACE_PROCESSING, (Object)true);
            return this;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class Defaults
    implements ConfigProvider<VideoCaptureConfig<?>> {
        private static final int DEFAULT_SURFACE_OCCUPANCY_PRIORITY = 5;
        private static final VideoOutput DEFAULT_VIDEO_OUTPUT = SurfaceRequest::willNotProvideSurface;
        private static final VideoCaptureConfig<?> DEFAULT_CONFIG;
        private static final VideoEncoderInfo.Finder DEFAULT_VIDEO_ENCODER_INFO_FINDER;
        static final Range<Integer> DEFAULT_FPS_RANGE;
        static final Range<Integer> DEFAULT_HIGH_SPEED_FPS_RANGE;
        static final DynamicRange DEFAULT_DYNAMIC_RANGE;

        public @NonNull VideoCaptureConfig<?> getConfig() {
            return DEFAULT_CONFIG;
        }

        static {
            DEFAULT_VIDEO_ENCODER_INFO_FINDER = VideoEncoderInfoImpl.FINDER;
            DEFAULT_FPS_RANGE = new Range((Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(30));
            DEFAULT_HIGH_SPEED_FPS_RANGE = new Range((Comparable)Integer.valueOf(120), (Comparable)Integer.valueOf(120));
            DEFAULT_DYNAMIC_RANGE = DynamicRange.SDR;
            Object builder = ((Builder)new Builder<VideoOutput>(DEFAULT_VIDEO_OUTPUT).setSurfaceOccupancyPriority(5)).setVideoEncoderInfoFinder(DEFAULT_VIDEO_ENCODER_INFO_FINDER).setDynamicRange(DEFAULT_DYNAMIC_RANGE);
            DEFAULT_CONFIG = ((Builder)builder).getUseCaseConfig();
        }
    }

    static class SourceStreamRequirementObserver
    implements Observable.Observer<Boolean> {
        private @Nullable CameraControlInternal mCameraControl;
        private boolean mIsSourceStreamRequired = false;

        SourceStreamRequirementObserver(@NonNull CameraControlInternal cameraControl) {
            this.mCameraControl = cameraControl;
        }

        @MainThread
        public void onNewData(@Nullable Boolean value) {
            Preconditions.checkState((boolean)Threads.isMainThread(), (String)"SourceStreamRequirementObserver can be updated from main thread only");
            this.updateVideoUsageInCamera(Boolean.TRUE.equals(value));
        }

        public void onError(@NonNull Throwable t) {
            Logger.w((String)VideoCapture.TAG, (String)"SourceStreamRequirementObserver#onError", (Throwable)t);
        }

        private void updateVideoUsageInCamera(boolean isRequired) {
            if (this.mIsSourceStreamRequired == isRequired) {
                return;
            }
            this.mIsSourceStreamRequired = isRequired;
            if (this.mCameraControl != null) {
                if (this.mIsSourceStreamRequired) {
                    this.mCameraControl.incrementVideoUsage();
                } else {
                    this.mCameraControl.decrementVideoUsage();
                }
            } else {
                Logger.d((String)VideoCapture.TAG, (String)"SourceStreamRequirementObserver#isSourceStreamRequired: Received new data despite being closed already");
            }
        }

        @MainThread
        public void close() {
            Preconditions.checkState((boolean)Threads.isMainThread(), (String)"SourceStreamRequirementObserver can be closed from main thread only");
            Logger.d((String)VideoCapture.TAG, (String)("SourceStreamRequirementObserver#close: mIsSourceStreamRequired = " + this.mIsSourceStreamRequired));
            if (this.mCameraControl == null) {
                Logger.d((String)VideoCapture.TAG, (String)"SourceStreamRequirementObserver#close: Already closed!");
                return;
            }
            this.updateVideoUsageInCamera(false);
            this.mCameraControl = null;
        }
    }
}

