/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.view.Surface;
import androidx.camera.core.Logger;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.video.internal.encoder.Encoder;
import androidx.camera.video.internal.encoder.EncoderFactory;
import androidx.camera.video.internal.encoder.InvalidConfigException;
import androidx.camera.video.internal.encoder.VideoEncoderConfig;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class VideoEncoderSession {
    private static final String TAG = "VideoEncoderSession";
    private final Executor mExecutor;
    private final Executor mSequentialExecutor;
    private final EncoderFactory mVideoEncoderFactory;
    private Encoder mVideoEncoder = null;
    private Surface mActiveSurface = null;
    private SurfaceRequest mSurfaceRequest = null;
    private Executor mOnSurfaceUpdateExecutor = null;
    private Encoder.SurfaceInput.OnSurfaceUpdateListener mOnSurfaceUpdateListener = null;
    private VideoEncoderState mVideoEncoderState = VideoEncoderState.NOT_INITIALIZED;
    private ListenableFuture<Void> mReleasedFuture = Futures.immediateFailedFuture((Throwable)new IllegalStateException("Cannot close the encoder before configuring."));
    private CallbackToFutureAdapter.Completer<Void> mReleasedCompleter = null;
    private ListenableFuture<Encoder> mReadyToReleaseFuture = Futures.immediateFailedFuture((Throwable)new IllegalStateException("Cannot close the encoder before configuring."));
    private CallbackToFutureAdapter.Completer<Encoder> mReadyToReleaseCompleter = null;

    VideoEncoderSession(@NonNull EncoderFactory videoEncoderFactory, @NonNull Executor sequentialExecutor, @NonNull Executor executor) {
        this.mExecutor = executor;
        this.mSequentialExecutor = sequentialExecutor;
        this.mVideoEncoderFactory = videoEncoderFactory;
    }

    @NonNull ListenableFuture<Encoder> configure(@NonNull SurfaceRequest surfaceRequest, @NonNull VideoEncoderConfig videoEncoderConfig) {
        switch (this.mVideoEncoderState.ordinal()) {
            case 0: {
                this.mVideoEncoderState = VideoEncoderState.INITIALIZING;
                this.mSurfaceRequest = surfaceRequest;
                Logger.d((String)TAG, (String)("Create VideoEncoderSession: " + this));
                this.mReleasedFuture = CallbackToFutureAdapter.getFuture(closeCompleter -> {
                    this.mReleasedCompleter = closeCompleter;
                    return "ReleasedFuture " + this;
                });
                this.mReadyToReleaseFuture = CallbackToFutureAdapter.getFuture(requestCompleteCompleter -> {
                    this.mReadyToReleaseCompleter = requestCompleteCompleter;
                    return "ReadyToReleaseFuture " + this;
                });
                ListenableFuture configureFuture = CallbackToFutureAdapter.getFuture(completer -> {
                    this.configureVideoEncoderInternal(surfaceRequest, videoEncoderConfig, (CallbackToFutureAdapter.Completer<Encoder>)completer);
                    return "ConfigureVideoEncoderFuture " + this;
                });
                Futures.addCallback((ListenableFuture)configureFuture, (FutureCallback)new FutureCallback<Encoder>(){

                    public void onSuccess(@Nullable Encoder result) {
                    }

                    public void onFailure(@NonNull Throwable t) {
                        Logger.w((String)VideoEncoderSession.TAG, (String)"VideoEncoder configuration failed.", (Throwable)t);
                        VideoEncoderSession.this.terminateNow();
                    }
                }, (Executor)this.mSequentialExecutor);
                return Futures.nonCancellationPropagating((ListenableFuture)configureFuture);
            }
        }
        return Futures.immediateFailedFuture((Throwable)new IllegalStateException("configure() shouldn't be called in " + (Object)((Object)this.mVideoEncoderState)));
    }

    boolean isConfiguredSurfaceRequest(@NonNull SurfaceRequest surfaceRequest) {
        switch (this.mVideoEncoderState.ordinal()) {
            case 1: 
            case 3: {
                return this.mSurfaceRequest == surfaceRequest;
            }
            case 0: 
            case 2: 
            case 4: {
                return false;
            }
        }
        throw new IllegalStateException("State " + (Object)((Object)this.mVideoEncoderState) + " is not handled");
    }

    @NonNull ListenableFuture<Encoder> getReadyToReleaseFuture() {
        return Futures.nonCancellationPropagating(this.mReadyToReleaseFuture);
    }

    @NonNull ListenableFuture<Void> signalTermination() {
        this.closeInternal();
        return Futures.nonCancellationPropagating(this.mReleasedFuture);
    }

    void terminateNow() {
        switch (this.mVideoEncoderState.ordinal()) {
            case 0: {
                this.mVideoEncoderState = VideoEncoderState.RELEASED;
                return;
            }
            case 4: {
                Logger.d((String)TAG, (String)("terminateNow in " + (Object)((Object)this.mVideoEncoderState) + ", No-op"));
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                this.mVideoEncoderState = VideoEncoderState.RELEASED;
                this.mReadyToReleaseCompleter.set((Object)this.mVideoEncoder);
                this.mSurfaceRequest = null;
                if (this.mVideoEncoder != null) {
                    Logger.d((String)TAG, (String)("VideoEncoder is releasing: " + this.mVideoEncoder));
                    this.mVideoEncoder.release();
                    this.mVideoEncoder.getReleasedFuture().addListener(() -> this.mReleasedCompleter.set(null), this.mSequentialExecutor);
                    this.mVideoEncoder = null;
                    break;
                }
                Logger.w((String)TAG, (String)"There's no VideoEncoder to release! Finish release completer.");
                this.mReleasedCompleter.set(null);
                break;
            }
            default: {
                throw new IllegalStateException("State " + (Object)((Object)this.mVideoEncoderState) + " is not handled");
            }
        }
    }

    @Nullable Surface getActiveSurface() {
        if (this.mVideoEncoderState != VideoEncoderState.READY) {
            return null;
        }
        return this.mActiveSurface;
    }

    @Nullable Encoder getVideoEncoder() {
        return this.mVideoEncoder;
    }

    private void closeInternal() {
        switch (this.mVideoEncoderState.ordinal()) {
            case 0: 
            case 1: {
                this.terminateNow();
                break;
            }
            case 2: 
            case 3: {
                Logger.d((String)TAG, (String)("closeInternal in " + (Object)((Object)this.mVideoEncoderState) + " state"));
                this.mVideoEncoderState = VideoEncoderState.PENDING_RELEASE;
                break;
            }
            case 4: {
                Logger.d((String)TAG, (String)"closeInternal in RELEASED state, No-op");
                break;
            }
            default: {
                throw new IllegalStateException("State " + (Object)((Object)this.mVideoEncoderState) + " is not handled");
            }
        }
    }

    void setOnSurfaceUpdateListener(@NonNull Executor executor, @NonNull Encoder.SurfaceInput.OnSurfaceUpdateListener onSurfaceUpdateListener) {
        this.mOnSurfaceUpdateExecutor = executor;
        this.mOnSurfaceUpdateListener = onSurfaceUpdateListener;
    }

    private void configureVideoEncoderInternal(@NonNull SurfaceRequest surfaceRequest, @NonNull VideoEncoderConfig config, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull CallbackToFutureAdapter.Completer<Encoder> configureCompleter) {
        try {
            this.mVideoEncoder = this.mVideoEncoderFactory.createEncoder(this.mExecutor, config, surfaceRequest.getSessionType());
        }
        catch (InvalidConfigException e) {
            Logger.e((String)TAG, (String)"Unable to initialize video encoder.", (Throwable)e);
            configureCompleter.setException((Throwable)e);
            return;
        }
        Encoder.EncoderInput encoderInput = this.mVideoEncoder.getInput();
        if (!(encoderInput instanceof Encoder.SurfaceInput)) {
            configureCompleter.setException((Throwable)((Object)new AssertionError((Object)"The EncoderInput of video isn't a SurfaceInput.")));
            return;
        }
        ((Encoder.SurfaceInput)encoderInput).setOnSurfaceUpdateListener(this.mSequentialExecutor, surface -> {
            switch (this.mVideoEncoderState.ordinal()) {
                case 0: 
                case 2: 
                case 4: {
                    Logger.d((String)TAG, (String)("Not provide surface in " + (Object)((Object)this.mVideoEncoderState)));
                    configureCompleter.set(null);
                    break;
                }
                case 1: {
                    if (surfaceRequest.isServiced()) {
                        Logger.d((String)TAG, (String)("Not provide surface, " + Objects.toString(surfaceRequest, "EMPTY") + " is already serviced."));
                        configureCompleter.set(null);
                        this.closeInternal();
                        break;
                    }
                    this.mActiveSurface = surface;
                    Logger.d((String)TAG, (String)("provide surface: " + surface));
                    surfaceRequest.provideSurface(surface, this.mSequentialExecutor, this::onSurfaceRequestComplete);
                    this.mVideoEncoderState = VideoEncoderState.READY;
                    configureCompleter.set((Object)this.mVideoEncoder);
                    break;
                }
                case 3: {
                    if (this.mOnSurfaceUpdateListener != null && this.mOnSurfaceUpdateExecutor != null) {
                        this.mOnSurfaceUpdateExecutor.execute(() -> this.mOnSurfaceUpdateListener.onSurfaceUpdate(surface));
                    }
                    Logger.w((String)TAG, (String)("Surface is updated in READY state: " + surface));
                    break;
                }
                default: {
                    throw new IllegalStateException("State " + (Object)((Object)this.mVideoEncoderState) + " is not handled");
                }
            }
        });
    }

    private void onSurfaceRequestComplete(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SurfaceRequest.Result result) {
        Logger.d((String)TAG, (String)("Surface can be closed: " + result.getSurface().hashCode()));
        Surface resultSurface = result.getSurface();
        if (resultSurface == this.mActiveSurface) {
            this.mActiveSurface = null;
            this.mReadyToReleaseCompleter.set((Object)this.mVideoEncoder);
            this.closeInternal();
        } else {
            resultSurface.release();
        }
    }

    public @NonNull String toString() {
        return "VideoEncoderSession@" + this.hashCode() + " for " + Objects.toString(this.mSurfaceRequest, "SURFACE_REQUEST_NOT_CONFIGURED");
    }

    private static enum VideoEncoderState {
        NOT_INITIALIZED,
        INITIALIZING,
        PENDING_RELEASE,
        READY,
        RELEASED;

    }
}

