/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video;

import android.util.Range;
import androidx.annotation.RestrictTo;
import androidx.camera.video.AutoValue_VideoSpec;
import androidx.camera.video.FallbackStrategy;
import androidx.camera.video.Quality;
import androidx.camera.video.QualitySelector;
import com.google.auto.value.AutoValue;
import java.util.Arrays;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AutoValue
public abstract class VideoSpec {
    public static final int ENCODE_FRAME_RATE_AUTO = 0;
    public static final @NonNull Range<Integer> BITRATE_RANGE_AUTO = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE));
    public static final @NonNull QualitySelector QUALITY_SELECTOR_AUTO = QualitySelector.fromOrderedList(Arrays.asList(Quality.FHD, Quality.HD, Quality.SD), FallbackStrategy.higherQualityOrLowerThan(Quality.FHD));

    VideoSpec() {
    }

    public static @NonNull Builder builder() {
        return new AutoValue_VideoSpec.Builder().setQualitySelector(QUALITY_SELECTOR_AUTO).setEncodeFrameRate(0).setBitrate(BITRATE_RANGE_AUTO).setAspectRatio(-1);
    }

    public abstract @NonNull QualitySelector getQualitySelector();

    public abstract int getEncodeFrameRate();

    public abstract @NonNull Range<Integer> getBitrate();

    abstract int getAspectRatio();

    public abstract @NonNull Builder toBuilder();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract @NonNull Builder setQualitySelector(@NonNull QualitySelector var1);

        public abstract @NonNull Builder setEncodeFrameRate(int var1);

        public abstract @NonNull Builder setBitrate(@NonNull Range<Integer> var1);

        abstract @NonNull Builder setAspectRatio(int var1);

        public abstract @NonNull VideoSpec build();
    }
}

