/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.impl;

import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.ThreadConfig;
import androidx.camera.video.VideoCapture;
import androidx.camera.video.VideoOutput;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.core.util.Preconditions;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class VideoCaptureConfig<T extends VideoOutput>
implements UseCaseConfig<VideoCapture<T>>,
ImageOutputConfig,
ThreadConfig {
    public static final Config.Option<VideoOutput> OPTION_VIDEO_OUTPUT = Config.Option.create((String)"camerax.video.VideoCapture.videoOutput", VideoOutput.class);
    public static final Config.Option<VideoEncoderInfo.Finder> OPTION_VIDEO_ENCODER_INFO_FINDER = Config.Option.create((String)"camerax.video.VideoCapture.videoEncoderInfoFinder", VideoEncoderInfo.Finder.class);
    public static final Config.Option<Boolean> OPTION_FORCE_ENABLE_SURFACE_PROCESSING = Config.Option.create((String)"camerax.video.VideoCapture.forceEnableSurfaceProcessing", Boolean.class);
    private final OptionsBundle mConfig;

    public VideoCaptureConfig(@NonNull OptionsBundle config) {
        Preconditions.checkArgument((boolean)config.containsOption(OPTION_VIDEO_OUTPUT));
        this.mConfig = config;
    }

    public @NonNull T getVideoOutput() {
        return (T)Objects.requireNonNull((VideoOutput)this.retrieveOption(OPTION_VIDEO_OUTPUT));
    }

    public  @NonNull VideoEncoderInfo.Finder getVideoEncoderInfoFinder() {
        return Objects.requireNonNull((VideoEncoderInfo.Finder)this.retrieveOption(OPTION_VIDEO_ENCODER_INFO_FINDER));
    }

    public boolean isSurfaceProcessingForceEnabled() {
        return Objects.requireNonNull((Boolean)this.retrieveOption(OPTION_FORCE_ENABLE_SURFACE_PROCESSING, false));
    }

    public int getInputFormat() {
        return 34;
    }

    public @NonNull Config getConfig() {
        return this.mConfig;
    }
}

