/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import android.util.Rational;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BackupHdrProfileEncoderProfilesProvider
implements EncoderProfilesProvider {
    private static final String TAG = "BackupHdrProfileEncoderProfilesProvider";
    private final EncoderProfilesProvider mEncoderProfilesProvider;
    private final VideoEncoderInfo.Finder mVideoEncoderInfoFinder;
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();

    public BackupHdrProfileEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        this.mEncoderProfilesProvider = provider;
        this.mVideoEncoderInfoFinder = videoEncoderInfoFinder;
    }

    public boolean hasProfile(int quality) {
        if (!this.mEncoderProfilesProvider.hasProfile(quality)) {
            return false;
        }
        return this.getProfilesInternal(quality) != null;
    }

    public @Nullable EncoderProfilesProxy getAll(int quality) {
        return this.getProfilesInternal(quality);
    }

    private @Nullable EncoderProfilesProxy getProfilesInternal(int quality) {
        if (this.mEncoderProfilesCache.containsKey(quality)) {
            return this.mEncoderProfilesCache.get(quality);
        }
        EncoderProfilesProxy profiles = null;
        if (this.mEncoderProfilesProvider.hasProfile(quality)) {
            EncoderProfilesProxy baseProfiles = this.mEncoderProfilesProvider.getAll(quality);
            profiles = this.appendBackupVideoProfile(baseProfiles, 1, 10);
            this.mEncoderProfilesCache.put(quality, profiles);
        }
        return profiles;
    }

    private @Nullable EncoderProfilesProxy appendBackupVideoProfile(@Nullable EncoderProfilesProxy baseProfiles, int targetHdrFormat, int targetBitDepth) {
        if (baseProfiles == null) {
            return null;
        }
        ArrayList<EncoderProfilesProxy.VideoProfileProxy> videoProfiles = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>(baseProfiles.getVideoProfiles());
        EncoderProfilesProxy.VideoProfileProxy sdrProfile = null;
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : baseProfiles.getVideoProfiles()) {
            if (videoProfile.getHdrFormat() != 0) continue;
            sdrProfile = videoProfile;
            break;
        }
        EncoderProfilesProxy.VideoProfileProxy backupProfile = BackupHdrProfileEncoderProfilesProvider.generateBackupProfile(sdrProfile, targetHdrFormat, targetBitDepth);
        if ((backupProfile = BackupHdrProfileEncoderProfilesProvider.validateOrAdapt(backupProfile, this.mVideoEncoderInfoFinder)) != null) {
            videoProfiles.add(backupProfile);
        }
        return videoProfiles.isEmpty() ? null : EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)baseProfiles.getDefaultDurationSeconds(), (int)baseProfiles.getRecommendedFileFormat(), (List)baseProfiles.getAudioProfiles(), videoProfiles);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable EncoderProfilesProxy.VideoProfileProxy generateBackupProfile(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable EncoderProfilesProxy.VideoProfileProxy baseProfile, int targetHdrFormat, int targetBitDepth) {
        if (baseProfile == null) {
            return null;
        }
        int derivedCodec = baseProfile.getCodec();
        String derivedMediaType = baseProfile.getMediaType();
        int derivedProfile = baseProfile.getProfile();
        if (targetHdrFormat != baseProfile.getHdrFormat()) {
            derivedCodec = BackupHdrProfileEncoderProfilesProvider.deriveCodec(targetHdrFormat);
            derivedMediaType = BackupHdrProfileEncoderProfilesProvider.deriveMediaType(derivedCodec);
            derivedProfile = BackupHdrProfileEncoderProfilesProvider.deriveProfile(targetHdrFormat);
        }
        int derivedBitrate = BackupHdrProfileEncoderProfilesProvider.scaleBitrate(baseProfile.getBitrate(), targetBitDepth, baseProfile.getBitDepth());
        return EncoderProfilesProxy.VideoProfileProxy.create((int)derivedCodec, (String)derivedMediaType, (int)derivedBitrate, (int)baseProfile.getFrameRate(), (int)baseProfile.getWidth(), (int)baseProfile.getHeight(), (int)derivedProfile, (int)targetBitDepth, (int)baseProfile.getChromaSubsampling(), (int)targetHdrFormat);
    }

    private static int deriveCodec(int hdrFormat) {
        switch (hdrFormat) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Unexpected HDR format: " + hdrFormat);
    }

    private static int deriveProfile(int hdrFormat) {
        switch (hdrFormat) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4096;
            }
            case 3: {
                return 8192;
            }
            case 4: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Unexpected HDR format: " + hdrFormat);
    }

    private static @NonNull String deriveMediaType(int codec) {
        return EncoderProfilesProxy.getVideoCodecMimeType((int)codec);
    }

    private static int scaleBitrate(int baseBitrate, int actualBitDepth, int baseBitDepth) {
        if (actualBitDepth == baseBitDepth) {
            return baseBitrate;
        }
        Rational bitDepthRatio = new Rational(actualBitDepth, baseBitDepth);
        int resolvedBitrate = (int)((double)baseBitrate * bitDepthRatio.doubleValue());
        if (Logger.isDebugEnabled((String)TAG)) {
            String debugString = String.format("Base Bitrate(%dbps) * Bit Depth Ratio (%d / %d) = %d", baseBitrate, actualBitDepth, baseBitDepth, resolvedBitrate);
            Logger.d((String)TAG, (String)debugString);
        }
        return resolvedBitrate;
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable EncoderProfilesProxy.VideoProfileProxy validateOrAdapt(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable EncoderProfilesProxy.VideoProfileProxy profile, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        if (profile == null) {
            return null;
        }
        VideoEncoderInfo videoEncoderInfo = videoEncoderInfoFinder.find(profile.getMediaType());
        if (videoEncoderInfo == null || !videoEncoderInfo.isSizeSupportedAllowSwapping(profile.getWidth(), profile.getHeight())) {
            return null;
        }
        int baseBitrate = profile.getBitrate();
        int newBitrate = (Integer)videoEncoderInfo.getSupportedBitrateRange().clamp((Comparable)Integer.valueOf(baseBitrate));
        return newBitrate == baseBitrate ? profile : BackupHdrProfileEncoderProfilesProvider.modifyBitrate(profile, newBitrate);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EncoderProfilesProxy.VideoProfileProxy modifyBitrate(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EncoderProfilesProxy.VideoProfileProxy baseProfile, int newBitrate) {
        return EncoderProfilesProxy.VideoProfileProxy.create((int)baseProfile.getCodec(), (String)baseProfile.getMediaType(), (int)newBitrate, (int)baseProfile.getFrameRate(), (int)baseProfile.getWidth(), (int)baseProfile.getHeight(), (int)baseProfile.getProfile(), (int)baseProfile.getBitDepth(), (int)baseProfile.getChromaSubsampling(), (int)baseProfile.getHdrFormat());
    }
}

