/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.video.internal.utils.DynamicRangeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DynamicRangeMatchedEncoderProfilesProvider
implements EncoderProfilesProvider {
    private final EncoderProfilesProvider mEncoderProfilesProvider;
    private final DynamicRange mDynamicRange;
    private final Map<Integer, EncoderProfilesProxy> mEncoderProfilesCache = new HashMap<Integer, EncoderProfilesProxy>();

    public DynamicRangeMatchedEncoderProfilesProvider(@NonNull EncoderProfilesProvider provider, @NonNull DynamicRange dynamicRange) {
        this.mEncoderProfilesProvider = provider;
        this.mDynamicRange = dynamicRange;
    }

    public boolean hasProfile(int quality) {
        if (!this.mEncoderProfilesProvider.hasProfile(quality)) {
            return false;
        }
        return this.getProfilesInternal(quality) != null;
    }

    public @Nullable EncoderProfilesProxy getAll(int quality) {
        return this.getProfilesInternal(quality);
    }

    private @Nullable EncoderProfilesProxy getProfilesInternal(int quality) {
        if (this.mEncoderProfilesCache.containsKey(quality)) {
            return this.mEncoderProfilesCache.get(quality);
        }
        EncoderProfilesProxy profiles = null;
        if (this.mEncoderProfilesProvider.hasProfile(quality)) {
            EncoderProfilesProxy baseProfiles = this.mEncoderProfilesProvider.getAll(quality);
            profiles = DynamicRangeMatchedEncoderProfilesProvider.filterUnmatchedDynamicRange(baseProfiles, this.mDynamicRange);
            this.mEncoderProfilesCache.put(quality, profiles);
        }
        return profiles;
    }

    private static @Nullable EncoderProfilesProxy filterUnmatchedDynamicRange(@Nullable EncoderProfilesProxy encoderProfiles, @NonNull DynamicRange dynamicRange) {
        if (encoderProfiles == null) {
            return null;
        }
        ArrayList<EncoderProfilesProxy.VideoProfileProxy> validVideoProfiles = new ArrayList<EncoderProfilesProxy.VideoProfileProxy>();
        for (EncoderProfilesProxy.VideoProfileProxy videoProfile : encoderProfiles.getVideoProfiles()) {
            if (!DynamicRangeUtil.isHdrSettingsMatched(videoProfile, dynamicRange)) continue;
            validVideoProfiles.add(videoProfile);
        }
        return validVideoProfiles.isEmpty() ? null : EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)encoderProfiles.getDefaultDurationSeconds(), (int)encoderProfiles.getRecommendedFileFormat(), (List)encoderProfiles.getAudioProfiles(), validVideoProfiles);
    }
}

