/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal;

import android.net.Uri;
import androidx.camera.core.Logger;
import androidx.camera.video.FileDescriptorOutputOptions;
import androidx.camera.video.FileOutputOptions;
import androidx.camera.video.MediaStoreOutputOptions;
import androidx.camera.video.OutputOptions;
import androidx.camera.video.internal.OutputStorage;
import androidx.camera.video.internal.utils.StorageUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/camera/video/internal/OutputStorageImpl;", "Landroidx/camera/video/internal/OutputStorage;", "outputOptions", "Landroidx/camera/video/OutputOptions;", "<init>", "(Landroidx/camera/video/OutputOptions;)V", "getOutputOptions", "getAvailableBytes", "", "Companion", "camera-video_release"})
public final class OutputStorageImpl
implements OutputStorage {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputOptions outputOptions;
    @NotNull
    private static final String TAG = "OutputStorageImpl";

    public OutputStorageImpl(@NotNull OutputOptions outputOptions) {
        Intrinsics.checkNotNullParameter((Object)outputOptions, (String)"outputOptions");
        this.outputOptions = outputOptions;
    }

    @Override
    @NotNull
    public OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    @Override
    public long getAvailableBytes() {
        long l;
        try {
            long l2;
            OutputOptions outputOptions = this.outputOptions;
            if (outputOptions instanceof FileOutputOptions) {
                File file = ((FileOutputOptions)this.outputOptions).getFile().getParentFile();
                Intrinsics.checkNotNull((Object)file);
                l2 = StorageUtil.getAvailableBytes(file);
            } else if (outputOptions instanceof MediaStoreOutputOptions) {
                Uri uri = ((MediaStoreOutputOptions)this.outputOptions).getCollectionUri();
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getCollectionUri(...)");
                l2 = StorageUtil.getAvailableBytesForMediaStoreUri(uri);
            } else if (outputOptions instanceof FileDescriptorOutputOptions) {
                l2 = Long.MAX_VALUE;
            } else {
                throw new AssertionError((Object)("Unknown OutputOptions: " + this.outputOptions));
            }
            l = l2;
        }
        catch (RuntimeException e) {
            Logger.w((String)TAG, (String)"Fail to access the available bytes.", (Throwable)e);
            l = Long.MAX_VALUE;
        }
        return l;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/camera/video/internal/OutputStorageImpl$Companion;", "", "<init>", "()V", "TAG", "", "camera-video_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

