/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.audio;

import android.annotation.SuppressLint;
import androidx.annotation.IntRange;
import androidx.camera.video.internal.audio.AudioUtils;
import androidx.camera.video.internal.audio.AutoValue_AudioSettings;
import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;

@AutoValue
public abstract class AudioSettings {
    public static final List<Integer> COMMON_SAMPLE_RATES = Collections.unmodifiableList(Arrays.asList(192000, 48000, 44100, 24000, 22050, 16000, 12000, 11025, 8000, 4800));

    @SuppressLint(value={"Range"})
    public static @NonNull Builder builder() {
        return new AutoValue_AudioSettings.Builder().setAudioSource(-1).setCaptureSampleRate(-1).setEncodeSampleRate(-1).setChannelCount(-1).setAudioFormat(-1);
    }

    public abstract @NonNull Builder toBuilder();

    public abstract int getAudioSource();

    @IntRange(from=1L)
    public abstract int getCaptureSampleRate();

    @IntRange(from=1L)
    public abstract int getEncodeSampleRate();

    @IntRange(from=1L)
    public abstract int getChannelCount();

    public abstract int getAudioFormat();

    AudioSettings() {
    }

    public int getBytesPerFrame() {
        return AudioUtils.getBytesPerFrame(this.getAudioFormat(), this.getChannelCount());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @NonNull Builder setAudioSource(int var1);

        public abstract @NonNull Builder setCaptureSampleRate(@IntRange(from=1L) int var1);

        public abstract @NonNull Builder setEncodeSampleRate(@IntRange(from=1L) int var1);

        public abstract @NonNull Builder setChannelCount(@IntRange(from=1L) int var1);

        public abstract @NonNull Builder setAudioFormat(int var1);

        abstract AudioSettings autoBuild();

        public final @NonNull AudioSettings build() {
            AudioSettings settings = this.autoBuild();
            String missingOrInvalid = "";
            if (settings.getAudioSource() == -1) {
                missingOrInvalid = missingOrInvalid + " audioSource";
            }
            if (settings.getCaptureSampleRate() <= 0) {
                missingOrInvalid = missingOrInvalid + " captureSampleRate";
            }
            if (settings.getEncodeSampleRate() <= 0) {
                missingOrInvalid = missingOrInvalid + " encodeSampleRate";
            }
            if (settings.getChannelCount() <= 0) {
                missingOrInvalid = missingOrInvalid + " channelCount";
            }
            if (settings.getAudioFormat() == -1) {
                missingOrInvalid = missingOrInvalid + " audioFormat";
            }
            if (!missingOrInvalid.isEmpty()) {
                throw new IllegalArgumentException("Required settings missing or non-positive:" + missingOrInvalid);
            }
            return settings;
        }

        Builder() {
        }
    }
}

