/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.audio;

import androidx.annotation.IntRange;
import androidx.camera.video.internal.audio.AudioSettings;

final class AutoValue_AudioSettings
extends AudioSettings {
    private final int audioSource;
    private final int captureSampleRate;
    private final int encodeSampleRate;
    private final int channelCount;
    private final int audioFormat;

    private AutoValue_AudioSettings(int audioSource, int captureSampleRate, int encodeSampleRate, int channelCount, int audioFormat) {
        this.audioSource = audioSource;
        this.captureSampleRate = captureSampleRate;
        this.encodeSampleRate = encodeSampleRate;
        this.channelCount = channelCount;
        this.audioFormat = audioFormat;
    }

    @Override
    public int getAudioSource() {
        return this.audioSource;
    }

    @Override
    @IntRange(from=1L)
    public int getCaptureSampleRate() {
        return this.captureSampleRate;
    }

    @Override
    @IntRange(from=1L)
    public int getEncodeSampleRate() {
        return this.encodeSampleRate;
    }

    @Override
    @IntRange(from=1L)
    public int getChannelCount() {
        return this.channelCount;
    }

    @Override
    public int getAudioFormat() {
        return this.audioFormat;
    }

    public String toString() {
        return "AudioSettings{audioSource=" + this.audioSource + ", captureSampleRate=" + this.captureSampleRate + ", encodeSampleRate=" + this.encodeSampleRate + ", channelCount=" + this.channelCount + ", audioFormat=" + this.audioFormat + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AudioSettings) {
            AudioSettings that = (AudioSettings)o;
            return this.audioSource == that.getAudioSource() && this.captureSampleRate == that.getCaptureSampleRate() && this.encodeSampleRate == that.getEncodeSampleRate() && this.channelCount == that.getChannelCount() && this.audioFormat == that.getAudioFormat();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.audioSource;
        h$ *= 1000003;
        h$ ^= this.captureSampleRate;
        h$ *= 1000003;
        h$ ^= this.encodeSampleRate;
        h$ *= 1000003;
        h$ ^= this.channelCount;
        h$ *= 1000003;
        return h$ ^= this.audioFormat;
    }

    @Override
    public AudioSettings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AudioSettings.Builder {
        private Integer audioSource;
        private Integer captureSampleRate;
        private Integer encodeSampleRate;
        private Integer channelCount;
        private Integer audioFormat;

        Builder() {
        }

        private Builder(AudioSettings source) {
            this.audioSource = source.getAudioSource();
            this.captureSampleRate = source.getCaptureSampleRate();
            this.encodeSampleRate = source.getEncodeSampleRate();
            this.channelCount = source.getChannelCount();
            this.audioFormat = source.getAudioFormat();
        }

        @Override
        public AudioSettings.Builder setAudioSource(int audioSource) {
            this.audioSource = audioSource;
            return this;
        }

        @Override
        public AudioSettings.Builder setCaptureSampleRate(int captureSampleRate) {
            this.captureSampleRate = captureSampleRate;
            return this;
        }

        @Override
        public AudioSettings.Builder setEncodeSampleRate(int encodeSampleRate) {
            this.encodeSampleRate = encodeSampleRate;
            return this;
        }

        @Override
        public AudioSettings.Builder setChannelCount(int channelCount) {
            this.channelCount = channelCount;
            return this;
        }

        @Override
        public AudioSettings.Builder setAudioFormat(int audioFormat) {
            this.audioFormat = audioFormat;
            return this;
        }

        @Override
        AudioSettings autoBuild() {
            String missing = "";
            if (this.audioSource == null) {
                missing = missing + " audioSource";
            }
            if (this.captureSampleRate == null) {
                missing = missing + " captureSampleRate";
            }
            if (this.encodeSampleRate == null) {
                missing = missing + " encodeSampleRate";
            }
            if (this.channelCount == null) {
                missing = missing + " channelCount";
            }
            if (this.audioFormat == null) {
                missing = missing + " audioFormat";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AudioSettings(this.audioSource, this.captureSampleRate, this.encodeSampleRate, this.channelCount, this.audioFormat);
        }
    }
}

