/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import androidx.camera.core.Logger;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.QuirkSettingsHolder;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.video.internal.compat.quirk.DeviceQuirksLoader;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DeviceQuirks {
    private static final String TAG = "DeviceQuirks";
    private static volatile @NonNull Quirks sQuirks;

    private DeviceQuirks() {
    }

    public static @NonNull Quirks getAll() {
        return sQuirks;
    }

    public static <T extends Quirk> @Nullable T get(@NonNull Class<T> quirkClass) {
        return (T)sQuirks.get(quirkClass);
    }

    public static <T extends Quirk> @NonNull List<T> getAll(@NonNull Class<T> quirkClass) {
        return sQuirks.getAll(quirkClass);
    }

    static {
        QuirkSettingsHolder.instance().observe(CameraXExecutors.directExecutor(), quirkSettings -> {
            sQuirks = new Quirks(DeviceQuirksLoader.loadQuirks(quirkSettings));
            Logger.d((String)TAG, (String)("video DeviceQuirks = " + Quirks.toString((Quirks)sQuirks)));
        });
    }
}

