/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.video.Quality;
import androidx.camera.video.internal.compat.quirk.VideoQualityQuirk;
import org.jspecify.annotations.NonNull;

public class ExcludeStretchedVideoQualityQuirk
implements VideoQualityQuirk {
    static boolean load() {
        return ExcludeStretchedVideoQualityQuirk.isSamsungJ2() || ExcludeStretchedVideoQualityQuirk.isSamsungJ4() || ExcludeStretchedVideoQualityQuirk.isSamsungJ5() || ExcludeStretchedVideoQualityQuirk.isSamsungJ6() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7Nxt() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7PrimeApi27Above() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7Api27Above();
    }

    private static boolean isSamsungJ2() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J260F".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isSamsungJ4() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J400G".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isSamsungJ5() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J530F".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isSamsungJ6() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "sm-j600g".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isSamsungJ7Nxt() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J701F".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isSamsungJ7PrimeApi27Above() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-G610M".equalsIgnoreCase(Build.MODEL) && Build.VERSION.SDK_INT >= 27;
    }

    private static boolean isSamsungJ7Api27Above() {
        return "Samsung".equalsIgnoreCase(Build.BRAND) && "SM-J710MN".equalsIgnoreCase(Build.MODEL) && Build.VERSION.SDK_INT >= 27;
    }

    @Override
    public boolean isProblematicVideoQuality(@NonNull CameraInfoInternal cameraInfo, @NonNull Quality quality) {
        if (ExcludeStretchedVideoQualityQuirk.isSamsungJ4()) {
            return quality == Quality.FHD || quality == Quality.UHD;
        }
        if (ExcludeStretchedVideoQualityQuirk.isSamsungJ2() || ExcludeStretchedVideoQualityQuirk.isSamsungJ5() || ExcludeStretchedVideoQualityQuirk.isSamsungJ6() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7Nxt() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7PrimeApi27Above() || ExcludeStretchedVideoQualityQuirk.isSamsungJ7Api27Above()) {
            return quality == Quality.FHD;
        }
        return false;
    }
}

