/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.os.Build;
import android.util.Range;
import android.util.Size;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.EncoderProfilesProxy;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.camera.video.VideoSpec;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import androidx.camera.video.internal.utils.EncoderProfilesUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ExtraSupportedQualityQuirk
implements Quirk {
    private static final String MOTO_C_FRONT_CAM_ID = "1";

    static boolean load() {
        return ExtraSupportedQualityQuirk.isMotoC();
    }

    private static boolean isMotoC() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto c".equalsIgnoreCase(Build.MODEL);
    }

    public @Nullable Map<Integer, EncoderProfilesProxy> getExtraEncoderProfiles(@NonNull CameraInfoInternal cameraInfo, @NonNull EncoderProfilesProvider encoderProfilesProvider, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        if (ExtraSupportedQualityQuirk.isMotoC()) {
            return this.getExtraEncoderProfilesForMotoC(cameraInfo, encoderProfilesProvider, videoEncoderInfoFinder);
        }
        return Collections.emptyMap();
    }

    private @Nullable Map<Integer, EncoderProfilesProxy> getExtraEncoderProfilesForMotoC(@NonNull CameraInfoInternal cameraInfo, @NonNull EncoderProfilesProvider encoderProfilesProvider, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        if (!MOTO_C_FRONT_CAM_ID.equals(cameraInfo.getCameraId()) || encoderProfilesProvider.hasProfile(4)) {
            return null;
        }
        EncoderProfilesProxy profilesHigh = encoderProfilesProvider.getAll(1);
        EncoderProfilesProxy.VideoProfileProxy videoProfileHigh = EncoderProfilesUtil.getFirstVideoProfile(profilesHigh);
        if (videoProfileHigh == null) {
            return null;
        }
        Range<Integer> supportedBitrateRange = ExtraSupportedQualityQuirk.getSupportedBitrateRange(videoProfileHigh, videoEncoderInfoFinder);
        EncoderProfilesProxy.VideoProfileProxy derivedVideoProfile = EncoderProfilesUtil.deriveVideoProfile(videoProfileHigh, SizeUtil.RESOLUTION_480P, supportedBitrateRange);
        EncoderProfilesProxy.ImmutableEncoderProfilesProxy profiles480p = EncoderProfilesProxy.ImmutableEncoderProfilesProxy.create((int)profilesHigh.getDefaultDurationSeconds(), (int)profilesHigh.getRecommendedFileFormat(), (List)profilesHigh.getAudioProfiles(), Collections.singletonList(derivedVideoProfile));
        HashMap<Integer, EncoderProfilesProxy> extraEncoderProfilesMap = new HashMap<Integer, EncoderProfilesProxy>();
        extraEncoderProfilesMap.put(4, (EncoderProfilesProxy)profiles480p);
        Size sizeHigh = videoProfileHigh.getResolution();
        if (SizeUtil.getArea((Size)SizeUtil.RESOLUTION_480P) > SizeUtil.getArea((Size)sizeHigh)) {
            extraEncoderProfilesMap.put(1, (EncoderProfilesProxy)profiles480p);
        }
        return extraEncoderProfilesMap;
    }

    private static @NonNull Range<Integer> getSupportedBitrateRange(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EncoderProfilesProxy.VideoProfileProxy videoProfile, @NonNull VideoEncoderInfo.Finder videoEncoderInfoFinder) {
        VideoEncoderInfo encoderInfo = videoEncoderInfoFinder.find(videoProfile.getMediaType());
        return encoderInfo != null ? encoderInfo.getSupportedBitrateRange() : VideoSpec.BITRATE_RANGE_AUTO;
    }
}

