/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.media.MediaFormat;
import android.os.Build;
import android.util.Size;
import androidx.camera.core.impl.Quirk;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MediaCodecInfoReportIncorrectInfoQuirk
implements Quirk {
    public static final List<String> INCORRECT_FHD_PROFILE_MODEL_LIST = Arrays.asList("lg-k430", "redmi note 4", "m2003j15sc", "m2004j19c", "rmx3231", "v2117", "sm-a032f", "moto g(20)", "sm-a035m", "v2204", "23078pnd5g", "pht110", "23053rn02l", "rmx3710", "rmx3511", "v2207", "moto e20");

    static boolean load() {
        return MediaCodecInfoReportIncorrectInfoQuirk.isNokia1() || MediaCodecInfoReportIncorrectInfoQuirk.isMotoC() || MediaCodecInfoReportIncorrectInfoQuirk.isX650() || MediaCodecInfoReportIncorrectInfoQuirk.isX230() || MediaCodecInfoReportIncorrectInfoQuirk.isHuaweiMate9() || MediaCodecInfoReportIncorrectInfoQuirk.isRedmiNote8Pro() || MediaCodecInfoReportIncorrectInfoQuirk.isPositivoTwist2Pro() || MediaCodecInfoReportIncorrectInfoQuirk.isFHDProblematicDevice();
    }

    private static boolean isNokia1() {
        return "Nokia".equalsIgnoreCase(Build.BRAND) && "Nokia 1".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isMotoC() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto c".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isX650() {
        return "infinix".equalsIgnoreCase(Build.BRAND) && "infinix x650".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isX230() {
        return "LGE".equalsIgnoreCase(Build.BRAND) && "LG-X230".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isHuaweiMate9() {
        return "Huawei".equalsIgnoreCase(Build.BRAND) && "mha-l29".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isRedmiNote8Pro() {
        return "Redmi".equalsIgnoreCase(Build.BRAND) && "Redmi Note 8 Pro".equalsIgnoreCase(Build.MODEL);
    }

    private static boolean isPositivoTwist2Pro() {
        return "positivo".equalsIgnoreCase(Build.BRAND) && "twist 2 pro".equalsIgnoreCase(Build.MODEL);
    }

    public boolean isUnSupportMediaCodecInfo(@NonNull MediaFormat mediaFormat) {
        MediaFormatResolver formatResolver = new MediaFormatResolver(mediaFormat);
        if (MediaCodecInfoReportIncorrectInfoQuirk.isNokia1() || MediaCodecInfoReportIncorrectInfoQuirk.isMotoC() || MediaCodecInfoReportIncorrectInfoQuirk.isX650() || MediaCodecInfoReportIncorrectInfoQuirk.isX230() || MediaCodecInfoReportIncorrectInfoQuirk.isPositivoTwist2Pro()) {
            return formatResolver.isMpeg4();
        }
        if (MediaCodecInfoReportIncorrectInfoQuirk.isHuaweiMate9() || MediaCodecInfoReportIncorrectInfoQuirk.isRedmiNote8Pro()) {
            return formatResolver.isVideo() && formatResolver.isSize(3840, 2160);
        }
        if (MediaCodecInfoReportIncorrectInfoQuirk.isFHDProblematicDevice()) {
            return formatResolver.isAvc() && formatResolver.isSize(1920, 1080);
        }
        return false;
    }

    public static @NonNull Set<Size> getExtraSupportedSizes() {
        if (MediaCodecInfoReportIncorrectInfoQuirk.isFHDProblematicDevice()) {
            return Collections.singleton(new Size(1920, 1080));
        }
        return Collections.emptySet();
    }

    private static boolean isFHDProblematicDevice() {
        return INCORRECT_FHD_PROFILE_MODEL_LIST.contains(Build.MODEL.toLowerCase(Locale.US));
    }

    private static class MediaFormatResolver {
        private final MediaFormat mMediaFormat;

        MediaFormatResolver(@NonNull MediaFormat mediaFormat) {
            this.mMediaFormat = mediaFormat;
        }

        boolean isVideo() {
            String mimeType = this.getMime();
            return mimeType != null && mimeType.contains("video/");
        }

        boolean isAvc() {
            return "video/avc".equalsIgnoreCase(this.getMime());
        }

        boolean isMpeg4() {
            return "video/mp4v-es".equalsIgnoreCase(this.getMime());
        }

        boolean isSize(int width, int height) {
            int formatWidth = this.mMediaFormat.getInteger("width");
            int formatHeight = this.mMediaFormat.getInteger("height");
            return formatWidth == width && formatHeight == height;
        }

        private @Nullable String getMime() {
            return this.mMediaFormat.getString("mime");
        }
    }
}

