/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.compat.quirk;

import android.graphics.Rect;
import android.os.Build;
import android.util.Size;
import androidx.camera.core.impl.Quirk;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.video.internal.encoder.VideoEncoderInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SizeCannotEncodeVideoQuirk
implements Quirk {
    static boolean load() {
        return SizeCannotEncodeVideoQuirk.isMotoC();
    }

    private static boolean isMotoC() {
        return "motorola".equalsIgnoreCase(Build.BRAND) && "moto c".equalsIgnoreCase(Build.MODEL);
    }

    private static @NonNull Set<Size> getProblematicSizes() {
        if (SizeCannotEncodeVideoQuirk.isMotoC()) {
            return new HashSet<Size>(Collections.singletonList(new Size(720, 1280)));
        }
        return Collections.emptySet();
    }

    public boolean isProblematicEncodeSize(@NonNull Size size) {
        return SizeCannotEncodeVideoQuirk.getProblematicSizes().contains(size);
    }

    public @NonNull Rect adjustCropRectForProblematicEncodeSize(@NonNull Rect cropRectWithoutRotation, int rotationDegrees, @Nullable VideoEncoderInfo videoEncoderInfo) {
        Size sizeToEncode = TransformUtils.rotateSize((Size)TransformUtils.rectToSize((Rect)cropRectWithoutRotation), (int)rotationDegrees);
        if (!this.isProblematicEncodeSize(sizeToEncode)) {
            return cropRectWithoutRotation;
        }
        int halfAlignment = videoEncoderInfo != null ? videoEncoderInfo.getHeightAlignment() / 2 : 8;
        Rect rectToAdjust = new Rect(cropRectWithoutRotation);
        if (cropRectWithoutRotation.width() == sizeToEncode.getHeight()) {
            rectToAdjust.left += halfAlignment;
            rectToAdjust.right -= halfAlignment;
        } else {
            rectToAdjust.top += halfAlignment;
            rectToAdjust.bottom -= halfAlignment;
        }
        return rectToAdjust;
    }
}

