/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.video.internal.config;

import android.util.Range;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.Timebase;
import androidx.camera.video.AudioSpec;
import androidx.camera.video.internal.audio.AudioSettings;
import androidx.camera.video.internal.config.AudioConfigUtil;
import androidx.camera.video.internal.encoder.AudioEncoderConfig;
import androidx.core.util.Supplier;
import org.jspecify.annotations.NonNull;

public final class AudioEncoderConfigDefaultResolver
implements Supplier<AudioEncoderConfig> {
    private static final String TAG = "AudioEncCfgDefaultRslvr";
    private final String mMimeType;
    private final int mAudioProfile;
    private final AudioSpec mAudioSpec;
    private final AudioSettings mAudioSettings;
    private final Timebase mInputTimeBase;
    private static final int AUDIO_BITRATE_BASE = 156000;
    private static final int AUDIO_CHANNEL_COUNT_BASE = 2;
    private static final int AUDIO_SAMPLE_RATE_BASE = 48000;

    public AudioEncoderConfigDefaultResolver(@NonNull String mimeType, int audioProfile, @NonNull Timebase inputTimebase, @NonNull AudioSpec audioSpec, @NonNull AudioSettings audioSettings) {
        this.mMimeType = mimeType;
        this.mAudioProfile = audioProfile;
        this.mInputTimeBase = inputTimebase;
        this.mAudioSpec = audioSpec;
        this.mAudioSettings = audioSettings;
    }

    public @NonNull AudioEncoderConfig get() {
        Range<Integer> audioSpecBitrateRange = this.mAudioSpec.getBitrate();
        Logger.d((String)TAG, (String)"Using fallback AUDIO bitrate");
        int resolvedBitrate = AudioConfigUtil.scaleAndClampBitrate(156000, this.mAudioSettings.getChannelCount(), 2, this.mAudioSettings.getEncodeSampleRate(), 48000, audioSpecBitrateRange);
        return AudioEncoderConfig.builder().setMimeType(this.mMimeType).setProfile(this.mAudioProfile).setInputTimebase(this.mInputTimeBase).setChannelCount(this.mAudioSettings.getChannelCount()).setCaptureSampleRate(this.mAudioSettings.getCaptureSampleRate()).setEncodeSampleRate(this.mAudioSettings.getEncodeSampleRate()).setBitrate(resolvedBitrate).build();
    }
}

